/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ui.preferences;

import java.io.File;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.ui.PTPUIPlugin;
import org.eclipse.ptp.ui.UIMessage;
import org.eclipse.ptp.ui.utils.SWTUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PTPPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String EMPTY_STRING = "";
    protected Text outputDirText = null;
    protected Button browseButton = null;
    protected IntegerFieldEditor storeLineField = null;
    private String outputDIR = "";
    private String defaultOutputDIR = "/tmp";
    private int storeLine = 100;
    protected WidgetListener listener = new WidgetListener();

    public PTPPreferencesPage() {
        this.setPreferenceStore(PTPUIPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)this.createGridLayout(1, true, 0, 0));
        composite.setLayoutData((Object)this.spanGridData(768, 2));
        this.createOutputContents(composite);
        this.loadSaved();
        this.defaultSetting();
        return composite;
    }

    protected Button createCheckButton(Composite parent, String label) {
        return this.createButton(parent, label, 16416);
    }

    protected Button createButton(Composite parent, String label, int type) {
        Button button = new Button(parent, type);
        button.setText(label);
        GridData data = new GridData();
        button.setLayoutData((Object)data);
        return button;
    }

    private void createOutputContents(Composite parent) {
        Group aGroup = new Group(parent, 16);
        aGroup.setLayout((Layout)this.createGridLayout(1, true, 10, 10));
        aGroup.setLayoutData((Object)this.spanGridData(768, 2));
        aGroup.setText(UIMessage.getResourceString("PTPPreferencesPage.group_output"));
        Composite outputComposite = new Composite((Composite)aGroup, 0);
        outputComposite.setLayout((Layout)this.createGridLayout(3, false, 0, 0));
        outputComposite.setLayoutData((Object)this.spanGridData(768, 5));
        new Label(outputComposite, 0).setText(UIMessage.getResourceString("PTPPreferencesPage.output_text"));
        this.outputDirText = new Text(outputComposite, 2052);
        this.outputDirText.setLayoutData((Object)new GridData(768));
        this.outputDirText.addModifyListener((ModifyListener)this.listener);
        this.browseButton = SWTUtil.createPushButton(outputComposite, UIMessage.getResourceString("PTPPreferencesPage.browseButton"), null);
        this.browseButton.addSelectionListener((SelectionListener)this.listener);
        Composite lineComposite = new Composite((Composite)aGroup, 0);
        lineComposite.setLayout((Layout)new FillLayout());
        lineComposite.setLayoutData((Object)this.spanGridData(768, 5));
        this.storeLineField = new IntegerFieldEditor("STORE_LINE", UIMessage.getResourceString("PTPPreferencesPage.store_line_text"), lineComposite);
        this.storeLineField.setPropertyChangeListener((IPropertyChangeListener)this.listener);
        this.storeLineField.setEmptyStringAllowed(false);
    }

    protected void defaultSetting() {
        this.outputDirText.setText(this.outputDIR);
        this.storeLineField.setStringValue(String.valueOf(this.storeLine));
    }

    private void loadSaved() {
        Preferences preferences = PTPCorePlugin.getDefault().getPluginPreferences();
        this.outputDIR = preferences.getString("OUTPUT_DIR");
        if (this.outputDIR.equals(EMPTY_STRING)) {
            this.outputDIR = this.defaultOutputDIR;
        }
        if (this.outputDIR != null) {
            this.outputDirText.setText(this.outputDIR);
        }
        this.storeLine = preferences.getInt("STORE_LINE");
        this.storeLineField.setStringValue(String.valueOf(this.storeLine));
    }

    public void init(IWorkbench workbench) {
    }

    public void dispose() {
        super.dispose();
    }

    public void performDefaults() {
        this.defaultSetting();
        this.updateApplyButton();
    }

    private void store() {
        this.outputDIR = this.outputDirText.getText();
        this.storeLine = this.storeLineField.getIntValue();
    }

    public boolean performOk() {
        this.store();
        Preferences preferences = PTPCorePlugin.getDefault().getPluginPreferences();
        preferences.setValue("OUTPUT_DIR", this.outputDIR);
        preferences.setValue("STORE_LINE", this.storeLine);
        PTPCorePlugin.getDefault().savePluginPreferences();
        File outputDirPath = new File(this.outputDIR);
        if (!outputDirPath.exists()) {
            outputDirPath.mkdir();
        }
        return true;
    }

    protected void handleOutputDirectoryBrowseButtonSelected() {
        String selectedDirPath;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setText(UIMessage.getResourceString("PTPPreferencesPage.Select_Output_Directory"));
        String currectDirPath = this.getFieldContent(this.outputDirText.getText());
        if (currectDirPath != null && (path = new File(currectDirPath)).exists()) {
            dialog.setFilterPath(currectDirPath);
        }
        if ((selectedDirPath = dialog.open()) != null) {
            this.outputDirText.setText(selectedDirPath);
        }
    }

    protected boolean isValidOutputSetting() {
        File parent;
        String name = this.getFieldContent(this.outputDirText.getText());
        if (name == null) {
            this.setErrorMessage(UIMessage.getResourceString("PTPPreferencesPage.Incorrect_Output_directory"));
            this.setValid(false);
            return false;
        }
        File path = new File(name);
        if (!(path.exists() || (parent = path.getParentFile()) != null && parent.exists())) {
            this.setErrorMessage(UIMessage.getResourceString("PTPPreferencesPage.Incorrect_Output_directory"));
            this.setValid(false);
            return false;
        }
        if (!this.storeLineField.isValid()) {
            this.setErrorMessage(this.storeLineField.getErrorMessage());
            this.setValid(false);
            return false;
        }
        return true;
    }

    protected void updatePreferencePage() {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (!this.isValidOutputSetting()) {
            return;
        }
        this.setValid(true);
    }

    protected String getFieldContent(String text) {
        if (text.trim().length() == 0 || text.equals(EMPTY_STRING)) {
            return null;
        }
        return text;
    }

    protected GridLayout createGridLayout(int columns, boolean isEqual, int mh, int mw) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = columns;
        gridLayout.makeColumnsEqualWidth = isEqual;
        gridLayout.marginHeight = mh;
        gridLayout.marginWidth = mw;
        return gridLayout;
    }

    protected GridData spanGridData(int style, int space) {
        GridData gd = null;
        gd = style == -1 ? new GridData() : new GridData(style);
        gd.horizontalSpan = space;
        return gd;
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener,
    IPropertyChangeListener {
        protected WidgetListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == PTPPreferencesPage.this.browseButton) {
                PTPPreferencesPage.this.handleOutputDirectoryBrowseButtonSelected();
            } else {
                PTPPreferencesPage.this.updatePreferencePage();
            }
        }

        public void modifyText(ModifyEvent evt) {
            PTPPreferencesPage.this.updatePreferencePage();
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("field_editor_is_valid")) {
                PTPPreferencesPage.this.updatePreferencePage();
            }
        }
    }
}

