/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ui.views;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.ptp.ui.IManager;
import org.eclipse.ptp.ui.PTPUIPlugin;
import org.eclipse.ptp.ui.model.IElement;
import org.eclipse.ptp.ui.model.IElementHandler;
import org.eclipse.ptp.ui.model.IElementSet;
import org.eclipse.ptp.ui.views.AbstractParallelView;
import org.eclipse.ptp.ui.views.ElementIconCanvas;
import org.eclipse.ptp.ui.views.IContentProvider;
import org.eclipse.ptp.ui.views.IIconCanvasActionListener;
import org.eclipse.ptp.ui.views.IImageProvider;
import org.eclipse.ptp.ui.views.IToolTipProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.progress.WorkbenchJob;

public abstract class AbstractParallelElementView
extends AbstractParallelView
implements IIconCanvasActionListener,
IToolTipProvider,
IImageProvider,
IContentProvider,
ISelectionChangedListener {
    protected final String DEFAULT_TITLE = "Parallel";
    protected IManager manager = null;
    protected IElementSet cur_element_set = null;
    protected int cur_set_size = 0;
    protected ElementIconCanvas canvas = null;
    protected final String EMPTY_TITLE = " ";
    protected Color registerColor = null;
    protected IconRefreshWorkbenchJob iconreFreshJob = new IconRefreshWorkbenchJob();
    private boolean debug = false;
    protected Preferences.IPropertyChangeListener propertyChangeListener = new Preferences.IPropertyChangeListener(){

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            final String preferenceType = event.getProperty();
            final Object value = event.getNewValue();
            if (value != null) {
                AbstractParallelElementView.this.showWhile(new Runnable(){

                    public void run() {
                        if (!(this).AbstractParallelElementView.this.canvas.isDisposed()) {
                            if (preferenceType.startsWith("icon")) {
                                IPreferenceStore store = PTPUIPlugin.getDefault().getPreferenceStore();
                                (this).AbstractParallelElementView.this.canvas.setIconSpace(store.getInt("icon_spacing_x"), store.getInt("icon_spacing_y"));
                                (this).AbstractParallelElementView.this.canvas.setIconSize(store.getInt("icon_width"), store.getInt("icon_height"));
                            } else if (preferenceType.equals("tt_show_all_time")) {
                                (this).AbstractParallelElementView.this.canvas.showTooltipAllthetime(new Boolean((String)value));
                            } else if (preferenceType.equals("tt_timeout")) {
                                (this).AbstractParallelElementView.this.canvas.setTooltipTimeout(new Long((String)value));
                            } else if (preferenceType.equals("tt_iswap")) {
                                (this).AbstractParallelElementView.this.canvas.setTooltipWrap(new Boolean((String)value));
                            }
                            (this).AbstractParallelElementView.this.canvas.resetCanvas();
                        }
                        AbstractParallelElementView.this.refresh(false);
                    }
                });
            }
        }
    };

    public AbstractParallelElementView(IManager manager) {
        this.manager = manager;
    }

    public void createPartControl(Composite parent) {
        this.registerPartListener();
        PTPUIPlugin.getDefault().getPluginPreferences().addPropertyChangeListener(this.propertyChangeListener);
        this.createView(parent);
        this.setContentDescription(" ");
        this.registerColor = this.getDisplay().getSystemColor(23);
    }

    public void setRegisterColor(Color color) {
        this.registerColor = color;
    }

    protected void createView(Composite parent) {
        this.createElementView(parent);
    }

    public IManager getUIManager() {
        return this.manager;
    }

    public IElementHandler getElementHandler(String id) {
        return this.manager.getElementHandler(id);
    }

    public IElementHandler getCurrentElementHandler() {
        return this.getElementHandler(this.getCurrentID());
    }

    protected void changeTitle(String title, String setName, int size) {
        this.changeTitle(" " + title + " - " + setName + " [" + size + "]");
    }

    protected void changeTitle(final String message) {
        this.asyncExec(new Runnable(){

            public void run() {
                AbstractParallelElementView.this.setContentDescription(message);
            }
        });
    }

    protected Composite createElementView(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        composite.setLayoutData((Object)new GridData(1808));
        composite.setBackground(this.getDisplay().getSystemColor(1));
        this.canvas = new ElementIconCanvas(this, composite, 0);
        this.canvas.setContentProvider(this);
        this.canvas.setImageProvider(this);
        this.canvas.setToolTipProvider(this);
        this.canvas.addActionListener(this);
        this.canvas.addSelectionChangedListener(this);
        return composite;
    }

    public void dispose() {
        this.canvas.removeActionListener(this);
        this.canvas.removeSelectionChangedListener(this);
        this.canvas.dispose();
        PTPUIPlugin.getDefault().getPluginPreferences().removePropertyChangeListener(this.propertyChangeListener);
        this.deregisterPartListener();
        super.dispose();
    }

    public void setFocus() {
        this.canvas.setFocus();
    }

    public String getCurrentSetID() {
        return this.manager.getCurrentSetId();
    }

    public void fireSetChangeEvent(IElementSet cur_set, IElementSet pre_set) {
        this.manager.fireSetEvent(2, null, cur_set, pre_set);
    }

    public void selectSet(IElementSet set) {
        if (!this.canvas.isDisposed()) {
            this.cur_set_size = 0;
            if (set != null) {
                this.cur_set_size = set.size();
                this.manager.setCurrentSetId(set.getID());
            }
            this.canvas.setElementSet(set);
            if (this.isVisible()) {
                this.fireSetChangeEvent(set, this.cur_element_set);
            }
            this.cur_element_set = set;
        }
    }

    public IElementSet getCurrentSet() {
        return this.cur_element_set;
    }

    public void build() {
        this.initialView();
    }

    public void refresh(boolean all, boolean force) {
        if (this.isVisible()) {
            this.iconreFreshJob.schedule(all, force);
        }
    }

    public void refresh(boolean all) {
        this.refresh(all, false);
    }

    public abstract void updateAction();

    protected abstract void initialView();

    protected abstract void initialElement();

    public abstract void update();

    public abstract void updateTitle();

    public abstract String getCurrentID();

    protected abstract void doubleClick(IElement var1);

    protected abstract Image getImage(int var1, int var2);

    protected abstract String[] getToolTipText(Object var1);

    protected abstract Object convertElementObject(IElement var1);

    public Object getObject(int index) {
        if (this.canvas != null && this.manager != null) {
            return this.canvas.getElement(index);
        }
        return null;
    }

    public String getRulerIndex(Object obj, int index) {
        return String.valueOf(index);
    }

    public String[] toolTipText(Object obj) {
        if (obj instanceof IElement) {
            return this.getToolTipText(this.convertElementObject((IElement)obj));
        }
        return new String[]{""};
    }

    public void update(Object obj, String content) {
        this.canvas.updateToolTipText(obj, content);
    }

    public Image getStatusIcon(Object obj, int index, boolean isSelected) {
        if (this.cur_element_set != null && obj instanceof IElement) {
            int status = this.manager.getStatus((IElement)obj, index);
            return this.getImage(status, isSelected ? 1 : 0);
        }
        return null;
    }

    public void drawSpecial(Object obj, int index, GC gc, int x_loc, int y_loc, int width, int height) {
        if (this.cur_element_set != null && obj instanceof IElement && ((IElement)obj).isRegistered()) {
            gc.setForeground(this.registerColor);
            gc.drawRectangle(x_loc, y_loc, width, height);
            gc.setForeground(this.canvas.getForeground());
        }
    }

    public void handleAction(int type, int index) {
        if (index > -1) {
            IElement element = this.canvas.getElement(index);
            switch (type) {
                case 5: {
                    this.doubleClick(element);
                }
            }
        }
    }

    public void setDisplayRuler(final boolean showRuler) {
        this.asyncExec(new Runnable(){

            public void run() {
                if (!AbstractParallelElementView.this.canvas.isDisposed()) {
                    AbstractParallelElementView.this.canvas.setDisplayRuler(showRuler);
                }
                AbstractParallelElementView.this.refresh(false);
            }
        });
    }

    public boolean isDisplayRuler() {
        if (!this.canvas.isDisposed()) {
            return this.canvas.isDisplayRuler();
        }
        return false;
    }

    public ISelection getSelection() {
        return this.canvas.getSelection();
    }

    class IconRefreshWorkbenchJob
    extends WorkbenchJob {
        private final ReentrantLock waitLock;
        private List<Boolean> refreshList;

        public IconRefreshWorkbenchJob() {
            super("Refreshing icons...");
            this.waitLock = new ReentrantLock();
            this.refreshList = new ArrayList<Boolean>();
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            boolean refreshAll = this.isRefreshAll();
            if (AbstractParallelElementView.this.debug) {
                System.err.println("---------- IconRefreshWorkbenchJob refresh: " + refreshAll);
            }
            AbstractParallelElementView.this.repaint(refreshAll);
            if (!AbstractParallelElementView.this.canvas.isDisposed()) {
                AbstractParallelElementView.this.canvas.redraw();
            }
            boolean lastValue = this.isRefreshAll();
            this.waitLock.lock();
            try {
                this.refreshList.clear();
                if (refreshAll != lastValue && !refreshAll) {
                    this.refreshList.add(new Boolean(true));
                    this.schedule();
                }
            }
            finally {
                this.waitLock.unlock();
            }
            return Status.OK_STATUS;
        }

        public boolean shouldSchedule() {
            int size = this.size();
            if (AbstractParallelElementView.this.debug) {
                System.err.println("---------- IconRefreshWorkbenchJob: " + this.refreshList.size());
            }
            return size == 1;
        }

        private int size() {
            this.waitLock.lock();
            try {
                int n = this.refreshList.size();
                return n;
            }
            finally {
                this.waitLock.unlock();
            }
        }

        private boolean isRefreshAll() {
            this.waitLock.lock();
            try {
                boolean bl = this.refreshList.get(this.refreshList.size() - 1);
                return bl;
            }
            finally {
                this.waitLock.unlock();
            }
        }

        public void schedule(boolean refresh_all, boolean force) {
            this.waitLock.lock();
            try {
                if (force) {
                    this.refreshList.clear();
                }
                this.refreshList.add(new Boolean(refresh_all));
            }
            finally {
                this.waitLock.unlock();
            }
            this.schedule();
        }
    }
}

