/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.elementcontrols.IResourceManagerControl;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.IResourceManagerFactory;
import org.eclipse.ptp.ui.PTPUIPlugin;
import org.eclipse.ptp.ui.UIMessage;
import org.eclipse.ptp.ui.wizards.RMConfigurationWizardPage;
import org.eclipse.ptp.ui.wizards.RMConfigurationWizardPageFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public class RMConfigurationWizard
extends Wizard {
    public static final String EMPTY_STRING = "";
    private RMConfigurationWizardPage[][] cachedPages;
    private final ArrayList<WizardPage> wizardPages = new ArrayList();
    private IResourceManagerConfiguration[] configs = null;
    private final SelectFactoryPage selectFactoryPage;
    private final IResourceManagerFactory[] factories;
    private final boolean hasFactories;
    private IResourceManagerFactory resourceManagerFactory;
    private boolean useDefaultNameAndDesc;
    private final NameAndDescPage nameAndDescPage;
    private int selectedFactory = -1;
    private IResourceManagerControl resourceManager;

    public RMConfigurationWizard(IResourceManagerFactory[] resourceManagerFactories) {
        this.setForcePreviousAndNextButtons(true);
        this.factories = resourceManagerFactories;
        this.hasFactories = this.factories != null && this.factories.length > 0;
        this.cachedPages = new RMConfigurationWizardPage[this.factories.length][];
        this.configs = new IResourceManagerConfiguration[this.factories.length];
        this.selectFactoryPage = new SelectFactoryPage(UIMessage.getResourceString("ConfigurationWizard.FirstWizardPageName"));
        this.nameAndDescPage = new NameAndDescPage(UIMessage.getResourceString("ConfigurationWizard.SecondWizardPageName"));
        this.useDefaultNameAndDesc = true;
        this.resourceManager = null;
    }

    public RMConfigurationWizard(IResourceManagerFactory resourceManagerFactory, IResourceManagerControl resourceManager) {
        this(new IResourceManagerFactory[]{resourceManagerFactory});
        this.configs[0] = resourceManagerFactory.copyConfiguration(resourceManager.getConfiguration());
        this.useDefaultNameAndDesc = false;
        this.resourceManager = resourceManager;
        this.factorySelected(0);
    }

    public void addPages() {
        if (this.resourceManager == null) {
            this.addPage((IWizardPage)this.selectFactoryPage);
        }
        this.addPage((IWizardPage)this.nameAndDescPage);
        super.addPages();
    }

    public boolean canFinish() {
        if (!this.hasFactories) {
            return false;
        }
        int numPages = this.getNumPages();
        int i = 0;
        while (i < numPages) {
            WizardPage page = this.wizardPages.get(i);
            if (!page.isPageComplete()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public IResourceManagerConfiguration getConfiguration() {
        return this.configs[this.selectedFactory];
    }

    public String getDescription() {
        return this.nameAndDescPage.descText.getText();
    }

    public String getName() {
        return this.nameAndDescPage.nameText.getText();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        int numPages = this.getNumPages();
        int index = this.wizardPages.indexOf(page);
        if (index == numPages - 1 || index == -1) {
            return null;
        }
        if (index == numPages - 2) {
            if (this.useDefaultNameAndDesc) {
                this.configs[this.selectedFactory].setDefaultNameAndDesc();
            }
            this.nameAndDescPage.setNameAndDescription(this.configs[this.selectedFactory]);
            this.nameAndDescPage.setEnabled(!this.useDefaultNameAndDesc);
        }
        return (IWizardPage)this.wizardPages.get(index + 1);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        int index = this.wizardPages.indexOf(page);
        if (index == 0 || index == -1) {
            return null;
        }
        return (IWizardPage)this.wizardPages.get(index - 1);
    }

    public boolean performFinish() {
        IResourceManagerConfiguration config = this.configs[this.selectedFactory];
        if (this.useDefaultNameAndDesc) {
            config.setDefaultNameAndDesc();
        }
        if (this.resourceManager != null) {
            this.resourceManager.setConfiguration(config);
            PTPCorePlugin.getDefault().getModelManager().saveResourceManagers();
        } else {
            IResourceManagerControl rm = this.resourceManagerFactory.create(config);
            PTPCorePlugin.getDefault().getModelManager().addResourceManager(rm);
        }
        Arrays.fill(this.configs, null);
        return true;
    }

    private void factorySelected(int selectedFactory) {
        this.selectedFactory = selectedFactory;
        this.resourceManagerFactory = this.factories[selectedFactory];
        if (this.configs[selectedFactory] == null) {
            this.configs[selectedFactory] = this.resourceManagerFactory.createConfiguration();
        }
        this.setWizardPages(selectedFactory);
    }

    private int getNumPages() {
        return this.wizardPages.size();
    }

    private void setWizardPages(int index) {
        if (this.cachedPages[index] == null) {
            PTPUIPlugin uiPlugin = PTPUIPlugin.getDefault();
            RMConfigurationWizardPageFactory factory = uiPlugin.getRMConfigurationWizardPageFactory(this.resourceManagerFactory);
            if (factory != null) {
                this.cachedPages[index] = factory.getPages(this);
            }
            if (this.cachedPages[index] == null) {
                this.cachedPages[index] = new RMConfigurationWizardPage[0];
            }
            int i = 0;
            while (i < this.cachedPages[index].length) {
                this.addPage((IWizardPage)this.cachedPages[index][i]);
                ++i;
            }
        }
        this.wizardPages.clear();
        if (this.resourceManager == null) {
            this.wizardPages.add(this.selectFactoryPage);
        }
        this.wizardPages.addAll((Collection<WizardPage>)Arrays.asList(this.cachedPages[index]));
        this.wizardPages.add(this.nameAndDescPage);
    }

    public class NameAndDescPage
    extends WizardPage {
        private Text descText;
        private Text nameText;

        public NameAndDescPage(String pageName) {
            super(pageName);
            this.setTitle(pageName);
            this.setDescription(UIMessage.getResourceString("ConfigurationWizard.NameDesc"));
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setFont(parent.getFont());
            composite.setLayout((Layout)new GridLayout());
            composite.setLayoutData((Object)new GridData(1808));
            this.createNameDescControl(composite);
            boolean textAndDescriptionEnabled = RMConfigurationWizard.this.hasFactories;
            this.nameText.setEnabled(textAndDescriptionEnabled);
            this.descText.setEnabled(textAndDescriptionEnabled);
            this.setControl((Control)composite);
        }

        private void createNameDescControl(Composite container) {
            Composite nameGroup = new Composite(container, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            nameGroup.setLayout((Layout)layout);
            nameGroup.setLayoutData((Object)new GridData(768));
            final Button useDefaultsButton = new Button(nameGroup, 34);
            useDefaultsButton.setText(UIMessage.getResourceString("ConfigurationWizard.UseDefaultButtonLabel"));
            useDefaultsButton.setSelection(RMConfigurationWizard.this.useDefaultNameAndDesc);
            GridData buttonData = new GridData();
            buttonData.horizontalSpan = 2;
            useDefaultsButton.setLayoutData((Object)buttonData);
            useDefaultsButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    boolean enabled;
                    RMConfigurationWizard.this.useDefaultNameAndDesc = useDefaultsButton.getSelection();
                    boolean bl = enabled = RMConfigurationWizard.this.hasFactories && !RMConfigurationWizard.this.useDefaultNameAndDesc;
                    if (RMConfigurationWizard.this.useDefaultNameAndDesc) {
                        RMConfigurationWizard.this.configs[RMConfigurationWizard.this.selectedFactory].setDefaultNameAndDesc();
                        NameAndDescPage.this.setNameAndDescription(RMConfigurationWizard.this.configs[RMConfigurationWizard.this.selectedFactory]);
                        NameAndDescPage.this.setPageComplete(true);
                        NameAndDescPage.this.setErrorMessage(null);
                    }
                    RMConfigurationWizard.this.nameAndDescPage.setEnabled(enabled);
                    NameAndDescPage.this.getContainer().updateButtons();
                }
            });
            Label nameLabel = new Label(nameGroup, 0);
            nameLabel.setText(UIMessage.getResourceString("ConfigurationWizard.NameLabel"));
            this.nameText = new Text(nameGroup, 2048);
            this.nameText.setLayoutData((Object)new GridData(768));
            this.nameText.setText(RMConfigurationWizard.EMPTY_STRING);
            this.nameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    RMConfigurationWizard.this.configs[RMConfigurationWizard.this.selectedFactory].setName(NameAndDescPage.this.nameText.getText());
                    if (NameAndDescPage.this.nameText.getText().equals(RMConfigurationWizard.EMPTY_STRING)) {
                        NameAndDescPage.this.setPageComplete(false);
                        NameAndDescPage.this.setErrorMessage("Please specify a resource manager name");
                    }
                }
            });
            Label descLabel = new Label(nameGroup, 0);
            descLabel.setText(UIMessage.getResourceString("ConfigurationWizard.DescriptionLabel"));
            this.descText = new Text(nameGroup, 2048);
            this.descText.setLayoutData((Object)new GridData(768));
            this.descText.setText(RMConfigurationWizard.EMPTY_STRING);
            this.descText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    RMConfigurationWizard.this.configs[RMConfigurationWizard.this.selectedFactory].setDescription(NameAndDescPage.this.descText.getText());
                }
            });
            this.setPageComplete(true);
        }

        private void setEnabled(boolean enabled) {
            this.nameText.setEnabled(enabled);
            this.descText.setEnabled(enabled);
        }

        private void setNameAndDescription(IResourceManagerConfiguration config) {
            this.nameText.setText(config.getName());
            this.descText.setText(config.getDescription());
        }
    }

    private class SelectFactoryPage
    extends WizardPage {
        private List factoryList;

        public SelectFactoryPage(String pageName) {
            super(pageName);
            this.setTitle(pageName);
            this.setDescription(UIMessage.getResourceString("ConfigurationWizard.SelectFactoryDesc"));
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setFont(parent.getFont());
            composite.setLayout((Layout)new GridLayout());
            composite.setLayoutData((Object)new GridData(1808));
            this.createRMFactoryChoiceControl(composite);
            if (RMConfigurationWizard.this.hasFactories) {
                parent.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        SelectFactoryPage.this.factoryList.select(0);
                        SelectFactoryPage.this.handleFactorySeclection();
                    }
                });
            }
            this.setControl((Control)composite);
        }

        private void createRMFactoryChoiceControl(Composite container) {
            String[] factoryNames = new String[RMConfigurationWizard.this.factories.length];
            int i = 0;
            while (i < RMConfigurationWizard.this.factories.length) {
                factoryNames[i] = RMConfigurationWizard.this.factories[i].getName();
                ++i;
            }
            Label factoryLabel = new Label(container, 0);
            factoryLabel.setText(UIMessage.getResourceString("ConfigurationWizard.ResourceManagerTypesLabel"));
            this.factoryList = new List(container, 2564);
            this.factoryList.setLayoutData((Object)new GridData(768));
            this.factoryList.setItems(factoryNames);
            this.factoryList.setEnabled(RMConfigurationWizard.this.hasFactories);
            this.factoryList.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    SelectFactoryPage.this.handleFactorySeclection();
                }
            });
        }

        private void handleFactorySeclection() {
            int index = this.factoryList.getSelectionIndex();
            RMConfigurationWizard.this.factorySelected(index);
            this.setPageComplete(true);
        }
    }
}

