/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.orte.core.rmsystem;

import org.eclipse.ptp.rm.orte.core.rmsystem.ORTEResourceManagerFactory;
import org.eclipse.ptp.rm.remote.core.AbstractRemoteResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.AbstractResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.ptp.rmsystem.IResourceManagerFactory;
import org.eclipse.ui.IMemento;

public final class ORTEResourceManagerConfiguration
extends AbstractRemoteResourceManagerConfiguration
implements Cloneable {
    public static final String EMPTY_STRING = "";
    private static final String TAG_ORTED_PATH = "ortedPath";
    private static final String TAG_ORTED_ARGS = "ortedArgs";
    private static final String TAG_ORTED_DEFAULTS = "ortedDefaults";
    private String ortedPath;
    private String ortedArgs;
    private boolean useDefaults;

    public static IResourceManagerConfiguration load(ORTEResourceManagerFactory factory, IMemento memento) {
        AbstractRemoteResourceManagerConfiguration.RemoteConfig remoteConfig = ORTEResourceManagerConfiguration.loadRemote((IResourceManagerFactory)factory, (IMemento)memento);
        String ortedPath = memento.getString(TAG_ORTED_PATH);
        String ortedArgs = memento.getString(TAG_ORTED_ARGS);
        boolean useDefaults = Boolean.parseBoolean(memento.getString(TAG_ORTED_DEFAULTS));
        ORTEResourceManagerConfiguration config = new ORTEResourceManagerConfiguration(factory, remoteConfig, ortedPath, ortedArgs, useDefaults);
        return config;
    }

    public ORTEResourceManagerConfiguration(ORTEResourceManagerFactory factory) {
        this(factory, new AbstractRemoteResourceManagerConfiguration.RemoteConfig(), EMPTY_STRING, EMPTY_STRING, true);
    }

    public ORTEResourceManagerConfiguration(ORTEResourceManagerFactory factory, AbstractRemoteResourceManagerConfiguration.RemoteConfig config, String ortedPath, String ortedArgs, boolean useDefaults) {
        super(config, (IResourceManagerFactory)factory);
        this.setOrtedPath(ortedPath);
        this.setOrtedArgs(ortedArgs);
        this.setUseDefaults(useDefaults);
    }

    public Object clone() {
        AbstractResourceManagerConfiguration.CommonConfig commonConf = new AbstractResourceManagerConfiguration.CommonConfig(this.getName(), this.getDescription(), this.getUniqueName());
        AbstractRemoteResourceManagerConfiguration.RemoteConfig remoteConf = new AbstractRemoteResourceManagerConfiguration.RemoteConfig(commonConf, this.getRemoteServicesId(), this.getConnectionName(), this.getProxyServerPath(), this.getLocalAddress(), this.getInvocationOptionsStr(), this.getOptions());
        return new ORTEResourceManagerConfiguration((ORTEResourceManagerFactory)this.getFactory(), remoteConf, this.getOrtedPath(), this.getOrtedArgs(), this.useDefaults());
    }

    public String getOrtedArgs() {
        return this.ortedArgs;
    }

    public String getOrtedPath() {
        return this.ortedPath;
    }

    public void save(IMemento memento) {
        super.save(memento);
        memento.putString(TAG_ORTED_PATH, this.ortedPath);
        memento.putString(TAG_ORTED_ARGS, this.ortedArgs);
        memento.putString(TAG_ORTED_DEFAULTS, Boolean.toString(this.useDefaults));
    }

    public void setDefaultNameAndDesc() {
        String name = "ORTE";
        String conn = this.getConnectionName();
        if (conn != null && !conn.equals(EMPTY_STRING)) {
            name = String.valueOf(name) + "@" + conn;
        }
        this.setName(name);
        this.setDescription("ORTE Resource Manager");
    }

    public void setOrtedArgs(String ortedArgs) {
        this.ortedArgs = ortedArgs;
    }

    public void setOrtedPath(String ortedPath) {
        this.ortedPath = ortedPath;
    }

    public void setUseDefaults(boolean useDefaults) {
        this.useDefaults = useDefaults;
    }

    public boolean useDefaults() {
        return this.useDefaults;
    }
}

