/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.environment.launcher.internal.macros;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.cdtvariables.ICdtVariable;
import org.eclipse.cdt.internal.core.cdtvariables.CoreMacroSupplierBase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.ptp.remotetools.environment.launcher.macros.ILaunchConfigurationVariableSupplier;
import org.eclipse.ptp.remotetools.utils.extensionpoints.IProcessMemberVisitor;
import org.eclipse.ptp.remotetools.utils.extensionpoints.ProcessExtensions;

public class LaunchMacroSupplier
extends CoreMacroSupplierBase {
    public static final String EXT_LAUNCH_CONFIGURATION_MACRO_SUPPLIER = "org.eclipse.ptp.remotetools.environment.launcher.launchConfigurationMacroSupplier";
    private static LaunchMacroSupplier instance;
    private final Map auxiliarySuppliers = new HashMap();
    private static final String CONFIG_TYPE_ID = "configTypeId";
    private static final String CLASS = "class";

    private LaunchMacroSupplier() {
    }

    public static LaunchMacroSupplier getInstance() {
        if (instance == null) {
            instance = new LaunchMacroSupplier();
        }
        return instance;
    }

    public ICdtVariable getMacro(String macroName, int contextType, Object contextData) {
        switch (contextType) {
            case 9: {
                if (!(contextData instanceof ILaunchConfiguration)) break;
                this.loadLaunchConfigurationMacroSuppliers();
                try {
                    ILaunchConfigurationType launchConfigurationType = ((ILaunchConfiguration)contextData).getType();
                    ILaunchConfigurationVariableSupplier launchConfigurationMacroSupplier = (ILaunchConfigurationVariableSupplier)this.auxiliarySuppliers.get(launchConfigurationType.getIdentifier());
                    return launchConfigurationMacroSupplier.getVariable(macroName, (ILaunchConfiguration)contextData);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public ICdtVariable[] getMacros(int contextType, Object contextData) {
        switch (contextType) {
            case 9: {
                if (!(contextData instanceof ILaunchConfiguration)) break;
                this.loadLaunchConfigurationMacroSuppliers();
                try {
                    ILaunchConfigurationType launchConfigurationType = ((ILaunchConfiguration)contextData).getType();
                    ILaunchConfigurationVariableSupplier launchConfigurationMacroSupplier = (ILaunchConfigurationVariableSupplier)this.auxiliarySuppliers.get(launchConfigurationType.getIdentifier());
                    return launchConfigurationMacroSupplier.getVariables((ILaunchConfiguration)contextData);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private void loadLaunchConfigurationMacroSuppliers() {
        if (this.auxiliarySuppliers.isEmpty()) {
            ProcessExtensions.process((String)EXT_LAUNCH_CONFIGURATION_MACRO_SUPPLIER, (IProcessMemberVisitor)new IProcessMemberVisitor(){

                public Object process(IExtension extension, IConfigurationElement member) {
                    try {
                        LaunchMacroSupplier.this.auxiliarySuppliers.put(member.getAttribute(LaunchMacroSupplier.CONFIG_TYPE_ID), member.createExecutableExtension(LaunchMacroSupplier.CLASS));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            });
        }
    }
}

