/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.utils.network;

import java.math.BigInteger;
import org.eclipse.ptp.remotetools.utils.network.MacAddressFormatException;

public class MacAddress {
    public static int MAX_BITS = 48;
    public static int HEXDIGITS = MAX_BITS / 4;
    public static int HEXBASE = 16;
    BigInteger mac;

    private MacAddress() {
    }

    public static MacAddress createMacAddress(String macString) throws MacAddressFormatException {
        MacAddress maddr = new MacAddress();
        maddr.mac = MacAddress.convertStringToInternalRepresentation(macString);
        return maddr;
    }

    public static MacAddress createMacAddress(BigInteger macNumber) {
        MacAddress maddr = new MacAddress();
        maddr.mac = MacAddress.convertBigIntegerToInternalRepresentation(macNumber);
        return maddr;
    }

    private static BigInteger convertBigIntegerToInternalRepresentation(BigInteger macNumber) {
        if (macNumber.signum() < 0) {
            macNumber = macNumber.negate();
        }
        if (macNumber.bitLength() > MAX_BITS) {
            String bigMacStr = macNumber.toString(HEXBASE);
            String macStr = bigMacStr.substring(bigMacStr.length() - 1 - HEXDIGITS, bigMacStr.length() - 1);
            macNumber = new BigInteger(macStr);
        }
        return macNumber;
    }

    private static BigInteger convertStringToInternalRepresentation(String macString) throws MacAddressFormatException {
        String trimmedMacString = macString.trim();
        boolean isValidMac = trimmedMacString.matches("^(\\p{XDigit}{2}:){5}\\p{XDigit}{2}$");
        if (!isValidMac) {
            throw new MacAddressFormatException("Invalid Mac Address format!");
        }
        String validMacString = trimmedMacString.replaceAll(":", "");
        return new BigInteger(validMacString, HEXBASE);
    }

    public void setValue(BigInteger macNumber) {
        this.mac = MacAddress.convertBigIntegerToInternalRepresentation(macNumber);
    }

    public void setValue(String macString) throws MacAddressFormatException {
        this.mac = MacAddress.convertStringToInternalRepresentation(macString);
    }

    public BigInteger getBigIntegerRepresentation() {
        return this.mac;
    }

    public String getStringRepresentation() {
        int i;
        String strRep = this.mac.toString(HEXBASE);
        if (strRep.length() < HEXDIGITS) {
            StringBuffer zeroStr = new StringBuffer();
            i = 0;
            while (i < HEXDIGITS - strRep.length()) {
                zeroStr.append("0");
                ++i;
            }
            strRep = new String(zeroStr + strRep);
        }
        StringBuffer hexRep = new StringBuffer();
        i = 0;
        while (i < HEXDIGITS - 2) {
            hexRep.append(String.valueOf(strRep.substring(i, i + 2)) + ":");
            i += 2;
        }
        hexRep.append(strRep.substring(HEXDIGITS - 2, HEXDIGITS));
        return hexRep.toString();
    }
}

