/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ui.consoles;

import org.eclipse.ptp.core.attributes.EnumeratedAttribute;
import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.attributes.IntegerAttribute;
import org.eclipse.ptp.core.attributes.StringAttribute;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.IPProcess;
import org.eclipse.ptp.core.elements.attributes.ProcessAttributes;
import org.eclipse.ptp.core.elements.events.IChangedProcessEvent;
import org.eclipse.ptp.core.elements.events.INewProcessEvent;
import org.eclipse.ptp.core.elements.events.IRemoveProcessEvent;
import org.eclipse.ptp.core.elements.listeners.IJobChildListener;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class JobConsole
implements IJobChildListener {
    private MessageConsole myConsole;
    private MessageConsoleStream myConsoleStream;
    private boolean prefix = true;

    public static MessageConsole findAndCreateConsole(String name) {
        MessageConsole myConsole = JobConsole.findConsole(name);
        if (myConsole == null) {
            ConsolePlugin plugin = ConsolePlugin.getDefault();
            myConsole = new MessageConsole(name, null);
            IConsoleManager conMan = plugin.getConsoleManager();
            conMan.addConsoles(new IConsole[]{myConsole});
        }
        return myConsole;
    }

    public static MessageConsole findConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        return null;
    }

    public static void jout(String name, String msg) {
        MessageConsole myConsole = JobConsole.findAndCreateConsole(name);
        MessageConsoleStream out = myConsole.newMessageStream();
        out.println(msg);
    }

    public JobConsole(IPJob job) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        boolean haveConsole = false;
        IConsole[] existing = conMan.getConsoles();
        String id = this.getUniqueName(job);
        int i = 0;
        while (i < existing.length) {
            if (id.equals(existing[i].getName())) {
                this.myConsole = (MessageConsole)existing[i];
                haveConsole = true;
                break;
            }
            ++i;
        }
        if (!haveConsole) {
            this.myConsole = new MessageConsole(id, null);
            this.myConsoleStream = this.myConsole.newMessageStream();
            conMan.addConsoles(new IConsole[]{this.myConsole});
        }
    }

    public void cout(String index, String msg) {
        String output = "";
        if (this.prefix) {
            String[] lines = msg.split("\n");
            int i = 0;
            while (i < lines.length) {
                if (i > 0) {
                    output = String.valueOf(output) + "\n";
                }
                output = String.valueOf(output) + "[" + index + "] " + lines[i];
                ++i;
            }
        } else {
            output = msg;
        }
        this.myConsoleStream.println(output);
    }

    public void handleEvent(IChangedProcessEvent e) {
        for (IPProcess process : e.getProcesses()) {
            StringAttribute stdout = (StringAttribute)process.getAttribute((IAttributeDefinition)ProcessAttributes.getStdoutAttributeDefinition());
            EnumeratedAttribute state = (EnumeratedAttribute)process.getAttribute((IAttributeDefinition)ProcessAttributes.getStateAttributeDefinition());
            IntegerAttribute index = (IntegerAttribute)process.getAttribute((IAttributeDefinition)ProcessAttributes.getIndexAttributeDefinition());
            if (state.getValue() != ProcessAttributes.State.RUNNING || stdout == null) continue;
            this.cout(index.getValueAsString(), stdout.getValueAsString());
        }
    }

    public void handleEvent(INewProcessEvent e) {
    }

    public void handleEvent(IRemoveProcessEvent e) {
    }

    public boolean removeConsole() {
        if (this.myConsole != null) {
            ConsolePlugin plugin = ConsolePlugin.getDefault();
            IConsoleManager conMan = plugin.getConsoleManager();
            conMan.removeConsoles(new IConsole[]{this.myConsole});
            return true;
        }
        return false;
    }

    private String getUniqueName(IPJob job) {
        String rmName = job.getQueue().getResourceManager().getName();
        String queueName = job.getQueue().getName();
        String jobName = job.getName();
        return String.valueOf(rmName) + ":" + queueName + ":" + jobName;
    }
}

