/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ui.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ptp.ui.PTPUIPlugin;
import org.eclipse.ptp.ui.preferences.AbstractPreferencePage;
import org.eclipse.ptp.ui.preferences.PreferenceMessages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ViewerPreferencesPage
extends AbstractPreferencePage {
    private ViewIntFieldEditor toolTipField = null;
    private Button tooltipIsWrapButton = null;
    private Button tooltipShowAllTimeButton = null;

    public ViewerPreferencesPage() {
        this.setPreferenceStore(PTPUIPlugin.getDefault().getPreferenceStore());
        this.setDescription(PreferenceMessages.getString("ViewerPreferencePage.desc"));
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        this.createSpacer(composite, 1);
        this.createViewSettingPreferences(composite);
        this.setValues();
        return composite;
    }

    protected void createTooltipGroup(Composite parent) {
        Composite group = this.createGroupComposite(parent, 1, false, PreferenceMessages.getString("ViewerPreferencesPage.tooltipName"));
        Composite compTooltip = this.createComposite(group, 1);
        this.tooltipShowAllTimeButton = this.createCheckButton(compTooltip, PreferenceMessages.getString("ViewerPreferencesPage.tooltip_showAllTime"));
        this.tooltipShowAllTimeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewerPreferencesPage.this.toolTipField.setEnabled(!ViewerPreferencesPage.this.tooltipShowAllTimeButton.getSelection());
                if (ViewerPreferencesPage.this.tooltipShowAllTimeButton.getSelection()) {
                    ViewerPreferencesPage.this.toolTipField.setValue((int)ViewerPreferencesPage.this.getPreferenceStore().getDefaultLong("tt_timeout"));
                }
            }
        });
        this.toolTipField = new ViewIntFieldEditor(PreferenceMessages.getString("ViewerPreferencesPage.tooltip_timeout"), 1000, 10000, this.createComposite(compTooltip, 3));
        this.tooltipIsWrapButton = this.createCheckButton(compTooltip, PreferenceMessages.getString("ViewerPreferencesPage.tooltip_iswrap"));
    }

    protected void createIconGroup(Composite parent) {
    }

    protected void createViewSettingPreferences(Composite parent) {
        this.createTooltipGroup(parent);
    }

    public void performDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this.toolTipField.setValue((int)store.getDefaultLong("tt_timeout"));
        this.tooltipIsWrapButton.setSelection(store.getDefaultBoolean("tt_iswap"));
        this.tooltipShowAllTimeButton.setSelection(store.getDefaultBoolean("tt_show_all_time"));
        super.performDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        PTPUIPlugin.getDefault().savePluginPreferences();
        return true;
    }

    protected void setValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this.toolTipField.setValue((int)store.getLong("tt_timeout"));
        this.tooltipIsWrapButton.setSelection(store.getBoolean("tt_iswap"));
        this.tooltipShowAllTimeButton.setSelection(store.getBoolean("tt_show_all_time"));
    }

    protected void storeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("tt_timeout", (long)this.toolTipField.getValue());
        store.setValue("tt_iswap", this.tooltipIsWrapButton.getSelection());
        store.setValue("tt_show_all_time", this.tooltipShowAllTimeButton.getSelection());
    }

    public boolean isValid() {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (!this.toolTipField.isValid()) {
            this.setErrorMessage(this.toolTipField.getErrorMessage());
            return false;
        }
        return true;
    }

    private class ViewIntFieldEditor {
        private int textLimit = 5;
        private String labelText = null;
        private int min = 0;
        private int max = 10;
        private Text textField = null;
        private String msg = "";

        ViewIntFieldEditor(String labelText, int min, int max, Composite parent) {
            this.labelText = labelText;
            this.min = min;
            this.max = max;
            this.createControl(parent);
        }

        protected void createControl(Composite parent) {
            this.doFillIntoGrid(parent);
        }

        protected void doFillIntoGrid(Composite parent) {
            new Label(parent, 16384).setText(this.labelText);
            this.textField = new Text(parent, 2052);
            this.textField.setFont(parent.getFont());
            this.textField.setTextLimit(this.textLimit);
            this.textField.setLayoutData((Object)new GridData(768));
            this.textField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ViewerPreferencesPage.this.isValid();
                }
            });
            new Label(parent, 131072).setText("(" + this.min + "-" + this.max + ")");
        }

        public void setEnabled(boolean isEnable) {
            if (this.textField != null) {
                this.textField.setEnabled(isEnable);
            }
        }

        public void setValue(int value) {
            if (this.textField != null) {
                this.textField.setText(String.valueOf(value));
            }
        }

        public int getValue() {
            try {
                return Integer.parseInt(this.textField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }

        public void setErrorMessage(String msg) {
            this.msg = msg;
        }

        public String getErrorMessage() {
            return this.msg;
        }

        public boolean isValid() {
            this.setErrorMessage("");
            try {
                int value = Integer.parseInt(this.textField.getText());
                if (value < this.min || value > this.max) {
                    this.setErrorMessage("Value must be in the range of (" + this.min + "-" + this.max + ")");
                    return false;
                }
            }
            catch (NumberFormatException e) {
                this.setErrorMessage("Value must be integer: " + e.getMessage());
                return false;
            }
            return true;
        }
    }
}

