/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Range
implements Iterable<String> {
    private Integer min;
    private Integer max;
    private Integer curr;

    public Range(int val) {
        this(val, val);
    }

    public Range(int min, int max) throws IllegalArgumentException {
        if (min > max) {
            throw new IllegalArgumentException();
        }
        this.min = min;
        this.max = max;
    }

    public int getMinValue() {
        return this.min;
    }

    public int getMaxValue() {
        return this.max;
    }

    public void setMinValue(int val) {
        this.min = val;
    }

    public void setMaxValue(int val) {
        this.max = val;
    }

    public boolean inRange(int val) {
        return val >= this.min && val <= this.max;
    }

    public int size() {
        return this.max - this.min + 1;
    }

    public String toString() {
        if (this.min == this.max) {
            return "" + this.min;
        }
        return this.min + "-" + this.max;
    }

    @Override
    public Iterator<String> iterator() {
        this.curr = this.min;
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return Range.this.curr <= Range.this.max;
            }

            @Override
            public String next() {
                if (this.hasNext()) {
                    Range range = Range.this;
                    Integer n = range.curr;
                    range.curr = n + 1;
                    return n.toString();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

