/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.rse;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.remote.IRemoteConnection;
import org.eclipse.ptp.remote.IRemoteConnectionManager;
import org.eclipse.ptp.remote.rse.RSEConnection;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.ui.actions.SystemNewConnectionAction;
import org.eclipse.swt.widgets.Shell;

public class RSEConnectionManager
implements IRemoteConnectionManager {
    private IFileSystem fileSystem = null;
    private ISystemRegistry registry;
    private SystemNewConnectionAction action;
    private Map<IHost, IRemoteConnection> connections = null;

    public RSEConnectionManager(ISystemRegistry registry) {
        this.registry = registry;
        try {
            this.fileSystem = EFS.getFileSystem((String)"rse");
        }
        catch (CoreException coreException) {}
    }

    public IRemoteConnection getConnection(String name) {
        IRemoteConnection[] iRemoteConnectionArray = this.getConnections();
        int n = iRemoteConnectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRemoteConnection conn = iRemoteConnectionArray[n2];
            IHost host = ((RSEConnection)conn).getHost();
            if (host.getName().equals(name)) {
                return conn;
            }
            ++n2;
        }
        return null;
    }

    public IRemoteConnection[] getConnections() {
        if (this.connections == null && this.fileSystem != null) {
            IHost[] hosts = this.registry.getHostsBySubSystemConfigurationCategory("shells");
            this.connections = new HashMap<IHost, IRemoteConnection>();
            IHost[] iHostArray = hosts;
            int n = hosts.length;
            int n2 = 0;
            while (n2 < n) {
                IHost host = iHostArray[n2];
                this.connections.put(host, new RSEConnection(host, this.fileSystem));
                ++n2;
            }
        }
        return this.connections.values().toArray(new IRemoteConnection[this.connections.size()]);
    }

    public void newConnection(Shell shell) {
        if (this.action == null) {
            this.action = new SystemNewConnectionAction(shell, false, false, null);
            IRSESystemType systemType = RSECorePlugin.getTheCoreRegistry().getSystemTypeById("org.eclipse.rse.systemtype.ssh");
            if (systemType != null) {
                this.action.restrictSystemTypes(new IRSESystemType[]{systemType});
            }
        }
        try {
            this.action.run();
        }
        catch (Exception exception) {}
        if (this.connections != null && this.fileSystem != null) {
            IHost[] hosts;
            IHost[] iHostArray = hosts = this.registry.getHostsBySubSystemConfigurationCategory("shells");
            int n = hosts.length;
            int n2 = 0;
            while (n2 < n) {
                IHost host = iHostArray[n2];
                if (!this.connections.containsKey(host)) {
                    this.connections.put(host, new RSEConnection(host, this.fileSystem));
                }
                ++n2;
            }
        }
    }

    public boolean supportsNewConnections() {
        return true;
    }
}

