/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.common.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.pldt.common.CommonPlugin;
import org.eclipse.ptp.pldt.common.actions.RunAnalyseHandler;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class AnalysisDropdownHandler
extends AbstractHandler
implements ISelectionListener {
    protected static RunAnalyseHandler lastAnalysisHandler = null;
    protected static IStructuredSelection lastAnalysisSelection = null;
    protected IStructuredSelection lastSelection = null;
    protected static AnalysisDropdownHandler instance = null;
    private static final boolean traceOn = false;

    public AnalysisDropdownHandler() {
        assert (instance == null);
        instance = this;
        ISelectionService ss = CommonPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        ss.addSelectionListener((ISelectionListener)this);
        ISelection sel = ss.getSelection();
        if (sel instanceof IStructuredSelection) {
            this.lastSelection = (IStructuredSelection)sel;
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (lastAnalysisHandler != null) {
            lastAnalysisHandler.execute(event);
        } else {
            MessageDialog.openInformation(null, (String)"Repeat Analysis", (String)"No analysis has been done yet to repeat.");
        }
        return null;
    }

    public static void setLastHandledAnalysis(RunAnalyseHandler handler, IStructuredSelection selection) {
        lastAnalysisHandler = handler;
        if (selection != null) {
            lastAnalysisSelection = selection;
        }
    }

    public static IStructuredSelection getLastAnalysisSelection() {
        return lastAnalysisSelection;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.lastSelection = (IStructuredSelection)selection;
        }
    }

    public IStructuredSelection getLastSelection() {
        return this.lastSelection;
    }

    public static AnalysisDropdownHandler getInstance() {
        if (instance == null) {
            instance = new AnalysisDropdownHandler();
        }
        return instance;
    }
}

