/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.remotetools;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.remote.IRemoteFileManager;
import org.eclipse.ptp.remote.remotetools.RemoteToolsConnection;
import org.eclipse.ptp.remote.remotetools.RemoteToolsFileStore;
import org.eclipse.ptp.remote.ui.RemoteResourceBrowser;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionManager;
import org.eclipse.ptp.remotetools.core.IRemoteFileTools;
import org.eclipse.ptp.remotetools.core.IRemoteItem;
import org.eclipse.ptp.remotetools.exception.CancelException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.exception.RemoteExecutionException;
import org.eclipse.ptp.remotetools.exception.RemoteOperationException;
import org.eclipse.swt.widgets.Shell;

public class RemoteToolsFileManager
implements IRemoteFileManager {
    private IRemoteExecutionManager exeMgr;
    private RemoteToolsConnection connection;
    private Map<IPath, IFileStore> pathCache = new HashMap<IPath, IFileStore>();

    public RemoteToolsFileManager(RemoteToolsConnection conn, IRemoteExecutionManager exeMgr) {
        this.connection = conn;
        this.exeMgr = exeMgr;
    }

    public IPath browseDirectory(Shell shell, String message, String filterPath) {
        RemoteResourceBrowser browser = new RemoteResourceBrowser((IRemoteFileManager)this, shell);
        browser.setType(2);
        browser.setInitialPath(filterPath);
        if (browser.open() == 1) {
            return null;
        }
        IPath path = browser.getPath();
        if (path == null) {
            return null;
        }
        return path;
    }

    public IPath browseFile(Shell shell, String message, String filterPath) {
        RemoteResourceBrowser browser = new RemoteResourceBrowser((IRemoteFileManager)this, shell);
        browser.setType(1);
        browser.setInitialPath(filterPath);
        if (browser.open() == 1) {
            return null;
        }
        IPath path = browser.getPath();
        if (path == null) {
            return null;
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cache(IPath path, IFileStore resource) {
        Map<IPath, IFileStore> map = this.pathCache;
        synchronized (map) {
            this.pathCache.put(path, resource);
        }
    }

    public IRemoteExecutionManager getExecutionManager() {
        return this.exeMgr;
    }

    public IFileStore getResource(IPath path, IProgressMonitor monitor) throws IOException {
        IRemoteItem item;
        Object res = this.lookup(path);
        if (res != null) {
            return res;
        }
        boolean isDirectory = false;
        try {
            String pathStr = path.toString();
            IRemoteFileTools tools = this.exeMgr.getRemoteFileTools();
            item = tools.getItem(pathStr);
            if (tools.hasDirectory(pathStr)) {
                isDirectory = true;
            }
        }
        catch (RemoteConnectionException e) {
            throw new IOException(e.getMessage());
        }
        catch (RemoteOperationException e) {
            throw new IOException(e.getMessage());
        }
        catch (CancelException e) {
            throw new IOException(e.getMessage());
        }
        res = new RemoteToolsFileStore(this, item, isDirectory);
        this.cache(path, (IFileStore)res);
        return res;
    }

    public IPath getWorkingDirectory() {
        String cwd = "//";
        try {
            cwd = this.exeMgr.getExecutionTools().executeWithOutput("pwd").trim();
        }
        catch (RemoteExecutionException remoteExecutionException) {
        }
        catch (RemoteConnectionException remoteConnectionException) {
        }
        catch (CancelException cancelException) {}
        return new Path(cwd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFileStore lookup(IPath path) {
        Map<IPath, IFileStore> map = this.pathCache;
        synchronized (map) {
            return this.pathCache.get(path);
        }
    }

    public IPath toPath(URI uri) {
        return new Path(uri.getPath());
    }

    public URI toURI(IPath path) {
        try {
            String auth = this.connection.getAddress();
            String user = this.connection.getUsername();
            if (user != null && !user.equals("")) {
                auth = String.valueOf(user) + "@" + auth;
            }
            return new URI("remotetools", auth, path.toPortableString(), null);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }
}

