/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.DebugJobStorage;
import org.eclipse.ptp.debug.core.IPSession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.model.aif.AIFException;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIF;
import org.eclipse.ptp.debug.core.pdi.request.IPDIEventRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIGetAIFRequest;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;

public final class PJobVariableManager {
    private DebugJobStorage variableStorage = new DebugJobStorage("Variable");
    private DebugJobStorage varProcStorage = new DebugJobStorage("Variable_Process");
    private final String PROCESS_KEY = "process_key";
    private final String VALUE_UNKNOWN = "Unkwnon";
    private final String VALUE_ERROR = "Error in getting value";

    public void shutdown() {
        this.cleanupJobVariableValues();
        this.varProcStorage.closeDebugJobStorage();
        this.variableStorage.closeDebugJobStorage();
    }

    public String getResultDisplay(String job_id, int task_id) {
        ProcessValue procVal = (ProcessValue)this.varProcStorage.getValue(job_id, "process_key");
        if (procVal == null) {
            return "";
        }
        StringBuffer display = new StringBuffer();
        VariableValue[] variableValueArray = procVal.getValues(task_id);
        int n = variableValueArray.length;
        int n2 = 0;
        while (n2 < n) {
            VariableValue value = variableValueArray[n2];
            display.append("<i>");
            display.append(value.getVar());
            display.append("</i>");
            display.append(" = ");
            display.append(value.getVal());
            display.append("<br>");
            ++n2;
        }
        return display.toString();
    }

    public DebugJobStorage getVariableStorage() {
        return this.variableStorage;
    }

    public boolean isContainVariable(IPJob job, String var) {
        return this.variableStorage.getValue(job.getID(), var) != null;
    }

    public void addJobVariable(IPJob job, String var, String[] sets) {
        this.addJobVariable(job, var, sets, true);
    }

    public void addJobVariable(IPJob job, String var, String[] sets, boolean enable) {
        JobVariable jVar = (JobVariable)this.variableStorage.getValue(job.getID(), var);
        if (jVar == null) {
            jVar = new JobVariable(job, var, sets, enable);
        } else {
            jVar.setSets(sets);
            jVar.setEnable(enable);
        }
        this.variableStorage.addValue(job.getID(), var, (Object)jVar);
        this.createProcessValue(job);
    }

    private void createProcessValue(IPJob job) {
        ProcessValue procVal = (ProcessValue)this.varProcStorage.getValue(job.getID(), "process_key");
        if (procVal == null) {
            procVal = new ProcessValue(job.size());
            this.varProcStorage.addValue(job.getID(), "process_key", (Object)procVal);
        }
    }

    public JobVariable[] getJobVariables(String job_id) {
        return this.variableStorage.getValueCollection(job_id).toArray(new JobVariable[0]);
    }

    public void changeJobVariable(IPJob job, IPJob newJob, String[] sets, String var, String newVar, boolean enable) {
        this.removeJobVariable(job.getID(), var);
        this.addJobVariable(newJob, newVar, sets, enable);
    }

    public void deleteSet(String job_id, String set_id) {
        JobVariable[] jobVariableArray = this.getJobVariables(job_id);
        int n = jobVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            JobVariable jVar = jobVariableArray[n2];
            if (jVar.containSet(set_id)) {
                jVar.removeSet(set_id);
                if (jVar.getSetSize() == 0) {
                    this.variableStorage.removeValue(job_id, jVar.getVar());
                }
            }
            ++n2;
        }
    }

    public boolean deleteSet(String job_id, String var, String set_id) {
        JobVariable jVar = (JobVariable)this.variableStorage.getValue(job_id, var);
        if (jVar == null) {
            return false;
        }
        if (!jVar.containSet(set_id)) {
            return false;
        }
        jVar.removeSet(set_id);
        if (jVar.getSetSize() == 0) {
            this.variableStorage.removeValue(job_id, jVar.getVar());
        }
        return true;
    }

    public void removeJobVariable(String job_id, String var) {
        this.variableStorage.removeValue(job_id, var);
    }

    public void removeJobVariables(String job_id) {
        this.variableStorage.removeJobStorage(job_id);
    }

    public void cleanupJobVariableValues() {
        ProcessValue[] processValueArray = this.varProcStorage.getJobValueCollection().toArray(new ProcessValue[0]);
        int n = processValueArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessValue procVal = processValueArray[n2];
            if (procVal != null) {
                procVal.cleanAllValues();
            }
            ++n2;
        }
    }

    public void cleanupJobVariableValues(String job_id, BitList tasks) {
        ProcessValue procVal = (ProcessValue)this.varProcStorage.getValue(job_id, "process_key");
        if (procVal != null) {
            int[] nArray = tasks.toArray();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int task_id = nArray[n2];
                procVal.cleanValues(task_id);
                ++n2;
            }
        }
    }

    public String[] getVariables(String job_id, String set_id, boolean enable) {
        ArrayList<String> vars = new ArrayList<String>();
        JobVariable[] jobVariableArray = this.getJobVariables(job_id);
        int n = jobVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            JobVariable jVar = jobVariableArray[n2];
            if (jVar.isEnable() == enable && jVar.containSet(set_id)) {
                vars.add(jVar.getVar());
            }
            ++n2;
        }
        return vars.toArray(new String[0]);
    }

    public void storeProcessValue(ProcessValue procVal, BitList tasks, String var, String val) {
        int[] nArray = tasks.toArray();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int task_id = nArray[n2];
            procVal.addValue(task_id, new VariableValue(var, val));
            ++n2;
        }
    }

    public void updateJobVariableValues(String job_id, String set_id, BitList tasks, IProgressMonitor monitor) throws CoreException {
        IPSession session;
        String[] vars;
        ProcessValue procVal = (ProcessValue)this.varProcStorage.getValue(job_id, "process_key");
        if (procVal != null && (vars = this.getVariables(job_id, set_id, true)).length > 0 && (session = PTPDebugUIPlugin.getUIDebugManager().getDebugSession(job_id)) != null) {
            BitList suspend_tasks = session.getPDISession().getTaskManager().getSuspendedTasks(tasks);
            monitor.beginTask("Updating variables value...", suspend_tasks.cardinality() * vars.length + 1);
            monitor.worked(1);
            int i = 0;
            while (i < vars.length) {
                if (monitor.isCanceled()) break;
                IPDIGetAIFRequest request = session.getPDISession().getRequestFactory().getAIFRequest(suspend_tasks, vars[i]);
                try {
                    session.getPDISession().getEventRequestManager().addEventRequest((IPDIEventRequest)request);
                    Map map = request.getResultMap(suspend_tasks);
                    for (BitList sTasks : map.keySet()) {
                        Object value = map.get(sTasks);
                        if (!(value instanceof IAIF)) continue;
                        this.storeProcessValue(procVal, sTasks, vars[i], ((IAIF)value).getValue().getValueString());
                        monitor.worked(1);
                    }
                }
                catch (PDIException pDIException) {
                    this.storeProcessValue(procVal, suspend_tasks, vars[i], "Error in getting value");
                }
                catch (AIFException aIFException) {
                    this.storeProcessValue(procVal, suspend_tasks, vars[i], "Error in getting value");
                }
                ++i;
            }
        }
        monitor.done();
    }

    public class JobVariable {
        IPJob job;
        String var;
        String[] sets = new String[0];
        boolean enable = false;

        public JobVariable(IPJob job, String var, String[] sets, boolean enable) {
            this.job = job;
            this.var = var;
            this.sets = sets;
            this.enable = enable;
        }

        public IPJob getJob() {
            return this.job;
        }

        public String getVar() {
            return this.var;
        }

        public String[] getSets() {
            return this.sets;
        }

        public boolean isEnable() {
            return this.enable;
        }

        public boolean containSet(String set_id) {
            String[] stringArray = this.sets;
            int n = this.sets.length;
            int n2 = 0;
            while (n2 < n) {
                String set = stringArray[n2];
                if (set.equals(set_id)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public void addSet(String set_id) {
            String[] newSets = new String[this.sets.length + 1];
            System.arraycopy(this.sets, 0, newSets, 0, this.sets.length);
            newSets[this.sets.length] = set_id;
            this.setSets(newSets);
        }

        public void removeSet(String set_id) {
            String[] newSets = new String[this.sets.length - 1];
            int i = 0;
            int j = 0;
            while (i < this.sets.length) {
                if (!this.sets[i].equals(set_id)) {
                    newSets[j] = this.sets[i];
                    ++j;
                }
                ++i;
            }
            this.setSets(newSets);
        }

        public int getSetSize() {
            return this.sets.length;
        }

        public void setVar(String var) {
            this.var = var;
        }

        public void setSets(String[] sets) {
            this.sets = sets;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }
    }

    class ProcessValue {
        int total = 0;
        Object[] processValues = new Object[0];

        ProcessValue(int total) {
            this.total = total;
            this.processValues = new Object[total];
        }

        void checkValidTask(int task_id) {
            if (task_id > this.processValues.length) {
                throw new IllegalArgumentException("Invalid task id");
            }
        }

        void setValues(int task_id, VariableValue[] values) {
            this.checkValidTask(task_id);
            this.processValues[task_id] = values;
        }

        VariableValue[] getValues(int task_id) {
            this.checkValidTask(task_id);
            Object object = this.processValues[task_id];
            if (object instanceof VariableValue[]) {
                return (VariableValue[])object;
            }
            return new VariableValue[0];
        }

        void addValue(int task_id, VariableValue value) {
            VariableValue[] values = this.getValues(task_id);
            VariableValue[] newValues = new VariableValue[values.length + 1];
            if (values.length > 0) {
                System.arraycopy(values, 0, newValues, 0, values.length);
            }
            newValues[values.length] = value;
            this.setValues(task_id, newValues);
        }

        void updateValue(int task_id, VariableValue value) {
            VariableValue[] variableValueArray = this.getValues(task_id);
            int n = variableValueArray.length;
            int n2 = 0;
            while (n2 < n) {
                VariableValue v = variableValueArray[n2];
                if (v.getVar().equals(value.getVar())) {
                    v.setVal(value.getVal());
                }
                ++n2;
            }
        }

        void cleanValues(int task_id) {
            this.processValues[task_id] = null;
        }

        void cleanAllValues() {
            this.processValues = new Object[this.total];
        }
    }

    class VariableValue {
        String var;
        String val = "Unkwnon";

        VariableValue(String var, String val) {
            this.var = var;
            if (val != null) {
                this.val = val;
            }
        }

        String getVar() {
            return this.var;
        }

        String getVal() {
            return this.val;
        }

        void setVar(String var) {
            this.var = var;
        }

        void setVal(String val) {
            this.val = val;
        }
    }
}

