/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.ui.hover;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.ptp.internal.ui.hover.SubstitutionTextReader;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class IconTextReader
extends SubstitutionTextReader {
    private static final String EMPTY_STRING = "";
    private static final Map<String, String> fgEntityLookup;
    private static final Set<String> fgTags;
    private Color red_color = Display.getDefault().getSystemColor(3);
    private Color green_color = Display.getDefault().getSystemColor(5);
    private int fCounter = 0;
    private TextPresentation fTextPresentation;
    private int fStrike = 0;
    private int fUnderline = 0;
    private int fBold = 0;
    private int fItalic = 0;
    private int fKey = 0;
    private int fHighlight = 0;
    private int fStartOffset = -1;
    private boolean fInParagraph = false;

    static {
        fgTags = new HashSet<String>();
        fgTags.add("u");
        fgTags.add("s");
        fgTags.add("b");
        fgTags.add("i");
        fgTags.add("p");
        fgTags.add("key");
        fgTags.add("hl");
        fgTags.add("br");
        fgTags.add("ind");
        fgEntityLookup = new HashMap<String, String>(7);
        fgEntityLookup.put("lt", "<");
        fgEntityLookup.put("gt", ">");
        fgEntityLookup.put("nbsp", " ");
        fgEntityLookup.put("amp", "&");
        fgEntityLookup.put("circ", "^");
        fgEntityLookup.put("tilde", "~");
        fgEntityLookup.put("quot", "\"");
    }

    public IconTextReader(Reader reader, TextPresentation presentation) {
        super(new PushbackReader(reader));
        this.fTextPresentation = presentation;
    }

    public int read() throws IOException {
        int c = super.read();
        if (c != -1) {
            ++this.fCounter;
        }
        return c;
    }

    protected void startBold() {
        if (this.fBold == 0) {
            this.fStartOffset = this.fCounter;
        }
        ++this.fBold;
    }

    protected void stopBold() {
        --this.fBold;
        if (this.fBold == 0) {
            this.fTextPresentation.addStyleRange(new StyleRange(this.fStartOffset, this.fCounter - this.fStartOffset, null, null, 1));
            this.fStartOffset = -1;
        }
    }

    protected void startUnderLine() {
        if (this.fUnderline == 0) {
            this.fStartOffset = this.fCounter;
        }
        ++this.fUnderline;
    }

    protected void stopUnderLine() {
        --this.fUnderline;
        if (this.fUnderline == 0) {
            StyleRange styleRange = new StyleRange(this.fStartOffset, this.fCounter - this.fStartOffset, null, null, 0);
            styleRange.underline = true;
            this.fTextPresentation.addStyleRange(styleRange);
            this.fStartOffset = -1;
        }
    }

    protected void startStrike() {
        if (this.fStrike == 0) {
            this.fStartOffset = this.fCounter;
        }
        ++this.fStrike;
    }

    protected void stopStrike() {
        --this.fStrike;
        if (this.fStrike == 0) {
            StyleRange styleRange = new StyleRange(this.fStartOffset, this.fCounter - this.fStartOffset, null, null, 0);
            styleRange.strikeout = true;
            this.fTextPresentation.addStyleRange(styleRange);
            this.fStartOffset = -1;
        }
    }

    protected void startItalic() {
        if (this.fItalic == 0) {
            this.fStartOffset = this.fCounter;
        }
        ++this.fItalic;
    }

    protected void stopItalic() {
        --this.fItalic;
        if (this.fItalic == 0) {
            this.fTextPresentation.addStyleRange(new StyleRange(this.fStartOffset, this.fCounter - this.fStartOffset, null, null, 2));
            this.fStartOffset = -1;
        }
    }

    protected void startKey() {
        if (this.fKey == 0) {
            this.fStartOffset = this.fCounter;
        }
        ++this.fKey;
    }

    protected void stopKey() {
        --this.fKey;
        if (this.fKey == 0) {
            this.fTextPresentation.addStyleRange(new StyleRange(this.fStartOffset, this.fCounter - this.fStartOffset, this.red_color, null, 0));
            this.fStartOffset = -1;
        }
    }

    protected void startHighlight() {
        if (this.fHighlight == 0) {
            this.fStartOffset = this.fCounter;
        }
        ++this.fHighlight;
    }

    protected void stopHighlight() {
        --this.fHighlight;
        if (this.fHighlight == 0) {
            this.fTextPresentation.addStyleRange(new StyleRange(this.fStartOffset, this.fCounter - this.fStartOffset, null, this.green_color, 0));
            this.fStartOffset = -1;
        }
    }

    protected String computeSubstitution(int c) throws IOException {
        if (c == 60) {
            return this.processTag();
        }
        if (c == 38) {
            return this.processEntity();
        }
        return null;
    }

    private String toText(String html) {
        if (html == null || html.length() == 0) {
            return EMPTY_STRING;
        }
        String tag = html;
        boolean isClosing = false;
        if (tag.charAt(0) == '/') {
            tag = tag.substring(1);
            isClosing = true;
        }
        if (!fgTags.contains(tag)) {
            return EMPTY_STRING;
        }
        if (tag.equals("ind")) {
            return "\t";
        }
        if (tag.equals("br")) {
            return LINE_DELIM;
        }
        if (tag.equals("b")) {
            if (isClosing) {
                this.stopBold();
            } else {
                this.startBold();
            }
            return EMPTY_STRING;
        }
        if (tag.equals("u")) {
            if (isClosing) {
                this.stopUnderLine();
            } else {
                this.startUnderLine();
            }
            return EMPTY_STRING;
        }
        if (tag.equals("s")) {
            if (isClosing) {
                this.stopStrike();
            } else {
                this.startStrike();
            }
            return EMPTY_STRING;
        }
        if (tag.equals("i")) {
            if (isClosing) {
                this.stopItalic();
            } else {
                this.startItalic();
            }
            return EMPTY_STRING;
        }
        if (tag.equals("key")) {
            if (isClosing) {
                this.stopKey();
            } else {
                this.startKey();
            }
            return EMPTY_STRING;
        }
        if (tag.equals("hl")) {
            if (isClosing) {
                this.stopHighlight();
            } else {
                this.startHighlight();
            }
            return EMPTY_STRING;
        }
        if (tag.equals("p")) {
            if (isClosing) {
                boolean inParagraph = this.fInParagraph;
                this.fInParagraph = false;
                return inParagraph ? EMPTY_STRING : LINE_DELIM;
            }
            this.fInParagraph = true;
            return LINE_DELIM;
        }
        return EMPTY_STRING;
    }

    private String processTag() throws IOException {
        StringBuffer buf = new StringBuffer();
        int ch = this.nextChar();
        while (ch != -1 && ch != 62) {
            buf.append(Character.toLowerCase((char)ch));
            ch = this.nextChar();
            if (ch == 34) {
                buf.append(Character.toLowerCase((char)ch));
                ch = this.nextChar();
                while (ch != -1 && ch != 34) {
                    buf.append(Character.toLowerCase((char)ch));
                    ch = this.nextChar();
                }
            }
            if (ch != 60) continue;
            this.unread(ch);
            return String.valueOf('<') + buf.toString();
        }
        if (ch == -1) {
            return null;
        }
        return this.toText(buf.toString());
    }

    private void unread(int ch) throws IOException {
        ((PushbackReader)this.getReader()).unread(ch);
    }

    protected String entity2Text(String symbol) {
        if (symbol.length() > 1 && symbol.charAt(0) == '#') {
            try {
                int ch = symbol.charAt(1) == 'x' ? Integer.parseInt(symbol.substring(2), 16) : Integer.parseInt(symbol.substring(1), 10);
                return EMPTY_STRING + (char)ch;
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            String str = fgEntityLookup.get(symbol);
            if (str != null) {
                return str;
            }
        }
        return "&" + symbol;
    }

    private String processEntity() throws IOException {
        StringBuffer buf = new StringBuffer();
        int ch = this.nextChar();
        while (Character.isLetterOrDigit((char)ch) || ch == 35) {
            buf.append((char)ch);
            ch = this.nextChar();
        }
        if (ch == 59) {
            return this.entity2Text(buf.toString());
        }
        buf.insert(0, '&');
        if (ch != -1) {
            buf.append((char)ch);
        }
        return buf.toString();
    }
}

