/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ui.managers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ptp.core.attributes.EnumeratedAttribute;
import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.elements.IPElement;
import org.eclipse.ptp.core.elements.IPMachine;
import org.eclipse.ptp.core.elements.IPNode;
import org.eclipse.ptp.core.elements.IPProcess;
import org.eclipse.ptp.core.elements.IPUniverse;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.core.elements.attributes.NodeAttributes;
import org.eclipse.ptp.ui.managers.AbstractUIManager;
import org.eclipse.ptp.ui.model.Element;
import org.eclipse.ptp.ui.model.ElementHandler;
import org.eclipse.ptp.ui.model.IElement;
import org.eclipse.ptp.ui.model.IElementHandler;
import org.eclipse.ptp.ui.model.IElementSet;

public class MachineManager
extends AbstractUIManager {
    private Map<String, IElementHandler> machineElementHandlerList = new HashMap<String, IElementHandler>();
    private Map<String, IPMachine> machineList = new HashMap<String, IPMachine>();
    protected IPMachine cur_machine = null;
    protected final String DEFAULT_TITLE = "Please select a machine";

    public void addMachine(IPMachine mac) {
        if (mac != null) {
            IElementHandler handler;
            if (!this.machineList.containsKey(mac.getID())) {
                handler = new ElementHandler();
                this.machineList.put(mac.getID(), mac);
                this.machineElementHandlerList.put(mac.getID(), handler);
            } else {
                handler = this.machineElementHandlerList.get(mac.getID());
            }
            ArrayList<IElement> elements = new ArrayList<IElement>();
            IElementSet set = handler.getSetRoot();
            IPNode[] iPNodeArray = mac.getNodes();
            int n = iPNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPNode node = iPNodeArray[n2];
                elements.add(this.createNodeElement(set, node.getID(), node.getName(), node));
                ++n2;
            }
            set.addElements(elements.toArray(new IElement[0]));
        }
    }

    public void addNode(IPNode node) {
        this.addMachine(node.getMachine());
        IElementHandler elementHandler = this.machineElementHandlerList.get(node.getMachine().getID());
        IElementSet set = elementHandler.getSetRoot();
        set.addElements(new IElement[]{this.createNodeElement(set, node.getID(), node.getName(), node)});
    }

    public void clear() {
        if (this.machineList != null) {
            this.machineList.clear();
            this.machineElementHandlerList.clear();
        }
    }

    public IPMachine findMachineById(String id) {
        return this.machineList.get(id);
    }

    public IPNode findNode(String node_id) {
        IPMachine machine = this.getCurrentMachine();
        if (machine == null) {
            System.out.println("\t*** POSSIBLE ERROR: Unable to find machine");
            return null;
        }
        return machine.getNodeById(node_id);
    }

    public IPMachine getCurrentMachine() {
        return this.cur_machine;
    }

    public String getCurrentSetId() {
        return this.cur_set_id;
    }

    public IElementHandler getElementHandler(String id) {
        return this.machineElementHandlerList.get(id);
    }

    public String getFullyQualifiedName(String id) {
        IResourceManager rm;
        if (id.equals("")) {
            return "Please select a machine";
        }
        IPMachine machine = this.getCurrentMachine();
        if (machine != null && (rm = machine.getResourceManager()) != null) {
            return String.valueOf(rm.getName()) + ": " + machine.getName();
        }
        return "";
    }

    public IPMachine[] getMachines() {
        return this.machineList.values().toArray(new IPMachine[0]);
    }

    public String getName(String id) {
        if (this.cur_machine == null) {
            return "";
        }
        return this.cur_machine.getName();
    }

    public int getNodeStatus(IPNode node) {
        if (node != null) {
            IPProcess[] procs;
            NodeAttributes.State nodeState = node.getState();
            EnumeratedAttribute extraStateAttr = (EnumeratedAttribute)node.getAttribute((IAttributeDefinition)NodeAttributes.getExtraStateAttributeDefinition());
            if (extraStateAttr != null) {
                return NodeAttributes.State.values().length + extraStateAttr.getValueIndex();
            }
            if (nodeState == NodeAttributes.State.UP && (procs = node.getProcesses()).length > 0) {
                IPProcess[] iPProcessArray = procs;
                int n = procs.length;
                int n2 = 0;
                while (n2 < n) {
                    IPProcess proc = iPProcessArray[n2];
                    if (!proc.isTerminated()) {
                        return NodeAttributes.State.values().length + NodeAttributes.ExtraState.RUNNING_PROCESS.ordinal();
                    }
                    ++n2;
                }
                return NodeAttributes.State.values().length + NodeAttributes.ExtraState.EXITED_PROCESS.ordinal();
            }
            return nodeState.ordinal();
        }
        return NodeAttributes.State.UNKNOWN.ordinal();
    }

    public String getNodeStatusText(IPNode node) {
        if (node == null) {
            return "Unknown";
        }
        EnumeratedAttribute nodeStateAttr = (EnumeratedAttribute)node.getAttribute((IAttributeDefinition)NodeAttributes.getStateAttributeDefinition());
        if (nodeStateAttr == null) {
            return "Unknown";
        }
        NodeAttributes.State nodeState = (NodeAttributes.State)nodeStateAttr.getValue();
        if (nodeState == NodeAttributes.State.UP) {
            if (node.getProcesses().length > 0) {
                if (node.getProcesses()[0].getJob().isTerminated()) {
                    return "Exited";
                }
                return "Running";
            }
            EnumeratedAttribute extraStateAttr = (EnumeratedAttribute)node.getAttribute((IAttributeDefinition)NodeAttributes.getExtraStateAttributeDefinition());
            NodeAttributes.ExtraState extraState = NodeAttributes.ExtraState.NONE;
            if (extraStateAttr != null) {
                extraState = (NodeAttributes.ExtraState)extraStateAttr.getValue();
            }
            if (extraState != NodeAttributes.ExtraState.NONE) {
                return extraState.toString();
            }
        }
        return nodeState.toString();
    }

    public int getStatus(String id) {
        IPMachine machine = this.getCurrentMachine();
        if (machine != null) {
            return this.getNodeStatus(machine.getNodeById(id));
        }
        return this.getNodeStatus(null);
    }

    public IPElement initial(IPUniverse universe) {
        IResourceManager[] iResourceManagerArray = universe.getResourceManagers();
        int n = iResourceManagerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceManager rm = iResourceManagerArray[n2];
            IPMachine[] iPMachineArray = rm.getMachines();
            int n3 = iPMachineArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IPMachine machine = iPMachineArray[n4];
                this.addMachine(machine);
                ++n4;
            }
            ++n2;
        }
        this.setCurrentSetId("Root");
        return null;
    }

    public boolean isCurrentSetContainNode(String mid, String nodeID) {
        IPMachine machine = this.getCurrentMachine();
        if (machine != null) {
            if (!machine.getID().equals(mid)) {
                return false;
            }
            IElementHandler elementHandler = this.getElementHandler(machine.getID());
            if (elementHandler == null) {
                return false;
            }
            IElementSet set = (IElementSet)elementHandler.getElementByID(this.getCurrentSetId());
            if (set == null) {
                return false;
            }
            return set.contains(nodeID);
        }
        return false;
    }

    public boolean isNoMachine() {
        return this.cur_machine == null;
    }

    public void removeMachine(IPMachine machine) {
        this.machineList.remove(machine.getID());
        this.machineElementHandlerList.remove(machine.getID());
        IElementHandler handler = this.machineElementHandlerList.get(machine.getID());
        if (handler != null) {
            IElementSet set = handler.getSetRoot();
            IPNode[] iPNodeArray = machine.getNodes();
            int n = iPNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPNode node = iPNodeArray[n2];
                IElement element = set.getElementByID(node.getID());
                if (element != null) {
                    set.removeElement(node.getID());
                }
                ++n2;
            }
        }
        if (this.cur_machine == machine) {
            this.cur_machine = null;
        }
    }

    public void removeNode(IPNode node) {
        IElementHandler elementHandler = this.machineElementHandlerList.get(node.getMachine().getID());
        IElementSet set = elementHandler.getSetRoot();
        IElement element = set.getElementByID(node.getID());
        if (element != null) {
            set.removeElement(node.getID());
        }
    }

    public void setCurrentSetId(String set_id) {
        this.cur_set_id = set_id;
    }

    public void setMachine(IPMachine machine) {
        if (machine != this.cur_machine) {
            this.cur_machine = machine;
            this.addMachine(machine);
        }
    }

    public void shutdown() {
        this.clear();
        this.modelPresentation = null;
        super.shutdown();
    }

    public int size() {
        return this.machineList.size();
    }

    protected IElement createNodeElement(IElementSet set, String key, String name, IPNode node) {
        return new Element(set, key, name, (IPElement)node){

            public int compareTo(IElement e) {
                return this.getID().compareTo(e.getID());
            }
        };
    }
}

