/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.ui.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ptp.ui.model.Element;
import org.eclipse.ptp.ui.model.IElement;
import org.eclipse.ptp.ui.model.IElementHandler;
import org.eclipse.ptp.ui.model.IElementSet;

public class ElementSet
extends Element
implements IElementSet {
    private Map<String, IElement> elementMap = new HashMap<String, IElement>();
    private List<IElement> elementList = new ArrayList<IElement>();
    private List<String> matchSetList = new ArrayList<String>();
    private int number_of_elements = 0;

    public ElementSet(IElement parent, String id, String name) {
        super(parent, id, name, null);
    }

    public boolean isRootSet() {
        return this.id.equals("Root");
    }

    public void addElements(IElement[] elements) {
        IElement[] iElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IElement element = iElementArray[n2];
            if (!this.contains(element.getID())) {
                if (!this.isRootSet()) {
                    IElementSet[] sets;
                    IElementSet[] iElementSetArray = sets = ((IElementHandler)this.getParent()).getSetsWithElement(element.getID());
                    int n3 = sets.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IElementSet set = iElementSetArray[n4];
                        set.addMatchSet(this.getID());
                        this.addMatchSet(set.getID());
                        ++n4;
                    }
                }
                this.elementMap.put(element.getID(), element);
                this.elementList.add(element);
                ++this.number_of_elements;
            }
            ++n2;
        }
        this.sorting();
    }

    private void sorting() {
        Collections.sort(this.elementList);
    }

    public IElement getElement(int index) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        return this.elementList.get(index);
    }

    private int binarySearch(String name) {
        int lo = 0;
        int hi = this.number_of_elements - 1;
        int mid = 0;
        while (lo <= hi) {
            mid = (lo + hi) / 2;
            int comp_res = this.compare(this.getElement(mid), name);
            if (comp_res == 0) {
                return mid;
            }
            if (comp_res > 0) {
                hi = mid - 1;
                continue;
            }
            lo = ++mid;
        }
        return -mid - 1;
    }

    public IElement getElementByID(String id) {
        return this.elementMap.get(id);
    }

    public IElement getElementByName(String name) {
        int index = this.binarySearch(name);
        if (index < this.number_of_elements) {
            return this.elementList.get(index);
        }
        return null;
    }

    public int findIndexByID(String id) {
        IElement element = this.getElementByID(id);
        if (element != null) {
            return this.findIndexByName(element.getName());
        }
        return -1;
    }

    public int findIndexByName(String name) {
        int index = this.binarySearch(name);
        if (index < this.number_of_elements) {
            return index;
        }
        return -1;
    }

    public IElement[] getElements() {
        return this.elementList.toArray(new IElement[0]);
    }

    public void removeElements(IElement[] elements) {
        IElement[] iElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IElement element = iElementArray[n2];
            this.removeElement(element.getID());
            ++n2;
        }
    }

    public void removeElement(String id) {
        IElement elmenet = this.elementMap.remove(id);
        this.elementList.remove(elmenet);
        --this.number_of_elements;
        if (!this.isRootSet()) {
            IElementSet[] sets;
            IElementSet[] iElementSetArray = sets = ((IElementHandler)this.getParent()).getSetsWithElement(id);
            int n = sets.length;
            int n2 = 0;
            while (n2 < n) {
                IElementSet set = iElementSetArray[n2];
                set.removeMatchSet(this.getID());
                this.removeMatchSet(set.getID());
                ++n2;
            }
        }
    }

    private int compare(IElement e1, String val) {
        return this.compareTo(e1.getName(), val);
    }

    public int compareTo(String s1, String s2) {
        return s1.compareTo(s2);
    }

    public int size() {
        return this.number_of_elements;
    }

    public void clean() {
        this.elementMap.clear();
        this.elementList.clear();
        this.matchSetList.clear();
        this.number_of_elements = 0;
    }

    public boolean contains(IElement element) {
        return this.contains(element.getID());
    }

    public boolean contains(String id) {
        return this.elementMap.containsKey(id);
    }

    public void addMatchSet(String setID) {
        if (!this.containsMatchSet(setID)) {
            this.matchSetList.add(setID);
        }
    }

    public void removeMatchSet(String setID) {
        this.matchSetList.remove(setID);
    }

    public boolean containsMatchSet(String setID) {
        return this.matchSetList.contains(setID);
    }

    public String[] getMatchSetIDs() {
        return this.matchSetList.toArray(new String[0]);
    }
}

