/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.core.pdi.request;

import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.pdi.IPDIDebugger;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.event.IPDIDataReadMemoryInfo;
import org.eclipse.ptp.debug.core.pdi.request.AbstractEventResultRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIDataReadMemoryRequest;

public abstract class AbstractDataReadMemoryRequest
extends AbstractEventResultRequest
implements IPDIDataReadMemoryRequest {
    private long offset;
    private String address;
    private int wordFormat;
    private int wordSize;
    private int rows;
    private int cols;
    private Character asChar;

    public AbstractDataReadMemoryRequest(BitList tasks, long offset, String address, int wordFormat, int wordSize, int rows, int cols, Character asChar) {
        super(tasks);
        this.offset = offset;
        this.address = address;
        this.wordFormat = wordFormat;
        this.wordSize = wordSize;
        this.rows = rows;
        this.cols = cols;
        this.asChar = asChar;
    }

    public void doExecute(IPDIDebugger debugger) throws PDIException {
        debugger.createDataReadMemory(this.tasks, this.offset, this.address, this.wordFormat, this.wordSize, this.rows, this.cols, this.asChar);
    }

    public IPDIDataReadMemoryInfo getDataReadMemoryInfo(BitList qTasks) throws PDIException {
        this.waitUntilCompleted(qTasks);
        Object obj = this.getResult(qTasks);
        if (obj instanceof IPDIDataReadMemoryInfo) {
            return (IPDIDataReadMemoryInfo)obj;
        }
        throw new PDIException(qTasks, "No data read memory info");
    }

    public String getName() {
        return "Create data read memory request";
    }
}

