/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.sourcelookup;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.ptp.debug.core.PDebugUtils;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.sourcelookup.IDirectorySourceLocation;
import org.eclipse.ptp.debug.core.sourcelookup.IPSourceLocation;
import org.eclipse.ptp.debug.internal.core.sourcelookup.InternalSourceLookupMessages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDirectorySourceLocation
implements IDirectorySourceLocation {
    private static final String ELEMENT_NAME = "cDirectorySourceLocation";
    private static final String ATTR_DIRECTORY = "directory";
    private static final String ATTR_ASSOCIATION = "association";
    private static final String ATTR_SEARCH_SUBFOLDERS = "searchSubfolders";
    private IPath fDirectory;
    private IPath fAssociation = null;
    private boolean fSearchForDuplicateFiles = false;
    private boolean fSearchSubfolders = false;
    private File[] fFolders = null;

    public PDirectorySourceLocation() {
    }

    public PDirectorySourceLocation(IPath directory, IPath association, boolean searchSubfolders) {
        this.setDirectory(directory);
        this.setAssociation(association);
        this.setSearchSubfolders(searchSubfolders);
    }

    @Override
    public Object findSourceElement(String name) throws CoreException {
        Path path;
        File file;
        Object result = null;
        if (!this.isEmpty(name) && this.getDirectory() != null && (result = (file = new File(name)).isAbsolute() ? this.findFileByAbsolutePath(name) : this.findFileByRelativePath(name)) == null && this.getAssociation() != null && (path = new Path(name)).segmentCount() > 1 && this.getAssociation().isPrefixOf((IPath)path)) {
            path = this.getDirectory().append(path.removeFirstSegments(this.getAssociation().segmentCount()));
            result = this.findFileByAbsolutePath(path.toOSString());
        }
        return result;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IPSourceLocation.class)) {
            return this;
        }
        if (adapter.equals(PDirectorySourceLocation.class)) {
            return this;
        }
        if (adapter.equals(IPath.class)) {
            return this.getDirectory();
        }
        return null;
    }

    private void setDirectory(IPath directory) {
        this.fDirectory = directory;
    }

    @Override
    public IPath getDirectory() {
        return this.fDirectory;
    }

    public void getDirectory(IPath path) {
        this.fDirectory = path;
    }

    public void setAssociation(IPath association) {
        this.fAssociation = association;
    }

    @Override
    public IPath getAssociation() {
        return this.fAssociation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object findFileByAbsolutePath(String name) {
        File file = new File(name);
        if (!file.isAbsolute()) {
            return null;
        }
        File[] folders = this.getFolders();
        if (folders == null) return null;
        LinkedList<Object> list = new LinkedList<Object>();
        int i = 0;
        while (i < folders.length) {
            Object result = this.findFileByAbsolutePath(folders[i], name);
            if (result instanceof List) {
                if (!this.searchForDuplicateFiles()) return list.getFirst();
                list.addAll((List)result);
            } else if (result != null) {
                if (!this.searchForDuplicateFiles()) return result;
                list.add(result);
            }
            ++i;
        }
        if (list.size() <= 0) return null;
        return list.size() == 1 ? list.getFirst() : list;
    }

    private Object findFileByAbsolutePath(File folder, String name) {
        File file = new File(name);
        if (!file.isAbsolute()) {
            return null;
        }
        Path filePath = new Path(name);
        Path path = new Path(folder.getAbsolutePath());
        IPath association = this.getAssociation();
        if (!this.isPrefix((IPath)path, (IPath)filePath) || path.segmentCount() + 1 != filePath.segmentCount()) {
            if (association != null && this.isPrefix(association, (IPath)filePath) && association.segmentCount() + 1 == filePath.segmentCount()) {
                filePath = path.append(filePath.removeFirstSegments(association.segmentCount()));
            } else {
                return null;
            }
        }
        IFile[] wsFiles = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)filePath);
        LinkedList<IFile> list = new LinkedList<IFile>();
        int j = 0;
        while (j < wsFiles.length) {
            if (wsFiles[j].exists()) {
                if (!this.searchForDuplicateFiles()) {
                    return wsFiles[j];
                }
                list.add(wsFiles[j]);
            }
            ++j;
        }
        if (list.size() > 0) {
            return list.size() == 1 ? list.getFirst() : list;
        }
        file = filePath.toFile();
        if (file.exists() && file.isFile()) {
            return this.createExternalFileStorage((IPath)filePath);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object findFileByRelativePath(String fileName) {
        File[] folders = this.getFolders();
        if (folders == null) return null;
        LinkedList<Object> list = new LinkedList<Object>();
        int i = 0;
        while (i < folders.length) {
            Object result = this.findFileByRelativePath(folders[i], fileName);
            if (result instanceof List) {
                if (!this.searchForDuplicateFiles()) return list.getFirst();
                list.addAll((List)result);
            } else if (result != null) {
                if (!this.searchForDuplicateFiles()) return result;
                list.add(result);
            }
            ++i;
        }
        if (list.size() <= 0) return null;
        return list.size() == 1 ? list.getFirst() : list;
    }

    private Object findFileByRelativePath(File folder, String fileName) {
        Path path = new Path(folder.getAbsolutePath());
        File file = (path = path.append(fileName)).toFile();
        if (file.exists() && file.isFile()) {
            path = new Path(file.getAbsolutePath());
            IFile[] wsFiles = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)path);
            LinkedList<IFile> list = new LinkedList<IFile>();
            int j = 0;
            while (j < wsFiles.length) {
                if (wsFiles[j].exists()) {
                    if (!this.searchForDuplicateFiles()) {
                        return wsFiles[j];
                    }
                    list.add(wsFiles[j]);
                }
                ++j;
            }
            if (list.size() > 0) {
                return list.size() == 1 ? list.getFirst() : list;
            }
            return this.createExternalFileStorage((IPath)path);
        }
        return null;
    }

    private IStorage createExternalFileStorage(IPath path) {
        return new LocalFileStorage(path.toFile());
    }

    @Override
    public String getMemento() throws CoreException {
        Document document = null;
        Exception ex = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element node = document.createElement(ELEMENT_NAME);
            document.appendChild(node);
            node.setAttribute(ATTR_DIRECTORY, this.getDirectory().toOSString());
            if (this.getAssociation() != null) {
                node.setAttribute(ATTR_ASSOCIATION, this.getAssociation().toOSString());
            }
            node.setAttribute(ATTR_SEARCH_SUBFOLDERS, new Boolean(this.searchSubfolders()).toString());
            return PDebugUtils.serializeDocument(document);
        }
        catch (ParserConfigurationException e) {
            ex = e;
        }
        catch (IOException e) {
            ex = e;
        }
        catch (TransformerException e) {
            ex = e;
        }
        this.abort(MessageFormat.format(InternalSourceLookupMessages.getString("PDirectorySourceLocation.0"), this.getDirectory().toOSString()), ex);
        return null;
    }

    @Override
    public void initializeFrom(String memento) throws CoreException {
        Exception ex = null;
        try {
            Path path;
            Element root = null;
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            StringReader reader = new StringReader(memento);
            InputSource source = new InputSource(reader);
            root = parser.parse(source).getDocumentElement();
            String dir = root.getAttribute(ATTR_DIRECTORY);
            if (this.isEmpty(dir)) {
                this.abort(InternalSourceLookupMessages.getString("PDirectorySourceLocation.1"), null);
            } else {
                path = new Path(dir);
                if (path.isValidPath(dir) && path.toFile().isDirectory() && path.toFile().exists()) {
                    this.setDirectory((IPath)path);
                } else {
                    this.abort(MessageFormat.format(InternalSourceLookupMessages.getString("PDirectorySourceLocation.2"), dir), null);
                }
            }
            dir = root.getAttribute(ATTR_ASSOCIATION);
            if (this.isEmpty(dir)) {
                this.setAssociation(null);
            } else {
                path = new Path(dir);
                if (path.isValidPath(dir)) {
                    this.setAssociation((IPath)path);
                } else {
                    this.setAssociation(null);
                }
            }
            this.setSearchSubfolders(Boolean.valueOf(root.getAttribute(ATTR_SEARCH_SUBFOLDERS)));
            return;
        }
        catch (ParserConfigurationException e) {
            ex = e;
        }
        catch (SAXException e) {
            ex = e;
        }
        catch (IOException e) {
            ex = e;
        }
        this.abort(InternalSourceLookupMessages.getString("PDirectorySourceLocation.3"), ex);
    }

    private void abort(String message, Throwable e) throws CoreException {
        Status s = new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 1000, message, e);
        throw new CoreException((IStatus)s);
    }

    private boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IDirectorySourceLocation) {
            IPath dir = ((IDirectorySourceLocation)obj).getDirectory();
            IPath association = ((IDirectorySourceLocation)obj).getAssociation();
            if (dir == null) {
                return false;
            }
            boolean result = dir.equals((Object)this.getDirectory());
            if (result) {
                if (association == null && this.getAssociation() == null) {
                    return true;
                }
                if (association != null) {
                    return association.equals((Object)this.getAssociation());
                }
            }
        }
        return false;
    }

    private boolean isPrefix(IPath prefix, IPath path) {
        int segCount = prefix.segmentCount();
        if (segCount >= path.segmentCount()) {
            return false;
        }
        String prefixString = prefix.toOSString();
        String pathString = path.removeLastSegments(path.segmentCount() - segCount).toOSString();
        return prefixString.equalsIgnoreCase(pathString);
    }

    @Override
    public void setSearchForDuplicateFiles(boolean search) {
        this.fSearchForDuplicateFiles = search;
    }

    @Override
    public boolean searchForDuplicateFiles() {
        return this.fSearchForDuplicateFiles;
    }

    @Override
    public boolean searchSubfolders() {
        return this.fSearchSubfolders;
    }

    public void setSearchSubfolders(boolean search) {
        this.resetFolders();
        this.fSearchSubfolders = search;
    }

    protected File[] getFolders() {
        if (this.fFolders == null) {
            this.initializeFolders();
        }
        return this.fFolders;
    }

    protected void resetFolders() {
        this.fFolders = null;
    }

    private void initializeFolders() {
        if (this.getDirectory() != null) {
            ArrayList<File> list = new ArrayList<File>();
            File root = this.getDirectory().toFile();
            list.add(root);
            if (this.searchSubfolders()) {
                list.addAll(this.getFileFolders(root));
            }
            this.fFolders = list.toArray(new File[list.size()]);
        }
    }

    private List<File> getFileFolders(File file) {
        ArrayList<File> list = new ArrayList<File>();
        File[] folders = file.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        list.addAll((Collection)Arrays.asList(folders));
        int i = 0;
        while (i < folders.length) {
            list.addAll(this.getFileFolders(folders[i]));
            ++i;
        }
        return list;
    }

    public String toString() {
        return this.getDirectory() != null ? this.getDirectory().toOSString() : "";
    }

    @Override
    public void dispose() {
    }
}

