/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.rse;

import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.remote.IRemoteConnection;
import org.eclipse.ptp.remote.exception.RemoteConnectionException;
import org.eclipse.ptp.remote.exception.UnableToForwardPortException;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.services.shells.IShellService;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.IShellServiceSubSystem;
import org.eclipse.swt.widgets.Display;

public class RSEConnection
implements IRemoteConnection {
    private IHost rseHost;
    private IFileSystem fileSystem;
    private IShellService shellService = null;
    private ISubSystem subSystem = null;

    public RSEConnection(IHost host, IFileSystem fileSystem) {
        this.rseHost = host;
        this.fileSystem = fileSystem;
    }

    public void close(IProgressMonitor monitor) {
        if (this.subSystem != null && this.subSystem.isConnected()) {
            try {
                this.subSystem.disconnect();
            }
            catch (Exception exception) {}
        }
    }

    public void forwardLocalPort(int localPort, String fwdAddress, int fwdPort) throws RemoteConnectionException {
        throw new UnableToForwardPortException("Port forwarding not supported");
    }

    public int forwardLocalPort(String fwdAddress, int fwdPort, IProgressMonitor monitor) throws RemoteConnectionException {
        throw new UnableToForwardPortException("Port forwarding not supported");
    }

    public void forwardRemotePort(int remotePort, String fwdAddress, int fwdPort) throws RemoteConnectionException {
        throw new UnableToForwardPortException("Port forwarding not supported");
    }

    public int forwardRemotePort(String fwdAddress, int fwdPort, IProgressMonitor monitor) throws RemoteConnectionException {
        throw new UnableToForwardPortException("Port forwarding not supported");
    }

    public IFileSystem getFileSystem() {
        return this.fileSystem;
    }

    public IHost getHost() {
        return this.rseHost;
    }

    public String getAddress() {
        return this.rseHost.getHostName();
    }

    public String getName() {
        return this.rseHost.getAliasName();
    }

    public IShellService getRemoteShellService() {
        return this.shellService;
    }

    public String getUsername() {
        return this.rseHost.getDefaultUserId();
    }

    public boolean isOpen() {
        return this.subSystem != null && this.subSystem.isConnected();
    }

    public void open(final IProgressMonitor monitor) throws RemoteConnectionException {
        if (this.subSystem == null) {
            ISubSystem[] subSystems;
            ISubSystem[] iSubSystemArray = subSystems = this.rseHost.getSubSystems();
            int n = subSystems.length;
            int n2 = 0;
            while (n2 < n) {
                ISubSystem sub = iSubSystemArray[n2];
                if (sub instanceof IShellServiceSubSystem) {
                    this.subSystem = sub;
                    break;
                }
                ++n2;
            }
            if (this.subSystem == null) {
                throw new RemoteConnectionException("Could not locate shell service");
            }
            this.shellService = ((IShellServiceSubSystem)this.subSystem).getShellService();
        }
        if (!this.subSystem.isConnected()) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    try {
                        RSEConnection.this.subSystem.connect(monitor, false);
                    }
                    catch (Exception exception) {}
                }
            });
            if (!this.subSystem.isConnected()) {
                throw new RemoteConnectionException("Could not connect shell service");
            }
        }
    }

    public void setAddress(String address) {
        this.rseHost.setHostName(address);
    }

    public void setUsername(String username) {
        this.rseHost.setDefaultUserId(username);
    }

    public boolean supportsTCPPortForwarding() {
        return false;
    }
}

