/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.remote.IRemoteFileManager;
import org.eclipse.ptp.remote.PTPRemotePlugin;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class LocalFileManager
implements IRemoteFileManager {
    public IPath browseDirectory(Shell shell, String message, String filterPath) {
        Object path;
        DirectoryDialog dialog = new DirectoryDialog(PTPRemotePlugin.getShell());
        dialog.setText(message);
        if (filterPath != null && ((File)(path = new File(filterPath))).exists()) {
            dialog.setFilterPath(((File)path).isFile() ? ((File)path).getParent() : filterPath);
        }
        if ((path = dialog.open()) == null) {
            return null;
        }
        return new Path((String)path);
    }

    public IPath browseFile(Shell shell, String message, String filterPath) {
        Object path;
        FileDialog dialog = new FileDialog(PTPRemotePlugin.getShell(), 2);
        dialog.setText(message);
        if (filterPath != null && ((File)(path = new File(filterPath))).exists()) {
            dialog.setFilterPath(((File)path).isFile() ? ((File)path).getParent() : filterPath);
        }
        if ((path = dialog.open()) == null) {
            return null;
        }
        return new Path((String)path);
    }

    public IFileStore getResource(IPath path, IProgressMonitor monitor) throws IOException {
        try {
            IFileStore iFileStore = EFS.getLocalFileSystem().getStore(path);
            return iFileStore;
        }
        finally {
            monitor.done();
        }
    }

    public IPath getWorkingDirectory() {
        return new Path(System.getProperty("user.dir"));
    }

    public IPath toPath(URI uri) {
        return URIUtil.toPath((URI)uri);
    }

    public URI toURI(IPath path) {
        return URIUtil.toURI((IPath)path);
    }
}

