/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.sdm.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.core.attributes.ArrayAttribute;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.attributes.IntegerAttribute;
import org.eclipse.ptp.core.attributes.StringAttribute;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.attributes.JobAttributes;
import org.eclipse.ptp.debug.core.IPDebugger;
import org.eclipse.ptp.debug.core.launch.IPLaunch;
import org.eclipse.ptp.debug.core.pdi.IPDIDebugger;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.Session;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEventFactory;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIManagerFactory;
import org.eclipse.ptp.debug.core.pdi.model.IPDIModelFactory;
import org.eclipse.ptp.debug.core.pdi.request.IPDIRequestFactory;
import org.eclipse.ptp.debug.sdm.core.SDMDebugCorePlugin;
import org.eclipse.ptp.debug.sdm.core.SDMEventFactory;
import org.eclipse.ptp.debug.sdm.core.SDMManagerFactory;
import org.eclipse.ptp.debug.sdm.core.SDMModelFactory;
import org.eclipse.ptp.debug.sdm.core.SDMPreferenceConstants;
import org.eclipse.ptp.debug.sdm.core.SDMRequestFactory;
import org.eclipse.ptp.debug.sdm.core.pdi.PDIDebugger;
import org.eclipse.ptp.launch.PTPLaunchPlugin;

public class SDMDebugger
implements IPDebugger {
    private IPDIDebugger pdiDebugger = null;
    private IPDIModelFactory modelFactory = null;
    private IPDIManagerFactory managerFactory = null;
    private IPDIEventFactory eventFactory = null;
    private IPDIRequestFactory requestFactory = null;

    public IPDISession createDebugSession(long timeout, IPLaunch launch, IPath corefile) throws CoreException {
        if (this.modelFactory == null) {
            this.modelFactory = new SDMModelFactory();
        }
        if (this.managerFactory == null) {
            this.managerFactory = new SDMManagerFactory();
        }
        if (this.eventFactory == null) {
            this.eventFactory = new SDMEventFactory();
        }
        if (this.requestFactory == null) {
            this.requestFactory = new SDMRequestFactory();
        }
        return this.createSession(timeout, launch, corefile);
    }

    public void initialize(ILaunchConfiguration configuration, AttributeManager attrMgr, IProgressMonitor monitor) throws CoreException {
        ArrayAttribute dbgArgsAttr = (ArrayAttribute)attrMgr.getAttribute((IAttributeDefinition)JobAttributes.getDebuggerArgumentsAttributeDefinition());
        if (dbgArgsAttr == null) {
            dbgArgsAttr = JobAttributes.getDebuggerArgumentsAttributeDefinition().create();
            attrMgr.addAttribute((IAttribute)dbgArgsAttr);
        }
        List dbgArgs = dbgArgsAttr.getValue();
        try {
            this.getDebugger().initialize(configuration, dbgArgs, monitor);
        }
        catch (PDIException e) {
            throw this.newCoreException(e);
        }
    }

    public void getLaunchAttributes(ILaunchConfiguration configuration, AttributeManager attrMgr) throws CoreException {
        String dbgExePath;
        String dbgExtraArgs;
        ArrayAttribute dbgArgsAttr = (ArrayAttribute)attrMgr.getAttribute((IAttributeDefinition)JobAttributes.getDebuggerArgumentsAttributeDefinition());
        if (dbgArgsAttr == null) {
            dbgArgsAttr = JobAttributes.getDebuggerArgumentsAttributeDefinition().create();
            attrMgr.addAttribute((IAttribute)dbgArgsAttr);
        }
        List dbgArgs = dbgArgsAttr.getValue();
        Preferences store = SDMDebugCorePlugin.getDefault().getPluginPreferences();
        String localAddress = configuration.getAttribute("org.eclipse.ptp.launch.ATTR_DEBUGGER_HOST", "localhost");
        dbgArgs.add("--host=" + localAddress);
        dbgArgs.add("--debugger=" + store.getString(SDMPreferenceConstants.SDM_DEBUGGER_BACKEND_TYPE));
        String dbgPath = store.getString(SDMPreferenceConstants.SDM_DEBUGGER_BACKEND_PATH);
        if (dbgPath.length() > 0) {
            dbgArgs.add("--debugger_path=" + dbgPath);
        }
        if ((dbgExtraArgs = store.getString(SDMPreferenceConstants.SDM_DEBUGGER_ARGS)).length() > 0) {
            dbgArgs.addAll((Collection)Arrays.asList(dbgExtraArgs.split(" ")));
        }
        if ((dbgExePath = configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_EXECUTABLE_PATH", null)) == null) {
            dbgExePath = store.getString(SDMPreferenceConstants.SDM_DEBUGGER_FILE);
        }
        PTPLaunchPlugin.getDefault().verifyResource(dbgExePath, configuration);
        Path path = new Path(dbgExePath);
        attrMgr.addAttribute((IAttribute)JobAttributes.getDebuggerExecutableNameAttributeDefinition().create(path.lastSegment()));
        attrMgr.addAttribute((IAttribute)JobAttributes.getDebuggerExecutablePathAttributeDefinition().create(path.removeLastSegments(1).toString()));
        String dbgWD = configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_WORKING_DIR", null);
        if (dbgWD != null) {
            StringAttribute wdAttr = (StringAttribute)attrMgr.getAttribute((IAttributeDefinition)JobAttributes.getWorkingDirectoryAttributeDefinition());
            if (wdAttr != null) {
                wdAttr.setValueAsString(dbgWD);
            } else {
                attrMgr.addAttribute((IAttribute)JobAttributes.getWorkingDirectoryAttributeDefinition().create(dbgWD));
            }
            attrMgr.addAttribute((IAttribute)JobAttributes.getExecutablePathAttributeDefinition().create(String.valueOf(dbgWD) + "/Debug"));
        }
        attrMgr.addAttribute((IAttribute)JobAttributes.getDebugFlagAttributeDefinition().create(Boolean.valueOf(true)));
    }

    private IPDIDebugger getDebugger() {
        if (this.pdiDebugger == null) {
            this.pdiDebugger = new PDIDebugger();
        }
        return this.pdiDebugger;
    }

    private int getJobSize(IPJob job) {
        IntegerAttribute numProcAttr = (IntegerAttribute)job.getAttribute((IAttributeDefinition)JobAttributes.getNumberOfProcessesAttributeDefinition());
        if (numProcAttr != null) {
            return numProcAttr.getValue();
        }
        return 1;
    }

    private CoreException newCoreException(Throwable exception) {
        MultiStatus status = new MultiStatus(SDMDebugCorePlugin.getUniqueIdentifier(), 1000, "Cannot start debugging", exception);
        status.add((IStatus)new Status(4, SDMDebugCorePlugin.getUniqueIdentifier(), 1000, exception == null ? new String() : exception.getLocalizedMessage(), exception));
        return new CoreException((IStatus)status);
    }

    protected Session createSession(long timeout, IPLaunch launch, IPath corefile) throws CoreException {
        IPJob job = launch.getPJob();
        int job_size = this.getJobSize(job);
        try {
            return new Session(this.managerFactory, this.requestFactory, this.eventFactory, this.modelFactory, launch.getLaunchConfiguration(), timeout, this.getDebugger(), job.getID(), job_size);
        }
        catch (PDIException e) {
            throw this.newCoreException(e);
        }
    }
}

