/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.utils.ui.swt;

import org.eclipse.ptp.remotetools.utils.ui.swt.FrameMold;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class Frame
extends Composite {
    private Composite topUserReservedComposite;
    private Composite bottomUserReservedComposite;
    private Composite enclosingControl;
    private Button expandButton;
    private Label descriptionLabel;
    private Group enclosingGroup;
    private boolean isExpandedLayout;
    private String expandButtonLabel = "More options";
    private String shrinkButtonLabel = "Less options";
    private int debugBitmask = 0;

    public Frame(Composite parent, FrameMold mold) {
        this(parent, mold.bitmask, mold.columns);
        if (mold.description != null) {
            this.setDescription(mold.description);
        }
        if (mold.title != null) {
            this.setTitle(mold.getTitle());
        }
        if ((mold.bitmask & FrameMold.HAS_EXPAND) != 0 && mold.expandButtonLabel != null) {
            this.setExpandButtonLabel(mold.expandButtonLabel);
        }
        if ((mold.bitmask & FrameMold.HAS_EXPAND) != 0 && mold.shrinkButtonLabel != null) {
            this.setShrinkButtonLabel(mold.shrinkButtonLabel);
        }
    }

    public Frame(Composite parent, int bitmask, int columns) {
        super(parent, 0);
        this.createContent(bitmask, columns);
    }

    public Frame(Composite parent) {
        this(parent, 0, 1);
    }

    public Frame(Composite parent, int columns) {
        this(parent, 0, columns);
    }

    public Frame(Composite parent, String title) {
        this(parent, FrameMold.HAS_FRAME, 1);
        this.setTitle(title);
    }

    protected void createContent(int bitmask, int columns) {
        this.createEnclosingControl(bitmask);
        this.createTopUserComposite(bitmask, columns);
        this.createSeparatorComposite(bitmask);
        this.createBottomUserComposite(bitmask, columns);
        this.changeExpandLayout(false);
    }

    private void createEnclosingControl(int bitmask) {
        if ((bitmask & FrameMold.HAS_FRAME) != 0) {
            FillLayout fillLayout = new FillLayout();
            fillLayout.type = 256;
            fillLayout.marginHeight = 0;
            fillLayout.marginWidth = 0;
            fillLayout.spacing = 0;
            this.setLayout((Layout)fillLayout);
            this.enclosingGroup = new Group((Composite)this, this.debugBitmask);
            this.enclosingControl = this.enclosingGroup;
        } else {
            this.enclosingControl = this;
        }
        GridLayout enclosingControlLayout = new GridLayout();
        if ((bitmask & FrameMold.HAS_FRAME) != 0) {
            enclosingControlLayout.numColumns = 2;
            enclosingControlLayout.marginHeight = 0;
            enclosingControlLayout.marginWidth = 0;
            enclosingControlLayout.marginRight = 5;
            enclosingControlLayout.marginLeft = 5;
            enclosingControlLayout.marginBottom = 5;
            enclosingControlLayout.marginTop = 5;
            enclosingControlLayout.horizontalSpacing = 4;
            enclosingControlLayout.verticalSpacing = 5;
        } else {
            enclosingControlLayout.marginHeight = 0;
            enclosingControlLayout.marginWidth = 0;
            enclosingControlLayout.marginRight = 0;
            enclosingControlLayout.marginLeft = 0;
            enclosingControlLayout.marginBottom = 0;
            enclosingControlLayout.marginTop = 0;
            enclosingControlLayout.horizontalSpacing = 4;
            enclosingControlLayout.verticalSpacing = 5;
        }
        this.enclosingControl.setLayout((Layout)enclosingControlLayout);
        Composite parent = this.getParent();
        Layout parentLayout = parent.getLayout();
        if (parentLayout instanceof GridLayout) {
            GridData layoutData = (GridData)this.getLayoutData();
            if (layoutData == null) {
                layoutData = new GridData();
            }
            layoutData.grabExcessHorizontalSpace = true;
            layoutData.horizontalAlignment = 4;
            this.setLayoutData(layoutData);
        }
    }

    private void createTopUserComposite(int bitmask, int columns) {
        boolean needComposite;
        boolean bl = needComposite = (bitmask & FrameMold.HAS_DESCRIPTION) != 0 || (bitmask & FrameMold.HAS_EXPAND) != 0;
        if (needComposite) {
            this.topUserReservedComposite = new Composite(this.enclosingControl, this.debugBitmask);
            GridData topUserReservedCompositeLayoutData = new GridData();
            topUserReservedCompositeLayoutData.horizontalSpan = 2;
            topUserReservedCompositeLayoutData.grabExcessHorizontalSpace = true;
            topUserReservedCompositeLayoutData.grabExcessVerticalSpace = false;
            topUserReservedCompositeLayoutData.horizontalAlignment = 4;
            topUserReservedCompositeLayoutData.verticalAlignment = 4;
            this.topUserReservedComposite.setLayoutData((Object)topUserReservedCompositeLayoutData);
            GridLayout userReservedLayout = new GridLayout();
            userReservedLayout.marginHeight = 0;
            userReservedLayout.marginWidth = 0;
            userReservedLayout.marginRight = 0;
            userReservedLayout.marginLeft = 0;
            userReservedLayout.marginBottom = 0;
            userReservedLayout.marginTop = 0;
            userReservedLayout.horizontalSpacing = 4;
            userReservedLayout.verticalSpacing = 5;
            userReservedLayout.numColumns = columns;
            this.topUserReservedComposite.setLayout((Layout)userReservedLayout);
        } else {
            this.topUserReservedComposite = this.enclosingControl;
            GridLayout layout = (GridLayout)this.enclosingControl.getLayout();
            layout.numColumns = columns;
            if ((bitmask & FrameMold.COLUMNS_EQUAL_WIDTH) != 0) {
                layout.makeColumnsEqualWidth = true;
            }
            this.enclosingControl.setLayout((Layout)layout);
        }
    }

    private void createBottomUserComposite(int bitmask, int columns) {
        if ((bitmask & FrameMold.HAS_EXPAND) != 0) {
            this.bottomUserReservedComposite = new Composite(this.enclosingControl, this.debugBitmask);
            GridData bottomUserReservedCompositeLayoutData = new GridData();
            bottomUserReservedCompositeLayoutData.horizontalSpan = 2;
            bottomUserReservedCompositeLayoutData.grabExcessHorizontalSpace = true;
            bottomUserReservedCompositeLayoutData.grabExcessVerticalSpace = false;
            bottomUserReservedCompositeLayoutData.horizontalAlignment = 4;
            bottomUserReservedCompositeLayoutData.verticalAlignment = 4;
            this.bottomUserReservedComposite.setLayoutData((Object)bottomUserReservedCompositeLayoutData);
            GridLayout userReservedLayout = new GridLayout();
            userReservedLayout.marginHeight = 0;
            userReservedLayout.marginWidth = 0;
            userReservedLayout.marginRight = 0;
            userReservedLayout.marginLeft = 0;
            userReservedLayout.marginBottom = 0;
            userReservedLayout.marginTop = 0;
            userReservedLayout.horizontalSpacing = 4;
            userReservedLayout.verticalSpacing = 5;
            userReservedLayout.numColumns = columns;
            if ((bitmask & FrameMold.COLUMNS_EQUAL_WIDTH) != 0) {
                userReservedLayout.makeColumnsEqualWidth = true;
            }
            this.bottomUserReservedComposite.setLayout((Layout)userReservedLayout);
        }
    }

    private void createSeparatorComposite(int bitmask) {
        if ((bitmask & FrameMold.HAS_DESCRIPTION) != 0) {
            this.descriptionLabel = new Label(this.enclosingControl, 0x40 | this.debugBitmask);
            GridData descriptionLabeLayoutData = new GridData();
            descriptionLabeLayoutData.horizontalSpan = (bitmask & FrameMold.HAS_EXPAND) != 0 ? 1 : 2;
            descriptionLabeLayoutData.grabExcessHorizontalSpace = true;
            descriptionLabeLayoutData.grabExcessVerticalSpace = false;
            descriptionLabeLayoutData.horizontalAlignment = 4;
            descriptionLabeLayoutData.verticalAlignment = 4;
            this.descriptionLabel.setLayoutData((Object)descriptionLabeLayoutData);
        }
        if ((bitmask & FrameMold.HAS_EXPAND) != 0) {
            this.expandButton = new Button(this.enclosingControl, 524288);
            GridData buttonLayoutData = new GridData();
            buttonLayoutData.horizontalSpan = (bitmask & FrameMold.HAS_DESCRIPTION) != 0 ? 1 : 2;
            buttonLayoutData.grabExcessHorizontalSpace = false;
            buttonLayoutData.grabExcessVerticalSpace = false;
            buttonLayoutData.horizontalAlignment = 131072;
            buttonLayoutData.verticalAlignment = 1024;
            this.expandButton.setLayoutData((Object)buttonLayoutData);
            this.expandButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Frame.this.changeExpandLayout(!Frame.this.isExpandedLayout);
                    Frame.this.adjustShellSizeToFrame();
                }
            });
        }
    }

    private void changeExpandLayout(boolean visible) {
        if (this.bottomUserReservedComposite == null) {
            return;
        }
        if (this.expandButton == null) {
            return;
        }
        this.isExpandedLayout = visible;
        GridData bottomUserReservedCompositeLayoutData = (GridData)this.bottomUserReservedComposite.getLayoutData();
        if (this.isExpandedLayout) {
            bottomUserReservedCompositeLayoutData.exclude = false;
            this.bottomUserReservedComposite.setVisible(true);
        } else {
            bottomUserReservedCompositeLayoutData.exclude = true;
            this.bottomUserReservedComposite.setVisible(false);
        }
        this.bottomUserReservedComposite.setLayoutData((Object)bottomUserReservedCompositeLayoutData);
        this.updateExpandButton();
    }

    private void updateExpandButton() {
        if (this.expandButton == null) {
            return;
        }
        String newLabel = null;
        newLabel = this.isExpandedLayout ? this.shrinkButtonLabel : this.expandButtonLabel;
        if (newLabel != null) {
            this.expandButton.setText(newLabel);
        } else {
            this.expandButton.setText("");
        }
    }

    private void adjustShellSizeToFrame() {
        Point newSize = this.enclosingControl.computeSize(-1, -1);
        Point currentSize = this.enclosingControl.getSize();
        int deltaY = newSize.y - currentSize.y;
        Point shellSize = this.getShell().getSize();
        shellSize.y += deltaY;
        this.getShell().setSize(shellSize);
        this.getShell().layout(true, true);
    }

    public Composite getTopUserReservedComposite() {
        return this.topUserReservedComposite;
    }

    public Composite getComposite() {
        return this.topUserReservedComposite;
    }

    public Composite getBottomUserReservedComposite() {
        return this.bottomUserReservedComposite;
    }

    public boolean isExpanded() {
        return this.isExpandedLayout;
    }

    public void setExpanded(boolean expanded) {
        this.changeExpandLayout(expanded);
        this.adjustShellSizeToFrame();
    }

    public String getExpandButtonLabel() {
        return this.expandButtonLabel;
    }

    public void setExpandButtonLabel(String expandButtonLabel) {
        if (this.expandButton == null) {
            throw new IllegalArgumentException("Frame has not expand button to set label");
        }
        this.expandButtonLabel = expandButtonLabel;
        this.updateExpandButton();
    }

    public String getShrinkButtonLabel() {
        return this.shrinkButtonLabel;
    }

    public void setShrinkButtonLabel(String shrinkButtonLabel) {
        if (this.expandButton == null) {
            throw new IllegalArgumentException("Frame has not expand button to set label");
        }
        this.shrinkButtonLabel = shrinkButtonLabel;
        this.updateExpandButton();
    }

    public String getTitle() {
        if (this.enclosingGroup != null) {
            return this.enclosingGroup.getText();
        }
        return null;
    }

    public void setTitle(String label) {
        if (this.enclosingGroup == null) {
            throw new IllegalArgumentException("Frame has not enclosing group to set title");
        }
        this.enclosingGroup.setText(label);
    }

    public String getDescription() {
        if (this.descriptionLabel != null) {
            return this.descriptionLabel.getText();
        }
        return null;
    }

    public void setDescription(String description) {
        if (this.descriptionLabel == null) {
            throw new IllegalArgumentException("Frame has no description to be set");
        }
        this.descriptionLabel.setText(description);
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginHeight = 10;
        fillLayout.marginWidth = 10;
        shell.setLayout((Layout)fillLayout);
        FrameMold mold = new FrameMold("Frame 1", true);
        new Frame((Composite)shell, mold);
        shell.pack(true);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }
}

