/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core.elements.attributes;

import org.eclipse.ptp.core.attributes.EnumeratedAttributeDefinition;
import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.attributes.IntegerAttributeDefinition;
import org.eclipse.ptp.core.attributes.StringAttributeDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessAttributes {
    private static final String STATE_ATTR_ID = "processState";
    private static final String PID_ATTR_ID = "processPID";
    private static final String EXIT_CODE_ATTR_ID = "processExitCode";
    private static final String SIGNAL_NAME_ATTR_ID = "processSignalName";
    private static final String INDEX_ATTR_ID = "processIndex";
    private static final String STDOUT_ATTR_ID = "processStdout";
    private static final String STDERR_ATTR_ID = "processStderr";
    private static final String NODEID_ATTR_ID = "processNodeId";
    private static final EnumeratedAttributeDefinition<State> stateAttrDef = new EnumeratedAttributeDefinition<State>("processState", "State", "Execution state of a process", true, State.STARTING);
    private static final IntegerAttributeDefinition pidAttrDef = new IntegerAttributeDefinition("processPID", "PID", "Operating system process ID", true, 0);
    private static final IntegerAttributeDefinition exitCodeAttrDef = new IntegerAttributeDefinition("processExitCode", "Exit Code", "Operating system exit code", true, 0);
    private static final IntegerAttributeDefinition indexAttrDef = new IntegerAttributeDefinition("processIndex", "Index", "Zero-based index of process (e.g. MPI rank)", true, 0);
    private static final StringAttributeDefinition signalNameAttrDef = new StringAttributeDefinition("processSignalName", "Exit Signal", "Name of signal that caused process termination", true, "");
    private static final StringAttributeDefinition stdoutAttrDef = new StringAttributeDefinition("processStdout", "Process Stdout", "Standard output from process", false, "");
    private static final StringAttributeDefinition stderrAttrDef = new StringAttributeDefinition("processStderr", "Process Stderr", "Standard error from process", false, "");
    private static final StringAttributeDefinition nodeIdAttrDef = new StringAttributeDefinition("processNodeId", "Process Node ID", "Node that this process is running on", true, "");

    public static EnumeratedAttributeDefinition<State> getStateAttributeDefinition() {
        return stateAttrDef;
    }

    public static IntegerAttributeDefinition getPIDAttributeDefinition() {
        return pidAttrDef;
    }

    public static IntegerAttributeDefinition getExitCodeAttributeDefinition() {
        return exitCodeAttrDef;
    }

    public static IntegerAttributeDefinition getIndexAttributeDefinition() {
        return indexAttrDef;
    }

    public static StringAttributeDefinition getSignalNameAttributeDefinition() {
        return signalNameAttrDef;
    }

    public static StringAttributeDefinition getStdoutAttributeDefinition() {
        return stdoutAttrDef;
    }

    public static StringAttributeDefinition getStderrAttributeDefinition() {
        return stderrAttrDef;
    }

    public static StringAttributeDefinition getNodeIdAttributeDefinition() {
        return nodeIdAttrDef;
    }

    public static IAttributeDefinition<?, ?, ?>[] getDefaultAttributeDefinitions() {
        return new IAttributeDefinition[]{stateAttrDef, pidAttrDef, exitCodeAttrDef, indexAttrDef, signalNameAttrDef, stdoutAttrDef, stderrAttrDef, nodeIdAttrDef};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        STARTING,
        RUNNING,
        EXITED,
        EXITED_SIGNALLED,
        SUSPENDED,
        ERROR,
        UNKNOWN;

    }
}

