/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.debug.be.cdi.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIList;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;
import org.eclipse.ptp.cell.debug.be.BEMessages;
import org.eclipse.ptp.cell.debug.be.cdi.command.output.MISPUDMAElement;
import org.eclipse.ptp.cell.debug.be.cdi.command.output.MISPUDMAListTuple;

public class CellMISPUDMAInfoInfo
extends MIInfo {
    private MISPUDMAElement[] dmacmds;
    private MISPUDMAListTuple[] dmacmdlist;

    public CellMISPUDMAInfoInfo(MIOutput out) {
        super(out);
    }

    public MISPUDMAListTuple[] getDMAcmdlist() {
        if (this.dmacmdlist == null) {
            this.parse();
        }
        return this.dmacmdlist;
    }

    public MISPUDMAElement[] getDMAcmds() {
        if (this.dmacmds == null) {
            this.parse();
        }
        return this.dmacmds;
    }

    protected void parse() {
        MIOutput out;
        MIResultRecord rr;
        if (this.isDone() && (rr = (out = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] results = rr.getMIResults();
            int i = 0;
            while (i < results.length) {
                MIValue val;
                String var = results[i].getVariable();
                if (var.equals("SPUInfoDMA") && (val = results[i].getMIValue()) instanceof MITuple) {
                    this.parseOutterTuple((MITuple)val);
                }
                ++i;
            }
        }
    }

    protected void parseOutterTuple(MITuple tuples) {
        ArrayList<MISPUDMAListTuple> aList = new ArrayList<MISPUDMAListTuple>();
        ArrayList<MISPUDMAElement> bList = new ArrayList<MISPUDMAElement>();
        MIResult[] tables = tuples.getMIResults();
        int j = 0;
        while (j < tables.length) {
            String tableName = tables[j].getVariable();
            if (tableName.equals("dma_cmd")) {
                MIValue tableContent = tables[j].getMIValue();
                this.parseTable(tableContent, aList);
            } else if (tableName.equals("dma_info_type")) {
                bList.add(new MISPUDMAElement(tables[j]));
            } else if (tableName.equals("dma_info_mask")) {
                bList.add(new MISPUDMAElement(tables[j]));
            } else if (tableName.equals("dma_info_status")) {
                bList.add(new MISPUDMAElement(tables[j]));
            } else if (tableName.equals("dma_info_stall_and_notify")) {
                bList.add(new MISPUDMAElement(tables[j]));
            } else if (tableName.equals("dma_info_atomic_command_status")) {
                bList.add(new MISPUDMAElement(tables[j]));
            }
            ++j;
        }
        if (aList.size() == 0) {
            aList.add(new MISPUDMAListTuple(BEMessages.getString("SPUEnhancementsProcessor.0"), BEMessages.getString("SPUEnhancementsProcessor.0"), BEMessages.getString("SPUEnhancementsProcessor.0"), BEMessages.getString("SPUEnhancementsProcessor.0"), BEMessages.getString("SPUEnhancementsProcessor.0"), BEMessages.getString("SPUEnhancementsProcessor.0"), BEMessages.getString("SPUEnhancementsProcessor.0"), BEMessages.getString("SPUEnhancementsProcessor.0"), BEMessages.getString("SPUEnhancementsProcessor.0"), BEMessages.getString("SPUEnhancementsProcessor.0")));
        }
        if (bList.size() == 0) {
            bList.add(new MISPUDMAElement("dma_info_type", BEMessages.getString("SPUEnhancementsProcessor.0")));
            bList.add(new MISPUDMAElement("dma_info_mask", BEMessages.getString("SPUEnhancementsProcessor.0")));
            bList.add(new MISPUDMAElement("dma_info_status", BEMessages.getString("SPUEnhancementsProcessor.0")));
            bList.add(new MISPUDMAElement("dma_info_stall_and_notify", BEMessages.getString("SPUEnhancementsProcessor.0")));
            bList.add(new MISPUDMAElement("dma_info_atomic_command_status", BEMessages.getString("SPUEnhancementsProcessor.0")));
        }
        this.dmacmdlist = aList.toArray(new MISPUDMAListTuple[0]);
        this.dmacmds = bList.toArray(new MISPUDMAElement[0]);
    }

    protected void parseTable(MIValue val, List aList) {
        if (val instanceof MITuple) {
            MIResult[] table = ((MITuple)val).getMIResults();
            int j = 0;
            while (j < table.length) {
                String variable = table[j].getVariable();
                if (variable.equals("body")) {
                    this.parseBody(table[j].getMIValue(), aList);
                }
                ++j;
            }
        }
    }

    protected void parseBody(MIValue body, List aList) {
        if (body instanceof MIList) {
            MIResult[] mboxs = ((MIList)body).getMIResults();
            int i = 0;
            while (i < mboxs.length) {
                MIValue value;
                String m = mboxs[i].getVariable();
                if (m.equals("cmd") && (value = mboxs[i].getMIValue()) instanceof MITuple) {
                    this.parseTuple((MITuple)value, aList, i);
                }
                ++i;
            }
        }
    }

    protected void parseTuple(MITuple tuple, List aList, int row) {
        MIResult[] args = tuple.getMIResults();
        aList.add(new MISPUDMAListTuple(args));
    }
}

