/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.environment.cellsimulator.core.local;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.cell.environment.cellsimulator.CellSimulatorTargetPlugin;
import org.eclipse.ptp.cell.environment.cellsimulator.conf.AttributeNames;
import org.eclipse.ptp.cell.environment.cellsimulator.core.common.CommonConfigFactory;
import org.eclipse.ptp.cell.environment.cellsimulator.core.local.LocalConfigurationBean;
import org.eclipse.ptp.cell.environment.cellsimulator.core.local.LocalSimulatorConfiguration;
import org.eclipse.ptp.cell.simulator.conf.Parameters;
import org.eclipse.ptp.cell.simulator.core.ISimulatorParameters;
import org.eclipse.ptp.remotetools.utils.verification.ControlAttributes;
import org.eclipse.ptp.remotetools.utils.verification.IllegalAttributeException;

public class LocalConfigFactory
extends CommonConfigFactory {
    private LocalConfigurationBean bean;
    private String pluginId;

    public LocalConfigFactory(LocalConfigurationBean bean, String pluginId) {
        super(bean);
        this.bean = bean;
        this.pluginId = pluginId;
    }

    public LocalSimulatorConfiguration createLocalSimulatorParameters() throws CoreException {
        LocalSimulatorConfiguration parameters = new LocalSimulatorConfiguration();
        ControlAttributes attributes = this.bean.getAttributes();
        this.fillSimulatorParameters(parameters);
        try {
            if (attributes.getBoolean("automatic-work-directory", true)) {
                IPath path = CellSimulatorTargetPlugin.getDefault().getStateLocation();
                if (this.pluginId == null) {
                    this.pluginId = "new-cell-target";
                }
                path = path.append(this.pluginId);
                parameters.setWorkDirectory(path.toOSString());
            } else {
                parameters.setWorkDirectory(attributes.getString("work-directory", null));
            }
            parameters.setShowSimulatorGUI(attributes.getBoolean("show-simulator-gui", false));
            if (!attributes.getBoolean("automatic-network", true)) {
                parameters.setIpHost(attributes.getString("ip-host", null));
                parameters.setIpSimulator(attributes.getString("ip-simulator", null));
                parameters.setMacSimulator(attributes.getString("mac-simulator", null));
            }
            parameters.setNetmaskSimulator(org.eclipse.ptp.cell.environment.cellsimulator.conf.Parameters.SIMULATOR_NETMASK);
            if (Parameters.doUseJavaAPI()) {
                parameters.setJavaApiSocketInit(true);
                if (!attributes.getBoolean("automatic-portconfig", true)) {
                    parameters.setJavaApiPort(attributes.verifyInt(AttributeNames.JAVA_API_SOCKET_PORT, "java-api-socket-port"));
                }
                parameters.setJavaApiSocketPortTryWait(Integer.parseInt(org.eclipse.ptp.cell.environment.cellsimulator.conf.Parameters.JAVA_API_SOCKET_PORT_TRY_WAIT));
                parameters.setJavaApiSocketPortMaxTries(Integer.parseInt(org.eclipse.ptp.cell.environment.cellsimulator.conf.Parameters.JAVA_API_SOCKET_PORT_MAX_TRIES));
                if (Parameters.doHandleJavaApiGuiIssue()) {
                    parameters.setShowSimulatorGUI(false);
                }
            } else {
                parameters.setJavaApiSocketInit(false);
            }
            parameters.setConsoleSocketInit(true);
            if (!attributes.getBoolean("automatic-portconfig", true)) {
                parameters.setConsolePort(attributes.verifyInt(AttributeNames.CONSOLE_SOCKET_PORT, "console-socket-port"));
            }
            parameters.setConsoleSocketPortMaxTries(Integer.parseInt(org.eclipse.ptp.cell.environment.cellsimulator.conf.Parameters.CONSOLE_SOCKET_PORT_MAX_TRIES));
            parameters.setConsoleSocketPortTryWait(Integer.parseInt(org.eclipse.ptp.cell.environment.cellsimulator.conf.Parameters.CONSOLE_SOCKET_PORT_TRY_WAIT));
            parameters.setConsoleEcho(false);
            parameters.setConsoleTerminalInit(false);
            return parameters;
        }
        catch (IllegalAttributeException e) {
            throw new CoreException((IStatus)new Status(4, CellSimulatorTargetPlugin.getDefault().getBundle().getSymbolicName(), 0, e.getMessage(), (Throwable)e));
        }
    }

    public void completeSimulatorParametersWithConsoleConfig(LocalSimulatorConfiguration parameters) {
        this.completeSimulatorParametersWithJavaApiConfig(parameters, parameters.getConsolePort());
    }

    public void completeSimulatorParametersWithConsoleConfig(LocalSimulatorConfiguration parameters, int port) {
        parameters.setConsoleSocketHost(null);
        parameters.setConsoleSocketPort(port);
        parameters.setConsolePort(port);
    }

    public void completeSimulatorParametersWithJavaApiConfig(LocalSimulatorConfiguration parameters) {
        this.completeSimulatorParametersWithJavaApiConfig(parameters, parameters.getJavaApiPort());
    }

    public void completeSimulatorParametersWithJavaApiConfig(LocalSimulatorConfiguration parameters, int port) {
        parameters.setJavaApiSocketHost(null);
        parameters.setJavaApiSocketPort(port);
        parameters.setJavaApiPort(port);
    }

    public void completeSimulatorParametersWithNetworkConfig(LocalSimulatorConfiguration parameters, String ipSimulator, String macSimulator, String ipHost) {
        parameters.setIpHost(ipHost);
        parameters.setIpSimulator(ipSimulator);
        parameters.setMacSimulator(macSimulator);
    }

    public String getTargetID() {
        return this.bean.getAttributes().getString("core-environmentid");
    }

    public ISimulatorParameters createSimulatorParameters() throws CoreException {
        return this.createLocalSimulatorParameters();
    }
}

