/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.environment.launcher.pdt.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.cell.environment.launcher.cellbe.AbstractCellRemoteLaunchDelegate;
import org.eclipse.ptp.cell.environment.launcher.cellbe.CancelCallback;
import org.eclipse.ptp.cell.environment.launcher.cellbe.LaunchProcessWrapper;
import org.eclipse.ptp.cell.environment.launcher.cellbe.ProgressListener;
import org.eclipse.ptp.cell.environment.launcher.pdt.Activator;
import org.eclipse.ptp.cell.environment.launcher.pdt.debug.Debug;
import org.eclipse.ptp.cell.environment.launcher.pdt.internal.IPdtLaunchAttributes;
import org.eclipse.ptp.cell.environment.launcher.pdt.internal.Messages;
import org.eclipse.ptp.cell.environment.launcher.pdt.internal.PdtLaunchBean;
import org.eclipse.ptp.cell.environment.launcher.pdt.internal.integration.PdtProfileIntegration;
import org.eclipse.ptp.cell.ui.progress.ICancelCallback;
import org.eclipse.ptp.remotetools.environment.control.ITargetControl;
import org.eclipse.ptp.remotetools.environment.control.ITargetJob;
import org.eclipse.ptp.remotetools.environment.launcher.RemoteLauncherPlugin;
import org.eclipse.ptp.remotetools.environment.launcher.core.ILaunchIntegration;
import org.eclipse.ptp.remotetools.environment.launcher.core.ILaunchObserver;
import org.eclipse.ptp.remotetools.environment.launcher.core.ILaunchProcess;
import org.eclipse.ptp.remotetools.environment.launcher.core.ILaunchProgressListener;
import org.eclipse.ptp.remotetools.environment.launcher.data.ExecutionConfiguration;

public class PdtRemoteLaunchDelegate
extends AbstractCellRemoteLaunchDelegate {
    public String getPluginID() {
        return Activator.getDefault().getBundle().getSymbolicName();
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String envPdtConfigFile;
        Debug.POLICY.trace(Debug.DEBUG_LAUNCHER, "Start PDT launcher delegate.");
        Debug.POLICY.trace(Debug.DEBUG_LAUNCHER, "Launch configuration map: {0}", new Object[]{configuration.getAttributes().toString()});
        ITargetControl targetControl = this.getValidatedTargetControl(configuration);
        ILaunchObserver launchObserver = this.getOutputObserver(configuration);
        PdtProfileIntegration launchIntegration = null;
        assert (mode.equals("profile")) : "This launch must only run on PROFILE_MODE";
        boolean copyXmlFile = configuration.getAttribute(IPdtLaunchAttributes.ATTR_COPY_XML_FILE, IPdtLaunchAttributes.DEFAULT_COPY_XML_FILE.booleanValue());
        String remoteXmldirPath = configuration.getAttribute(IPdtLaunchAttributes.ATTR_REMOTE_XML_DIR, IPdtLaunchAttributes.DEFAULT_REMOTE_XML_DIR);
        String localXmlfilePath = configuration.getAttribute(IPdtLaunchAttributes.ATTR_LOCAL_XML_FILE, IPdtLaunchAttributes.DEFAULT_LOCAL_XML_FILE);
        String remoteXmlFile = configuration.getAttribute(IPdtLaunchAttributes.ATTR_REMOTE_XML_FILE, IPdtLaunchAttributes.DEFAULT_REMOTE_XML_FILE);
        String traceLibPath = configuration.getAttribute(IPdtLaunchAttributes.ATTR_TRACE_LIB_PATH, IPdtLaunchAttributes.DEFAULT_TRACE_LIB_PATH);
        String pdtModuleFilePath = configuration.getAttribute(IPdtLaunchAttributes.ATTR_PDT_MODULE_PATH, IPdtLaunchAttributes.DEFAULT_PDT_MODULE_PATH);
        String remoteTraceDirPath = configuration.getAttribute(IPdtLaunchAttributes.ATTR_REMOTE_TRACE_DIR, IPdtLaunchAttributes.DEFAULT_REMOTE_TRACE_DIR);
        String traceFilePrefix = configuration.getAttribute(IPdtLaunchAttributes.ATTR_TRACE_FILE_PREFIX, IPdtLaunchAttributes.DEFAULT_TRACE_FILE_PREFIX);
        PdtLaunchBean launchBean = new PdtLaunchBean();
        launchBean.setCopyXmlFile(copyXmlFile);
        launchBean.setRemoteXmlDirPath(remoteXmldirPath);
        launchBean.setLocalXmlFilePath(localXmlfilePath);
        launchBean.setRemoteXmlFile(remoteXmlFile);
        launchBean.setRemoteTraceDirPath(remoteTraceDirPath);
        launchBean.setTraceFilePrefix(traceFilePrefix);
        launchIntegration = new PdtProfileIntegration(configuration, mode, launch, monitor, launchBean);
        ExecutionConfiguration executionConfig = this.createExecutionConfig(configuration);
        executionConfig.addEnvironmentVariable("LD_LIBRARY_PATH=$LD_LIBRARY_PATH:" + traceLibPath);
        executionConfig.addEnvironmentVariable("PDT_KERNEL_MODULE=" + pdtModuleFilePath);
        if (copyXmlFile) {
            String xmlFilename = new Path(localXmlfilePath).lastSegment();
            envPdtConfigFile = String.valueOf(remoteXmldirPath) + '/' + xmlFilename;
        } else {
            envPdtConfigFile = remoteXmlFile;
        }
        executionConfig.addEnvironmentVariable("PDT_CONFIG_FILE=" + envPdtConfigFile);
        Debug.POLICY.trace(Debug.DEBUG_LAUNCHER_VARIABLES, "PDT_CONFIG_FILE=" + envPdtConfigFile);
        executionConfig.addEnvironmentVariable("PDT_TRACE_OUTPUT=" + remoteTraceDirPath);
        executionConfig.addEnvironmentVariable("PDT_OUTPUT_PREFIX=" + traceFilePrefix);
        ILaunchProcess launchProcess = RemoteLauncherPlugin.createRemoteLaunchProcess((ILaunch)launch, (ExecutionConfiguration)executionConfig, (ILaunchIntegration)launchIntegration);
        launchProcess.setLaunchObserver(launchObserver);
        LaunchProcessWrapper wrapper = new LaunchProcessWrapper(launchProcess);
        ProgressListener progressListener = new ProgressListener(executionConfig, monitor, (ICancelCallback)new CancelCallback(launchProcess));
        try {
            try {
                progressListener.start();
                launchProcess.addProgressListener((ILaunchProgressListener)progressListener);
                targetControl.startJob((ITargetJob)wrapper);
                progressListener.waitForLaunch();
            }
            catch (CoreException e) {
                Debug.POLICY.error(Debug.DEBUG_LAUNCHER, (Throwable)e);
                Debug.POLICY.logError((Throwable)e, Messages.getString("PdtRemoteLaunchDelegate.Pdt_Launch_Error"), new Object[0]);
                throw e;
            }
        }
        finally {
            Debug.POLICY.trace(Debug.DEBUG_LAUNCHER, "Finished launcher delegate.");
            launchProcess.removeProgressListener((ILaunchProgressListener)progressListener);
            progressListener.interrupt();
            monitor.done();
        }
    }
}

