/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.environment.ui.deploy.wizard;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.ptp.cell.environment.ui.deploy.DeployPlugin;
import org.eclipse.ptp.cell.environment.ui.deploy.debug.Debug;
import org.eclipse.ptp.cell.environment.ui.deploy.events.ExportJobWrapper;
import org.eclipse.ptp.cell.environment.ui.deploy.events.Messages;
import org.eclipse.ptp.cell.environment.ui.deploy.wizard.AbstractCellWizardPage;
import org.eclipse.ptp.remotetools.environment.control.ITargetControl;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.DialogUtil;
import org.eclipse.ui.internal.ide.dialogs.ResourceTreeAndListGroup;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CellExportResourcesPage
extends AbstractCellWizardPage {
    private ResourceTreeAndListGroup resourceGroup;
    private Label destinationLabel;
    private Text destinationText;
    private Table additionalItemsTable;
    private Button selectAdditionalFileButton;
    private Button selectAdditionalDirButton;
    private Button removeSelectedButton;
    private Button autoOverwriteCheckbox;
    private Button createDirStructure;
    private Button createSelectedDir;
    private int numberOfFiles;

    public CellExportResourcesPage(String pageName, ITargetControl control) {
        super(pageName, control);
        this.setTitle(Messages.CellExportResourcesPage_0);
        this.setDescription(Messages.CellExportResourcesPage_1);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.destinationText.setFocus();
    }

    protected void createAdditionalFilesGroup(Composite parent) {
        Font font = parent.getFont();
        Group filesGroup = new Group(parent, 0);
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 1;
        filesGroup.setLayout((Layout)groupLayout);
        filesGroup.setLayoutData((Object)new GridData(272));
        filesGroup.setText(Messages.CellExportResourcesPage_2);
        filesGroup.setFont(font);
        this.additionalItemsTable = new Table((Composite)filesGroup, 2);
        GridData tableData = new GridData(768);
        tableData.widthHint = 525;
        tableData.heightHint = 75;
        this.additionalItemsTable.setLayoutData((Object)tableData);
        this.additionalItemsTable.setFont(font);
        this.additionalItemsTable.setLinesVisible(false);
        this.additionalItemsTable.setHeaderVisible(true);
        this.additionalItemsTable.setEnabled(true);
        TableColumn column1 = new TableColumn(this.additionalItemsTable, 16384, 0);
        TableColumn column2 = new TableColumn(this.additionalItemsTable, 131072, 1);
        column1.setText(Messages.CellExportResourcesPage_3);
        column1.setWidth(515);
        column2.setText(Messages.CellExportResourcesPage_4);
        column2.setWidth(10);
        Composite comp = new Composite((Composite)filesGroup, 0);
        GridLayout compLayout = new GridLayout();
        compLayout.numColumns = 3;
        comp.setLayout((Layout)compLayout);
        comp.setLayoutData((Object)new GridData(48));
        this.selectAdditionalFileButton = new Button(comp, 8);
        this.selectAdditionalFileButton.setText(Messages.CellExportResourcesPage_5);
        this.selectAdditionalFileButton.addListener(13, (Listener)this);
        this.selectAdditionalFileButton.setFont(font);
        this.setButtonLayoutData(this.selectAdditionalFileButton);
        this.selectAdditionalDirButton = new Button(comp, 8);
        this.selectAdditionalDirButton.setText(Messages.CellExportResourcesPage_6);
        this.selectAdditionalDirButton.addListener(13, (Listener)this);
        this.selectAdditionalDirButton.setFont(font);
        this.setButtonLayoutData(this.selectAdditionalDirButton);
        this.removeSelectedButton = new Button(comp, 8);
        this.removeSelectedButton.setText(Messages.CellExportResourcesPage_7);
        this.removeSelectedButton.addListener(13, (Listener)this);
        this.removeSelectedButton.setFont(font);
        this.setButtonLayoutData(this.removeSelectedButton);
        new Label(parent, 0);
    }

    protected void createDestinationGroup(Composite parent) {
        Font font = parent.getFont();
        Group destGroup = new Group(parent, 0);
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 2;
        destGroup.setLayout((Layout)groupLayout);
        destGroup.setLayoutData((Object)new GridData(272));
        destGroup.setText(Messages.CellExportResourcesPage_8);
        destGroup.setFont(font);
        this.destinationLabel = new Label((Composite)destGroup, 16384);
        this.destinationLabel.setText(Messages.CellExportResourcesPage_9);
        this.destinationLabel.setFont(font);
        this.destinationText = new Text((Composite)destGroup, 2052);
        this.destinationText.addListener(24, (Listener)this);
        GridData dirData = new GridData(1808);
        dirData.widthHint = 525;
        this.destinationText.setLayoutData((Object)dirData);
        this.destinationText.setFont(font);
        this.destinationText.setEnabled(true);
        new Label(parent, 0);
    }

    protected void createOptionsGroupButtons(Group optionsGroup) {
        Font font = optionsGroup.getFont();
        this.createOverwriteExisting(optionsGroup, font);
        this.createDirectoryStructureOptions((Composite)optionsGroup, font);
    }

    protected void createDirectoryStructureOptions(Composite optionsGroup, Font font) {
        this.createDirStructure = new Button(optionsGroup, 16400);
        this.createDirStructure.setText(Messages.CellExportResourcesPage_10);
        this.createDirStructure.setFont(font);
        this.createSelectedDir = new Button(optionsGroup, 16400);
        this.createSelectedDir.setText(Messages.CellExportResourcesPage_11);
        this.createSelectedDir.setFont(font);
    }

    protected void createOverwriteExisting(Group optionsGroup, Font font) {
        this.autoOverwriteCheckbox = new Button((Composite)optionsGroup, 16416);
        this.autoOverwriteCheckbox.setText(Messages.CellExportResourcesPage_12);
        this.autoOverwriteCheckbox.setFont(font);
        this.autoOverwriteCheckbox.setEnabled(true);
    }

    protected void createResourcesGroup(Composite parent) {
        ArrayList<IProject> input = new ArrayList<IProject>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (projects[i].isOpen()) {
                input.add(projects[i]);
            }
            ++i;
        }
        Group filesGroup = new Group(parent, 0);
        filesGroup.setLayout(parent.getLayout());
        filesGroup.setLayoutData(parent.getLayoutData());
        filesGroup.setText(Messages.CellExportResourcesPage_13);
        filesGroup.setFont(parent.getFont());
        this.resourceGroup = new ResourceTreeAndListGroup((Composite)filesGroup, input, this.getResourceProvider(6), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), (IStructuredContentProvider)this.getResourceProvider(1), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), 0, DialogUtil.inRegularFontMode((Composite)parent));
        this.createAdditionalFilesGroup(parent);
    }

    public boolean finish() {
        List whiteResources = this.getWhiteCheckedResources();
        List resourcesToCopy = this.getSelectedResources();
        if (resourcesToCopy.isEmpty()) {
            MessageDialog.openInformation((Shell)this.getContainer().getShell(), (String)Messages.CellExportResourcesPage_14, (String)Messages.CellExportResourcesPage_15);
            return false;
        }
        this.saveDirtyEditors();
        this.saveWidgetValues();
        try {
            ExportJobWrapper copyWrapper = new ExportJobWrapper();
            ProgressMonitorDialog jobMonitor = new ProgressMonitorDialog(this.getContainer().getShell());
            if (this.createDirStructure.getSelection()) {
                copyWrapper.setCreateDirStructure(true);
                copyWrapper.init(this.cellControl, resourcesToCopy, this.getDestinationValue(), this, this.numberOfFiles);
            } else {
                copyWrapper.init(this.cellControl, whiteResources, this.getDestinationValue(), this, this.numberOfFiles);
            }
            copyWrapper.setAutoOverwrite(this.autoOverwriteCheckbox.getSelection());
            jobMonitor.setOpenOnRun(true);
            jobMonitor.run(true, true, (IRunnableWithProgress)copyWrapper);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() == null) {
                MessageDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.CellExportResourcesPage_16, (String)e.getMessage());
                return false;
            }
            Debug.POLICY.logError((Throwable)e);
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)e.getMessage(), (String)e.getTargetException().toString());
            return false;
        }
        catch (InterruptedException interruptedException) {
            MessageDialog.openInformation((Shell)this.getContainer().getShell(), (String)Messages.CellExportResourcesPage_17, (String)Messages.CellExportResourcesPage_18);
            return false;
        }
        MessageDialog.openInformation((Shell)this.getContainer().getShell(), (String)Messages.CellExportResourcesPage_19, (String)Messages.CellExportResourcesPage_20);
        return true;
    }

    protected String getDestinationValue() {
        String ret = this.destinationText.getText().trim();
        if (ret.length() < 2) {
            return ret;
        }
        if (ret.charAt(ret.length() - 1) == File.separatorChar) {
            return ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    private ITreeContentProvider getResourceProvider(final int resourceType) {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof IContainer) {
                    IResource[] members = null;
                    try {
                        members = ((IContainer)o).members();
                    }
                    catch (CoreException coreException) {
                        return new Object[0];
                    }
                    ArrayList<IResource> results = new ArrayList<IResource>();
                    int i = 0;
                    while (i < members.length) {
                        if ((members[i].getType() & resourceType) > 0) {
                            results.add(members[i]);
                        }
                        ++i;
                    }
                    return results.toArray();
                }
                if (o instanceof ArrayList) {
                    return ((ArrayList)o).toArray();
                }
                return new Object[0];
            }
        };
    }

    protected List getSelectedResources() {
        this.numberOfFiles = 0;
        Iterator iterator = this.getSelectedResourcesIterator();
        ArrayList resources = new ArrayList();
        while (iterator.hasNext()) {
            resources.add(iterator.next());
            ++this.numberOfFiles;
        }
        TableItem[] items = this.additionalItemsTable.getItems();
        int i = 0;
        while (i < items.length) {
            File file = new File(items[i].getText(0));
            resources.add(file);
            if (file.isDirectory()) {
                this.tallyDirectory(file);
            } else {
                ++this.numberOfFiles;
            }
            ++i;
        }
        return resources;
    }

    private void tallyDirectory(File file) {
        File[] files = file.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                this.tallyDirectory(files[i]);
            } else {
                ++this.numberOfFiles;
            }
            ++i;
        }
    }

    protected Iterator getSelectedResourcesIterator() {
        return this.resourceGroup.getAllCheckedListItems().iterator();
    }

    protected List getWhiteCheckedResources() {
        List resources = this.resourceGroup.getAllWhiteCheckedItems();
        TableItem[] items = this.additionalItemsTable.getItems();
        int i = 0;
        while (i < items.length) {
            resources.add(new File(items[i].getText(0)));
            ++i;
        }
        return resources;
    }

    public void handleEvent(Event e) {
        try {
            Widget source = e.widget;
            if (source == this.selectAdditionalFileButton) {
                this.handleAddFilePressed();
            } else if (source == this.selectAdditionalDirButton) {
                this.handleAddDirPressed();
            } else if (source == this.removeSelectedButton) {
                this.handleRemoveSelectedPressed();
            }
            this.updatePageCompletion();
        }
        catch (Exception ee) {
            Debug.POLICY.logError((Throwable)ee);
        }
    }

    private void handleRemoveSelectedPressed() {
        int[] selected = this.additionalItemsTable.getSelectionIndices();
        this.additionalItemsTable.deselectAll();
        this.additionalItemsTable.remove(selected);
    }

    private void handleAddDirPressed() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 8192);
        dialog.setMessage(Messages.CellExportResourcesPage_21);
        dialog.setFilterPath("");
        String selectedDirName = dialog.open().trim();
        if (selectedDirName != null) {
            File file = new File(selectedDirName);
            if (!file.exists()) {
                this.setErrorMessage(Messages.CellExportResourcesPage_22);
                return;
            }
            if (!this.doesAdditionalItemsContain(selectedDirName)) {
                TableItem item = new TableItem(this.additionalItemsTable, 16384);
                item.setText(0, selectedDirName);
                item.setText(1, "Directory");
            }
        }
    }

    private void handleAddFilePressed() {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setText(Messages.CellExportResourcesPage_23);
        dialog.setFilterPath("");
        String selectedFileName = dialog.open().trim();
        if (selectedFileName != null) {
            File file = new File(selectedFileName);
            if (!file.exists()) {
                this.setErrorMessage(Messages.CellExportResourcesPage_24);
                return;
            }
            if (!this.doesAdditionalItemsContain(selectedFileName)) {
                TableItem item = new TableItem(this.additionalItemsTable, 0);
                item.setText(0, selectedFileName);
                item.setText(1, "File");
            }
        }
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = DeployPlugin.getDefault().getDialogSettings();
        this.autoOverwriteCheckbox.setSelection(settings.getBoolean(DeployPlugin.SETTING_EXPORT_OVERWRITE));
        this.createDirStructure.setSelection(settings.getBoolean(DeployPlugin.SETTING_EXPORT_CREATE_DIR_STRUCTURE));
        this.createSelectedDir.setSelection(settings.getBoolean(DeployPlugin.SETTING_EXPORT_CREATE_SELECTED_DIR));
        this.destinationText.setText(settings.get(DeployPlugin.SETTING_EXPORT_DESTINATION));
    }

    protected boolean saveDirtyEditors() {
        return PlatformUI.getWorkbench().saveAllEditors(true);
    }

    protected void saveWidgetValues() {
        IDialogSettings settings = DeployPlugin.getDefault().getDialogSettings();
        settings.put(DeployPlugin.SETTING_EXPORT_OVERWRITE, this.autoOverwriteCheckbox.getSelection());
        settings.put(DeployPlugin.SETTING_EXPORT_CREATE_DIR_STRUCTURE, this.createDirStructure.getSelection());
        settings.put(DeployPlugin.SETTING_EXPORT_CREATE_SELECTED_DIR, this.createSelectedDir.getSelection());
        settings.put(DeployPlugin.SETTING_EXPORT_DESTINATION, this.getDestinationValue());
    }

    protected boolean validateDestinationGroup() {
        String destinationValue = this.getDestinationValue();
        if (destinationValue.length() == 0) {
            this.setMessage(Messages.CellExportResourcesPage_25);
            return false;
        }
        this.setMessage(null);
        this.setErrorMessage(null);
        return true;
    }

    protected boolean validateSourceGroup() {
        return true;
    }

    private boolean doesAdditionalItemsContain(String item) {
        if (item == null || item.length() == 0) {
            return true;
        }
        TableItem[] items = this.additionalItemsTable.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getText(0) != null && items[i].getText(0).equals(item)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

