/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.managedbuilder.core;

import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ptp.cell.managedbuilder.core.CellDefaultOptionValueHandler;
import org.eclipse.ptp.cell.managedbuilder.core.PDTBuildProperties;
import org.eclipse.ptp.cell.managedbuilder.debug.Debug;

public class PDTAffectedOptionValueHandler
extends CellDefaultOptionValueHandler {
    protected final String PPU = "ppu";
    protected final String SPU = "spu";
    protected static final String PPC32 = "32";
    protected static final String PPC64 = "64";
    protected final String COMMA = ",";

    protected boolean arePDTPPULinkerBuildOptionsEnabled(IHoldsOptions holder, IOption emitRelocs) {
        try {
            return emitRelocs.getBooleanValue();
        }
        catch (BuildException be) {
            Debug.POLICY.error(Debug.DEBUG_HANDLER, (Throwable)be);
            Debug.POLICY.logError((Throwable)be);
            return false;
        }
    }

    protected boolean arePDTSPULinkerBuildOptionsEnabled(IHoldsOptions holder, IOption emitRelocs, IOption lib) {
        try {
            if (emitRelocs.getBooleanValue() && this.isValueInStringList(lib.getBasicStringListValue(), PDTBuildProperties.SPU_PDT_LIBRARY)) {
                return true;
            }
        }
        catch (BuildException be) {
            Debug.POLICY.error(Debug.DEBUG_HANDLER, (Throwable)be);
            Debug.POLICY.logError((Throwable)be);
        }
        return false;
    }

    protected boolean arePDTCompilerBuildOptionsEnabled(IHoldsOptions holder, IOption symbolDefinition, IOption includePath) {
        block4: {
            String holderId = holder.getId();
            if (!holderId.contains("spu")) break block4;
            if (this.areValuesInStringList(symbolDefinition.getBasicStringListValue(), PDTBuildProperties.MFCIO_TRACE_SYMBOL, PDTBuildProperties.PDT_EXIT_SYMBOL, PDTBuildProperties.PDT_MAIN_SYMBOL) && this.isValueInStringList(includePath.getBasicStringListValue(), PDTBuildProperties.SPU_PDT_INCLUDE_PATH)) {
                return true;
            }
        }
        try {
            Assert.isTrue((boolean)false, (String)"Invalid option");
        }
        catch (BuildException be) {
            Debug.POLICY.error(Debug.DEBUG_HANDLER, (Throwable)be);
            Debug.POLICY.logError((Throwable)be);
        }
        return false;
    }
}

