/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.preferences.core;

import java.io.File;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.cell.preferences.core.CellProperties;
import org.eclipse.ptp.cell.preferences.core.SearcherMessages;
import org.eclipse.ptp.cell.preferences.core.StringFieldEditorPreferenceSearcher;
import org.eclipse.ptp.cell.preferences.debug.Debug;
import org.eclipse.ptp.cell.utils.linux.findutils.Find;
import org.eclipse.ptp.cell.utils.linux.which.Which;
import org.eclipse.ptp.cell.utils.searcher.SearchFailedException;
import org.eclipse.swt.widgets.Composite;

public class SysrootSearcher
extends StringFieldEditorPreferenceSearcher {
    private String[] requiredFiles = CellProperties.sysroot.split(CellProperties.separator);

    public SysrootSearcher(StringFieldEditor stringFieldEditor, Composite parent) {
        super(stringFieldEditor, parent);
    }

    protected void fastSearch() throws SearchFailedException {
        String sysrootPath;
        String currentPreferenceValue = this.stringFieldEditor.getStringValue();
        if (this.isValidSysrootDirectory(currentPreferenceValue)) {
            Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "Current value is valid");
            return;
        }
        String defaultPreferenceValue = this.preferenceStore.getDefaultString(this.preferenceName);
        if (!currentPreferenceValue.equals(defaultPreferenceValue) && this.isValidSysrootDirectory(defaultPreferenceValue)) {
            Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "Default value is valid");
            this.setText(defaultPreferenceValue);
            return;
        }
        if (Platform.getOS().equals("linux") && this.isValidSysrootDirectory(sysrootPath = new Path(Which.which((String)CellProperties.mainLib)).removeLastSegments(1).toOSString())) {
            Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "Value returned from 'which' is valid");
            this.setText(sysrootPath);
            return;
        }
        Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "All fast searches failed,");
        throw new SearchFailedException(SearcherMessages.fastSearchFailedMessage);
    }

    protected void longSearch() {
        new Thread(){

            /*
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "Start long searcher for Sysroot. Start 'find'.");
                    if (!Platform.getOS().equals("linux")) ** GOTO lbl15
                    systemsim_cellPath = new Path(Find.findFile((String)CellProperties.searchRootDirectory, (String)CellProperties.mainLib)).removeLastSegments(1).toOSString();
                    Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "'find' finished.");
                    if (SysrootSearcher.this.isValidSysrootDirectory(systemsim_cellPath)) {
                        SysrootSearcher.this.setText(systemsim_cellPath);
                        Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "Long searcher successfull.");
                        SysrootSearcher.this.showInfoMessage(SearcherMessages.searchSucceededDialogTitle, NLS.bind((String)SearcherMessages.searchSucceededDialogMessage, (Object)CellProperties.sysrootLabel));
                        return;
                    }
                    Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "Long searcher found nothing.");
                    SysrootSearcher.this.showInfoMessage(SearcherMessages.searchFailedDialogTitle, NLS.bind((String)SearcherMessages.searchFailedDialogMessage, (Object)CellProperties.sysrootLabel));
                    return;
lbl15:
                    // 1 sources

                    Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "Not a Linux platform, no long search is available.");
                    return;
                }
                catch (Exception e) {
                    Debug.POLICY.error(Debug.DEBUG_SEARCHER, (Throwable)e);
                    Debug.POLICY.logError((Throwable)e);
                    return;
                }
                finally {
                    Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "Finished long searcher for GNU tools.");
                }
            }
        }.start();
    }

    protected boolean isValidSysrootDirectory(String directoryPath) {
        File sysrootDirectory;
        if (directoryPath != null && (sysrootDirectory = new File(directoryPath)).exists() && sysrootDirectory.isDirectory()) {
            int i = 0;
            while (i < this.requiredFiles.length) {
                File requiredFile = new File(sysrootDirectory, String.valueOf(CellProperties.sysrootSubdir) + this.requiredFiles[i]);
                if (!requiredFile.exists() || !requiredFile.isFile()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Deprecated
    public static void main(String[] args) {
        SysrootSearcher ss = new SysrootSearcher(null, null);
        System.out.println(ss.isValidSysrootDirectory("/opt/cell/"));
    }
}

