/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.simulator.internal;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.cell.simulator.conf.AttributeNames;
import org.eclipse.ptp.cell.simulator.conf.Parameters;
import org.eclipse.ptp.cell.simulator.core.ISimulatorControl;
import org.eclipse.ptp.cell.simulator.core.ISimulatorListener;
import org.eclipse.ptp.cell.simulator.core.ISimulatorParameters;
import org.eclipse.ptp.cell.simulator.core.ISimulatorStatus;
import org.eclipse.ptp.cell.simulator.core.IllegalConfigurationException;
import org.eclipse.ptp.cell.simulator.core.IllegalParameterException;
import org.eclipse.ptp.cell.simulator.core.MissingParameterException;
import org.eclipse.ptp.cell.simulator.core.SimulatorException;
import org.eclipse.ptp.cell.simulator.core.SimulatorKilledException;
import org.eclipse.ptp.cell.simulator.core.SimulatorOperationException;
import org.eclipse.ptp.cell.simulator.core.SimulatorTerminatedException;
import org.eclipse.ptp.cell.simulator.internal.CommandRequest;
import org.eclipse.ptp.cell.simulator.internal.ConsoleListener;
import org.eclipse.ptp.cell.simulator.internal.LinuxTerminalProvider;
import org.eclipse.ptp.cell.simulator.internal.Messages;
import org.eclipse.ptp.cell.simulator.internal.ProcessTerminalProvider;
import org.eclipse.ptp.cell.simulator.internal.Semaphore;
import org.eclipse.ptp.cell.simulator.internal.SimulatorStatus;
import org.eclipse.ptp.cell.simulator.internal.StderrListener;
import org.eclipse.ptp.cell.simulator.internal.StdoutListener;
import org.eclipse.ptp.cell.simulator.internal.TSimDispatcher;
import org.eclipse.ptp.cell.simulator.internal.TSimSocket;
import org.eclipse.ptp.cell.utils.stream.ILineStreamListener;
import org.eclipse.ptp.cell.utils.stream.IStreamListener;
import org.eclipse.ptp.cell.utils.stream.StreamObserver;
import org.eclipse.ptp.cell.utils.stream.TextStreamObserver;
import org.eclipse.ptp.cell.utils.terminal.AbstractTerminalProvider;
import org.eclipse.ptp.cell.utils.terminal.ITerminalProvider;
import org.eclipse.ptp.cell.utils.terminal.TerminalProviderWriter;
import org.eclipse.ptp.cell.utils.vt100.VT100Decoder;
import org.eclipse.ptp.cell.utils.vt100.VT100Listener;

public class SimulatorControl
implements VT100Listener,
ISimulatorControl {
    static final int UNKNOWN = 0;
    static final int NOT_STARTED = 1;
    static final int DEPLOYING = 6;
    static final int LAUNCHING = 2;
    static final int OPERATIONAL = 3;
    static final int SHUTTING_DOWN = 4;
    static final int KILLING = 5;
    int processState = 1;
    static final int STOPPED = 1;
    static final int STARTED = 2;
    int simulatorState = 0;
    static final int SIMULATOR_START = 1;
    static final int SIMULATOR_STOP = 2;
    static final int INIT_PARSE = 100;
    static final int INIT_CHECK = 101;
    static final int INIT_CONFIGURE = 103;
    static final int INIT_BOGUSNET = 104;
    static final int INIT_CONSOLE = 105;
    static final int INIT_CONFIGURED = 107;
    static final int BOOT_BIOS = 110;
    static final int BOOT_LINUX = 111;
    static final int BOOT_SYSTEM = 112;
    static final int BOOT_CONFIGURE = 113;
    static final int BOOT_COMPLETE = 114;
    static final int SHUTDOWN_PREPARED = 200;
    static final int SHUTDOWN_START = 201;
    static final int SHUTDOWN_COMPLETE = 202;
    static final int TCL_STREAM_CLOSED = 301;
    static final int LINUX_STREAM_CLOSED = 302;
    static final int TCL_ERROR_CLOSED = 303;
    Process simulatorProcess = null;
    ISimulatorStatus status = new SimulatorStatus(this);
    SimulatorException pendingSimulatorException = null;
    String[] launchEnvironment = null;
    ISimulatorParameters launchConfiguration = null;
    Semaphore semaphoreReadyToConnect = new Semaphore();
    Semaphore semaphoreLaunchComplete = new Semaphore();
    Semaphore semaphoreShutdownComplete = new Semaphore();
    Semaphore semaphoreKillComplete = new Semaphore();
    Semaphore semaphoreWaitConnection = new Semaphore();
    TextStreamObserver stdoutObserver = null;
    TextStreamObserver stderrObserver = null;
    ProcessTerminalProvider processTerminal = new ProcessTerminalProvider(this);
    TerminalProviderWriter processTerminalWriter = new TerminalProviderWriter((AbstractTerminalProvider)this.processTerminal);
    OutputStream processOutputStream;
    Socket terminalSocket = null;
    StreamObserver terminalObserver = null;
    LinuxTerminalProvider linuxTerminal = new LinuxTerminalProvider(this);
    TerminalProviderWriter linuxTerminalWriter = new TerminalProviderWriter((AbstractTerminalProvider)this.linuxTerminal);
    VT100Decoder vt100Decoder = null;
    TSimDispatcher tsimDispatcher = null;
    List listeners = new ArrayList();
    private boolean printDebug;

    public SimulatorControl() {
        this.printDebug = false;
    }

    public SimulatorControl(boolean printDebug) {
        this.printDebug = printDebug;
    }

    public ITerminalProvider getProcessTerminal() {
        return this.processTerminal;
    }

    public ITerminalProvider getLinuxTerminal() {
        return this.linuxTerminal;
    }

    public ISimulatorStatus getStatus() {
        return this.status;
    }

    public ISimulatorParameters getParameters() {
        return this.launchConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ISimulatorListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ISimulatorListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch(ISimulatorParameters initconfig) throws SimulatorException {
        SimulatorControl simulatorControl = this;
        synchronized (simulatorControl) {
            if (this.processState != 1) {
                throw new SimulatorException(Messages.SimulatorControl_SimulatorAlreadyStarted);
            }
            try {
                this.launchConfiguration = (ISimulatorParameters)initconfig.clone();
                SimulatorControl.validateConfiguration(this.launchConfiguration);
                this.launchConfiguration.verify();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
            this.prepareControl();
        }
        try {
            this.deploySimulatorConfiguration();
            this.launchSimulator();
            if (this.launchConfiguration.doConsoleSocketInit()) {
                this.semaphoreReadyToConnect.waitToOpen();
                this.connectLinuxConsole();
            }
            if (this.launchConfiguration.doJavaApiSocketInit()) {
                this.connectJavaAPIConsole();
            }
            this.semaphoreLaunchComplete.waitToOpen();
            this.notifyLifecycleState(11);
        }
        catch (SimulatorException e) {
            this.cleanupControl();
            throw e;
        }
        catch (Exception e) {
            this.cleanupControl();
            throw new RuntimeException(Messages.SimulatorControl_UnexpectedError, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws SimulatorException {
        SimulatorControl simulatorControl = this;
        synchronized (simulatorControl) {
            if (this.processState != 3) {
                this.cleanupControl();
                return;
            }
            if (!this.launchConfiguration.doConsoleSocketInit()) {
                this.cleanupControl();
                return;
            }
        }
        try {
            this.throwPendingError();
            this.resume();
            this.throwPendingError();
            this.linuxTerminalWriter.writeBoth(String.valueOf(Parameters.COMMAND_SHUTDOWN) + '\n');
            this.semaphoreShutdownComplete.waitToOpen();
            this.throwPendingError();
            this.semaphoreKillComplete.waitToOpen();
        }
        catch (SimulatorException e) {
            this.cleanupControl();
            throw e;
        }
    }

    public synchronized void pause() throws SimulatorException {
        this.throwPendingError();
        if (this.processState != 3) {
            throw new SimulatorException(Messages.SimulatorControl_SimulatorNotOperatioal);
        }
        if (this.simulatorState == 1) {
            return;
        }
        if (this.launchConfiguration.doJavaApiSocketInit()) {
            this.tsimDispatcher.getQueue().addRequest(CommandRequest.stopCommand());
        } else {
            this.launchConfiguration.getDelegate().stopSimulatorProcess(this.simulatorProcess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        SimulatorControl simulatorControl = this;
        synchronized (simulatorControl) {
            if (this.processState == 1) {
                return;
            }
            this.pendingSimulatorException = new SimulatorKilledException();
            this.cleanupControl();
        }
    }

    public synchronized void resume() throws SimulatorException {
        this.throwPendingError();
        if (this.processState != 3) {
            throw new SimulatorException(Messages.SimulatorControl_SimulatorNotOperatioal);
        }
        if (this.simulatorState == 2) {
            return;
        }
        this.processTerminalWriter.writeBoth("mysim go\n");
    }

    private synchronized void throwPendingError() throws SimulatorException {
        if (this.pendingSimulatorException != null) {
            throw this.pendingSimulatorException;
        }
    }

    private synchronized void prepareControl() throws SimulatorException {
        this.simulatorState = 0;
        this.pendingSimulatorException = null;
        this.launchEnvironment = null;
        this.semaphoreLaunchComplete.reset();
        this.semaphoreReadyToConnect.reset();
        this.semaphoreShutdownComplete.reset();
        this.semaphoreKillComplete.reset();
        this.semaphoreWaitConnection.reset();
        this.vt100Decoder = new VT100Decoder((VT100Listener)this);
        this.launchEnvironment = this.launchConfiguration.getDelegate().createCellSimEnvironment();
        if (this.printDebug) {
            System.out.println("Simulator environment:");
            int i = 0;
            while (i < this.launchEnvironment.length) {
                String item = this.launchEnvironment[i];
                if (item.startsWith("CELL_")) {
                    System.out.print("export ");
                    System.out.println(this.launchEnvironment[i]);
                }
                ++i;
            }
        }
    }

    public static void validateConfiguration(ISimulatorParameters launchConfiguration) throws IllegalConfigurationException {
        ISimulatorParameters c = launchConfiguration;
        if (c.getDelegate() == null) {
            throw new MissingParameterException(AttributeNames.LAUNCH_DELEGATE);
        }
        if (c.getWorkDirectory() == null) {
            throw new MissingParameterException(AttributeNames.WORK_DIRECTORY);
        }
        if (c.getSimulatorBaseDirectory() == null) {
            throw new IllegalConfigurationException(AttributeNames.SIMULATOR_BASE_DIRECTORY);
        }
        if (c.getSimulatorExecutable() == null) {
            throw new IllegalConfigurationException(AttributeNames.SIMULATOR_EXECUTABLE);
        }
        if (c.getSnifExecutable() == null) {
            throw new IllegalConfigurationException(AttributeNames.SNIF_EXECUTABLE);
        }
        if (c.getLogDirectory() == null) {
            throw new IllegalConfigurationException(AttributeNames.LOG_PATH);
        }
        if (c.getTapDevicePath() == null) {
            throw new IllegalConfigurationException(AttributeNames.TAP_PATH);
        }
        if (c.getTclScriptName() == null) {
            throw new IllegalConfigurationException(AttributeNames.TCL_SCRIPT_NAME);
        }
        if (c.getTclScriptName().length() == 0) {
            throw new IllegalConfigurationException(AttributeNames.TCL_SCRIPT_NAME);
        }
        if (c.getTclScriptSource() == null) {
            throw new IllegalConfigurationException(AttributeNames.TCL_SOURCE_NAME);
        }
        String[] deployFileNames = c.getDeployFileNames();
        URL[] deployFileSources = c.getDeployFileSources();
        if (deployFileNames != null && deployFileSources != null) {
            if (deployFileNames.length != deployFileSources.length) {
                throw new IllegalConfigurationException(NLS.bind((String)Messages.SimulatorControl_SameSizeArray, (Object[])new String[]{AttributeNames.DEPLOY_FILE_NAMES, AttributeNames.DEPLOY_FILE_SOURCES}));
            }
            int i = 0;
            while (i < deployFileNames.length) {
                if (deployFileNames[i] == null) {
                    throw new MissingParameterException(NLS.bind((String)Messages.SimulatorControl_EmptyArrayElement, (Object[])new String[]{AttributeNames.DEPLOY_FILE_NAMES, Integer.toString(i)}));
                }
                if (deployFileNames[i].length() == 0) {
                    throw new MissingParameterException(NLS.bind((String)Messages.SimulatorControl_EmptyArrayElement, (Object[])new String[]{AttributeNames.DEPLOY_FILE_NAMES, Integer.toString(i)}));
                }
                if (deployFileSources[i] == null) {
                    throw new MissingParameterException(NLS.bind((String)Messages.SimulatorControl_EmptyArrayElement, (Object[])new String[]{AttributeNames.DEPLOY_FILE_SOURCES, Integer.toString(i)}));
                }
                ++i;
            }
        }
        if (c.getMemorySize() < Parameters.getMinMemorySize()) {
            throw new IllegalParameterException(NLS.bind((String)Messages.ConfigurationControl_MemorySize, (Object)Parameters.MIN_MEMORY_SIZE), AttributeNames.MEMORY_SIZE, c.getMemorySize());
        }
        if (c.doJavaApiSocketInit()) {
            if (!Parameters.doUseJavaAPI()) {
                throw new IllegalParameterException(Messages.SimulatorControl_JavaAPINotAllowed, AttributeNames.JAVA_API_INIT, Boolean.TRUE.toString());
            }
            if (Parameters.doHandleJavaApiGuiIssue() && c.doShowSimulatorGUI()) {
                throw new IllegalParameterException(Messages.SimulatorControl_CannotShowSimulatorGUI, AttributeNames.SHOW_SIMULATOR_GUI, Boolean.TRUE.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void deploySimulatorConfiguration() throws SimulatorException {
        try {
            var1_1 = this;
            synchronized (var1_1) {
                this.processState = 6;
            }
            this.throwPendingError();
            this.notifyLifecycleState(14);
            workDirectoryPath = null;
            logPath = null;
            delegate = null;
            var4_6 = this;
            synchronized (var4_6) {
                delegate = this.launchConfiguration.getDelegate();
                workDirectoryPath = this.launchConfiguration.getWorkDirectory();
                logPath = this.launchConfiguration.getLogDirectory();
            }
            this.throwPendingError();
            try {
                delegate.verifyPath(0, logPath);
                throw new SimulatorOperationException(4);
            }
            catch (SimulatorOperationException e) {
                if (e.getReason() != 10002) {
                    if (e.getReason() == 4) {
                        throw e;
                    }
                    throw new SimulatorOperationException(6, (Throwable)e);
                }
                try {
                    delegate.recursiveCreateDirectory(workDirectoryPath);
                }
                catch (Throwable e) {
                    throw new SimulatorOperationException(1, workDirectoryPath, e);
                }
                try {
                    delegate.verifyPath(28, workDirectoryPath);
                }
                catch (SimulatorOperationException e) {
                    if (e.getReason() == 10006) {
                        throw new SimulatorOperationException(3, e.getCause() == null ? e : e.getCause());
                    }
                    throw new SimulatorOperationException(6, (Throwable)e);
                }
                deployPath = null;
                sourceURL = null;
                fileName = null;
                var7_13 = this;
                synchronized (var7_13) {
                    fileName = this.launchConfiguration.getTclScriptName();
                    deployPath = this.launchConfiguration.getWorkDirectoryRelativePath(fileName);
                    sourceURL = this.launchConfiguration.getTclScriptSource();
                }
                inputStream = null;
                try {
                    inputStream = sourceURL.openStream();
                    delegate.writeFile(deployPath, inputStream);
                }
                catch (IOException e) {
                    throw new SimulatorOperationException(2, fileName, e);
                }
                deployFiles = null;
                deploySources = null;
                var10_17 = this;
                synchronized (var10_17) {
                    deployFiles = this.launchConfiguration.getDeployFileNames();
                    deploySources = this.launchConfiguration.getDeployFileSources();
                }
                if (deployFiles == null || deploySources == null) {
                    return;
                }
                i = 0;
                ** while (i < deploySources.length)
            }
lbl-1000:
            // 1 sources

            {
                this.throwPendingError();
                sourceURL = deploySources[i];
                fileName = deployFiles[i];
                var11_19 = this;
                synchronized (var11_19) {
                    deployPath = this.launchConfiguration.getWorkDirectoryRelativePath(fileName);
                }
                this.throwPendingError();
                try {
                    inputStream = sourceURL.openStream();
                    delegate.writeFile(deployPath, inputStream);
                }
                catch (IOException e) {
                    throw new SimulatorOperationException(2, fileName, e);
                }
                ++i;
                continue;
lbl96:
                // 1 sources

            }
        }
        catch (SimulatorException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SimulatorOperationException(6, e);
        }
    }

    private synchronized void launchSimulator() throws SimulatorException {
        this.processState = 2;
        this.notifyLifecycleState(10);
        this.notifyProgress(200);
        String[] commandArray = this.launchConfiguration.getDelegate().createCommandLine();
        if (this.printDebug) {
            System.out.println("Simulator command line: ");
            int i = 0;
            while (i < commandArray.length) {
                String item = commandArray[i];
                System.out.print(String.valueOf(item) + " ");
                ++i;
            }
            System.out.println();
        }
        this.simulatorProcess = this.launchConfiguration.getDelegate().createSimulatorProcess(this.launchConfiguration.getWorkDirectory(), commandArray, this.launchEnvironment);
        InputStream processInputStream = this.simulatorProcess.getInputStream();
        this.processOutputStream = this.simulatorProcess.getOutputStream();
        InputStream processErrorStream = this.simulatorProcess.getErrorStream();
        if (processErrorStream == null || this.processOutputStream == null || processInputStream == null) {
            throw new SimulatorException(Messages.SimulatorControl_SimulatorTerminated);
        }
        if (processInputStream != null) {
            this.stdoutObserver = new TextStreamObserver(processInputStream, (ILineStreamListener)new StdoutListener(this), "stdout");
        }
        if (processErrorStream != null) {
            this.stderrObserver = new TextStreamObserver(processErrorStream, (ILineStreamListener)new StderrListener(this), "stderr");
        }
        if (this.stdoutObserver == null || this.stderrObserver == null) {
            throw new SimulatorException(Messages.SimulatorControl_CouldNotConnectProcess);
        }
        this.stdoutObserver.start();
        this.stderrObserver.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectLinuxConsole() throws SimulatorException {
        int consoleSocketPortMaxTries;
        int consoleSocketPortTryWait;
        SimulatorControl simulatorControl = this;
        synchronized (simulatorControl) {
            consoleSocketPortTryWait = this.launchConfiguration.getConsoleSocketPortTryWait();
            consoleSocketPortMaxTries = this.launchConfiguration.getConsoleSocketPortMaxTries();
        }
        this.throwPendingError();
        try {
            int tries = 0;
            while (this.terminalObserver == null) {
                this.throwPendingError();
                try {
                    SimulatorControl simulatorControl2 = this;
                    synchronized (simulatorControl2) {
                        this.terminalSocket = new Socket(this.launchConfiguration.getConsoleSocketHost(), this.launchConfiguration.getConsoleSocketPort());
                        InputStream terminalInputStream = this.terminalSocket.getInputStream();
                        this.terminalObserver = new StreamObserver(terminalInputStream, (IStreamListener)new ConsoleListener(this), "terminal");
                        this.terminalObserver.start();
                    }
                    this.throwPendingError();
                    break;
                }
                catch (ConnectException connectException) {
                    this.semaphoreWaitConnection.waitToOpen(consoleSocketPortTryWait);
                    if (++tries <= consoleSocketPortMaxTries) continue;
                    throw new SimulatorException(Messages.SimulatorControl_MaxConsoleTries);
                }
            }
        }
        catch (SimulatorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SimulatorException(Messages.SimulatorControl_CouldNotConnectConsole, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void connectJavaAPIConsole() throws SimulatorException {
        int consoleSocketPortMaxTries;
        int consoleSocketPortTryWait;
        if (!Parameters.doUseJavaAPI()) {
            return;
        }
        SimulatorControl simulatorControl = this;
        synchronized (simulatorControl) {
            consoleSocketPortTryWait = this.launchConfiguration.getJavaApiSocketPortTryWait();
            consoleSocketPortMaxTries = this.launchConfiguration.getJavaApiSocketPortMaxTries();
        }
        this.throwPendingError();
        try {
            int tries = 0;
            while (true) {
                this.throwPendingError();
                try {
                    SimulatorControl simulatorControl2 = this;
                    synchronized (simulatorControl2) {
                        TSimSocket socket = new TSimSocket();
                        socket.connect(this.launchConfiguration.getJavaApiSocketHost(), this.launchConfiguration.getJavaApiSocketPort());
                        this.tsimDispatcher = new TSimDispatcher(socket);
                        this.tsimDispatcher.start();
                    }
                    this.throwPendingError();
                }
                catch (ConnectException connectException) {
                    this.semaphoreWaitConnection.waitToOpen(consoleSocketPortTryWait);
                    if (++tries <= consoleSocketPortMaxTries) continue;
                    throw new SimulatorException(Messages.SimulatorControl_MaxJavaAPITries);
                }
                break;
            }
        }
        catch (SimulatorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SimulatorException(Messages.SimulatorControl_CouldNotConnectJavaAPI, e);
        }
    }

    private synchronized void cleanupControl() {
        if (this.processState == 1) {
            return;
        }
        if (this.simulatorProcess != null) {
            try {
                this.simulatorProcess.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                this.launchConfiguration.getDelegate().destroySimulatorProcess(this.simulatorProcess);
            }
            this.simulatorProcess = null;
            this.linuxTerminalWriter.writeMetaMessage(Messages.SimulatorControl_SimulatorNotRunningAnymore);
            this.processTerminalWriter.writeMetaMessage(Messages.SimulatorControl_SimulatorNotRunningAnymore);
            this.removeBogusnet();
            this.removeLogDirectory();
        }
        if (this.tsimDispatcher != null) {
            this.tsimDispatcher.getSocket().disconnect();
            this.tsimDispatcher.interrupt();
            this.tsimDispatcher = null;
        }
        if (this.stderrObserver != null) {
            this.stderrObserver.kill();
            this.stderrObserver = null;
        }
        if (this.stdoutObserver != null) {
            this.stdoutObserver.kill();
            this.stdoutObserver = null;
        }
        if (this.terminalObserver != null) {
            this.terminalObserver.kill();
            this.terminalObserver = null;
        }
        this.vt100Decoder = null;
        if (this.terminalSocket != null) {
            try {
                this.terminalSocket.close();
            }
            catch (IOException iOException) {}
            this.terminalSocket = null;
        }
        this.processState = 1;
        this.simulatorState = 0;
        this.launchEnvironment = null;
        if (this.pendingSimulatorException == null) {
            this.pendingSimulatorException = new SimulatorKilledException();
        }
        this.semaphoreLaunchComplete.open(this.pendingSimulatorException);
        this.semaphoreReadyToConnect.open(this.pendingSimulatorException);
        this.semaphoreShutdownComplete.open(this.pendingSimulatorException);
        this.semaphoreWaitConnection.open(this.pendingSimulatorException);
        this.semaphoreKillComplete.open();
        this.notifyLifecycleState(13);
    }

    private void removeLogDirectory() {
        try {
            this.launchConfiguration.getDelegate().removeFile(this.launchConfiguration.getLogDirectory());
        }
        catch (SimulatorException e) {
            this.launchConfiguration.getDelegate().logError(Messages.SimulatorControl_WorkDirCleanUpError, e);
        }
    }

    private void removeProcess() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.launchConfiguration.getDelegate().readFile(this.launchConfiguration.getPIDPath(), byteArrayOutputStream);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            InputStreamReader reader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(reader);
            String content = bufferedReader.readLine();
            if (content != null) {
                String[] commandArray = new String[]{"kill", "-9", content.trim()};
                Process process = this.launchConfiguration.getDelegate().createGenericProcess(null, commandArray, null);
                process.waitFor();
            }
        }
        catch (SimulatorException e) {
            this.launchConfiguration.getDelegate().logError(Messages.SimulatorControl_BogusnetCleanUpError, e);
        }
        catch (IOException e) {
            this.launchConfiguration.getDelegate().logError(Messages.SimulatorControl_BogusnetCleanUpError, e);
        }
        catch (InterruptedException e) {
            this.launchConfiguration.getDelegate().logError(Messages.SimulatorControl_BogusnetCleanUpError, e);
        }
    }

    private void removeBogusnet() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.launchConfiguration.getDelegate().readFile(this.launchConfiguration.getTapDevicePath(), byteArrayOutputStream);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            InputStreamReader reader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(reader);
            String content = bufferedReader.readLine();
            if (content != null) {
                String[] commandArray = new String[]{this.launchConfiguration.getSnifExecutable(), "-d", content};
                Process process = this.launchConfiguration.getDelegate().createGenericProcess(null, commandArray, null);
                process.waitFor();
            }
        }
        catch (SimulatorException e) {
            this.launchConfiguration.getDelegate().logError(Messages.SimulatorControl_BogusnetCleanUpError, e);
        }
        catch (IOException e) {
            this.launchConfiguration.getDelegate().logError(Messages.SimulatorControl_BogusnetCleanUpError, e);
        }
        catch (InterruptedException e) {
            this.launchConfiguration.getDelegate().logError(Messages.SimulatorControl_BogusnetCleanUpError, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyEvent(int event) {
        int lifecycleChange = 0;
        int statusChange = 0;
        boolean progressChange = false;
        SimulatorControl simulatorControl = this;
        synchronized (simulatorControl) {
            if (this.processState == 1) {
                return;
            }
            if (this.printDebug) {
                System.err.print("Cell Simulator Control detected event: #");
                System.err.println(event);
            }
            switch (event) {
                case 302: {
                    this.terminalObserver = null;
                    this.processState = 5;
                    break;
                }
                case 301: {
                    this.stdoutObserver = null;
                    this.processState = 5;
                    break;
                }
                case 303: {
                    this.stderrObserver = null;
                    this.processState = 5;
                }
            }
            if (this.processState == 5) {
                if (this.stdoutObserver == null && this.stderrObserver == null && this.terminalObserver == null) {
                    if (this.pendingSimulatorException == null) {
                        int exitValue = 0;
                        try {
                            exitValue = this.simulatorProcess.exitValue();
                        }
                        catch (IllegalThreadStateException illegalThreadStateException) {}
                        this.pendingSimulatorException = exitValue != 0 ? new SimulatorTerminatedException(exitValue) : new SimulatorTerminatedException();
                    }
                    this.semaphoreLaunchComplete.open(this.pendingSimulatorException);
                    this.semaphoreReadyToConnect.open(this.pendingSimulatorException);
                    this.semaphoreShutdownComplete.open(this.pendingSimulatorException);
                    this.semaphoreWaitConnection.open(this.pendingSimulatorException);
                    this.cleanupControl();
                }
                if (this.printDebug) {
                    System.err.print("Ignored event due KILLING: #");
                    System.err.println(event);
                }
                return;
            }
            switch (event) {
                case 2: {
                    if (this.simulatorState != 1) {
                        this.linuxTerminalWriter.writeMetaMessage(Messages.SimulatorControl_SimulatorNowPaused);
                        this.processTerminalWriter.writeMetaMessage(Messages.SimulatorControl_SimulatorNowPaused);
                    }
                    this.simulatorState = 1;
                    if (this.processState == 3) {
                        this.notifyStatus(1);
                    }
                    return;
                }
                case 1: {
                    if (this.simulatorState != 2) {
                        this.linuxTerminalWriter.writeMetaMessage(Messages.SimulatorControl_SimulatorNowResumed);
                        this.processTerminalWriter.writeMetaMessage(Messages.SimulatorControl_SimulatorNowResumed);
                    }
                    this.simulatorState = 2;
                    if (this.processState == 3) {
                        this.notifyStatus(2);
                    }
                    return;
                }
            }
            switch (event) {
                case 100: {
                    if (this.processState == 2) {
                        this.notifyProgress(300);
                        break;
                    }
                    this.launchConfiguration.getDelegate().logError(Messages.SimulatorControl_InvalidEvent1);
                    break;
                }
                case 101: {
                    if (this.processState == 2) {
                        this.notifyProgress(301);
                        break;
                    }
                    this.launchConfiguration.getDelegate().logError(Messages.SimulatorControl_InvalidEvent1);
                    break;
                }
                case 103: {
                    if (this.processState == 2) {
                        this.notifyProgress(302);
                        break;
                    }
                    this.launchConfiguration.getDelegate().logError(Messages.SimulatorControl_InvalidEvent2);
                    break;
                }
                case 104: {
                    if (this.processState == 2) {
                        this.notifyProgress(303);
                        break;
                    }
                    this.launchConfiguration.getDelegate().logError(Messages.SimulatorControl_InvalidEvent3);
                    break;
                }
                case 105: {
                    if (this.processState == 2) {
                        this.semaphoreReadyToConnect.open();
                        this.notifyProgress(304);
                        break;
                    }
                    this.launchConfiguration.getDelegate().logError(Messages.SimulatorControl_InvalidEvent4);
                    break;
                }
                case 110: {
                    if (this.processState == 2) {
                        this.notifyProgress(400);
                        break;
                    }
                    this.launchConfiguration.getDelegate().logError(Messages.SimulatorControl_InvalidEvent5);
                    break;
                }
                case 111: {
                    if (this.processState == 2) {
                        this.notifyProgress(401);
                        break;
                    }
                    this.launchConfiguration.getDelegate().logError(Messages.SimulatorControl_InvalidEvent6);
                    break;
                }
                case 112: {
                    if (this.processState == 2) {
                        this.notifyProgress(402);
                        break;
                    }
                    this.launchConfiguration.getDelegate().logError(Messages.SimulatorControl_InvalidEvent7);
                    break;
                }
                case 113: {
                    if (this.processState == 2) {
                        this.notifyProgress(403);
                        break;
                    }
                    this.launchConfiguration.getDelegate().logError(Messages.SimulatorControl_InvalidEvent8);
                    break;
                }
                case 114: {
                    if (this.processState == 2) {
                        this.linuxTerminalWriter.writeMetaMessage(Messages.SimulatorControl_UseThisLinuxConsole);
                        this.processTerminalWriter.writeMetaMessage(Messages.SimulatorControl_UseThisTCLConsole);
                        this.notifyProgress(404);
                        this.processState = 3;
                        this.notifyLifecycleState(11);
                        this.semaphoreReadyToConnect.open();
                        this.semaphoreLaunchComplete.open();
                        break;
                    }
                    this.launchConfiguration.getDelegate().logError(Messages.SimulatorControl_InvalidEvent9);
                    break;
                }
                case 200: {
                    this.processState = 4;
                    this.notifyLifecycleState(12);
                    this.notifyProgress(20);
                    break;
                }
                case 201: {
                    if (this.processState != 4) {
                        this.processState = 4;
                        this.notifyLifecycleState(12);
                    }
                    this.notifyProgress(22);
                    break;
                }
                case 202: {
                    if (this.processState == 4) {
                        this.notifyProgress(23);
                        break;
                    }
                    this.launchConfiguration.getDelegate().logError(Messages.SimulatorControl_InvalidEvent10);
                }
            }
        }
        if (lifecycleChange != 0) {
            this.notifyLifecycleState(lifecycleChange);
        }
        if (statusChange != 0) {
            this.notifyStatus(statusChange);
        }
        if (progressChange) {
            this.notifyProgress(statusChange);
        }
    }

    synchronized void notifyError(SimulatorException e) {
        if (this.printDebug) {
            System.err.println("Cell Simulator Control detected error: ");
            System.err.println(e.getMessage());
        }
        this.launchConfiguration.getDelegate().logError(Messages.SimulatorControl_ErrorNotifiedBySimulator, e);
        this.pendingSimulatorException = e;
        this.semaphoreLaunchComplete.open(this.pendingSimulatorException);
        this.semaphoreReadyToConnect.open(this.pendingSimulatorException);
        this.semaphoreShutdownComplete.open(this.pendingSimulatorException);
        this.simulatorProcess.destroy();
    }

    void notifyError(String message) {
        this.notifyError(new SimulatorException(message));
    }

    void receiveLinuxConsoleBytes(byte[] bytes, int length) {
        this.vt100Decoder.receive(bytes, length);
    }

    public void textSequence(byte[] bytes, int length) {
        this.linuxTerminal.receiveDataFromTerminal(bytes, length);
    }

    void receiveProcessErrorLine(String line) {
        if (this.printDebug) {
            System.err.println(line);
        }
        byte[] bytes = (String.valueOf(line) + "\n").getBytes();
        this.processTerminal.receiveErrorFromTerminal(bytes, bytes.length);
    }

    void receiveProcessLine(String line) {
        if (this.printDebug) {
            System.out.println(line);
        }
        byte[] bytes = (String.valueOf(line) + "\n").getBytes();
        this.processTerminal.receiveDataFromTerminal(bytes, bytes.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyLifecycleState(int state) {
        List list = this.listeners;
        synchronized (list) {
            for (ISimulatorListener listener : this.listeners) {
                listener.lifecycleStateChanged(state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyStatus(int state) {
        List list = this.listeners;
        synchronized (list) {
            for (ISimulatorListener listener : this.listeners) {
                listener.simulationStatus(state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyProgress(int state) {
        List list = this.listeners;
        synchronized (list) {
            for (ISimulatorListener listener : this.listeners) {
                listener.progressChanged(state);
            }
        }
    }

    public void clear() throws SimulatorException {
        this.removeProcess();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {}
        this.removeBogusnet();
        this.removeLogDirectory();
    }
}

