/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.simulator.internal;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.ptp.cell.simulator.internal.ITSimRequest;

class TSimQueue {
    List requestQueue = new LinkedList();
    Set requestSet = new HashSet();

    public synchronized void addRequest(ITSimRequest request) {
        if (this.requestSet.contains(request)) {
            return;
        }
        this.requestQueue.add(request);
        this.requestSet.add(request);
        this.notify();
    }

    public int size() {
        return this.requestQueue.size();
    }

    public boolean isEmpty() {
        return this.requestQueue.isEmpty();
    }

    public synchronized ITSimRequest popRequest() throws InterruptedException {
        while (this.isEmpty()) {
            this.wait();
        }
        ListIterator iterator = this.requestQueue.listIterator();
        ITSimRequest request = (ITSimRequest)iterator.next();
        iterator.remove();
        this.requestSet.remove(request);
        return request;
    }
}

