/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.sputiming.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.cell.sputiming.Activator;
import org.eclipse.ptp.cell.sputiming.core.Messages;
import org.eclipse.ptp.cell.utils.stream.StreamBridge;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;

public class CommonOperations {
    private IPath selectedFile;
    private IProject project;

    public CommonOperations(IProject project, IPath selectedFile) {
        this.selectedFile = selectedFile.makeAbsolute();
        this.project = project;
    }

    public void displayOutputFile(IPath sputiminggenfile, IOConsole console) throws CoreException {
        try {
            FileInputStream generatedfile = new FileInputStream(sputiminggenfile.toOSString());
            StreamBridge filebridge = new StreamBridge((InputStream)generatedfile, (OutputStream)console.newOutputStream());
            filebridge.run();
        }
        catch (FileNotFoundException e) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 0, Messages.CommonOperations_DisplayFile_NoFileFound, (Throwable)e));
        }
    }

    public String getAssemblerExtension() throws CoreException {
        return "spuS";
    }

    public String getBuildDirectoryName() {
        return "sputiming";
    }

    public IPath getWorkingDirectory() {
        String workdir = this.selectedFile.removeLastSegments(1).addTrailingSeparator().append(this.getBuildDirectoryName()).toOSString();
        return new Path(workdir);
    }

    public String getOutputFilenameWithoutExtension() {
        String filename = this.selectedFile.removeFileExtension().lastSegment();
        return filename;
    }

    public IPath getAssemblyFilePath() throws CoreException {
        String outputwoext = this.getOutputFilenameWithoutExtension();
        IPath asmFilePath = this.getWorkingDirectory().addTrailingSeparator().append(String.valueOf(outputwoext) + "." + this.getAssemblerExtension());
        return asmFilePath;
    }

    public void createWorkingDirectory(IProgressMonitor monitor) throws CoreException {
        File workingDir = new File(this.getWorkingDirectory().toOSString());
        workingDir.mkdir();
    }

    public IOConsole createConsole(String consoleName) {
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        IConsole[] consoles = manager.getConsoles();
        int i = 0;
        while (i < consoles.length) {
            IConsole console = consoles[i];
            if (console.getName().equals(consoleName)) {
                manager.removeConsoles(new IConsole[]{console});
            }
            ++i;
        }
        IOConsole spuTimingConsole = new IOConsole(consoleName, null);
        manager.addConsoles(new IConsole[]{spuTimingConsole});
        return spuTimingConsole;
    }
}

