/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core.attributes;

import java.math.BigInteger;
import org.eclipse.ptp.core.attributes.AbstractAttributeDefinition;
import org.eclipse.ptp.core.attributes.BigIntegerAttribute;
import org.eclipse.ptp.core.attributes.IllegalValueException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BigIntegerAttributeDefinition
extends AbstractAttributeDefinition<BigInteger, BigIntegerAttribute, BigIntegerAttributeDefinition> {
    private final BigInteger minValue;
    private final BigInteger maxValue;
    private final BigInteger defaultValue;

    public BigIntegerAttributeDefinition(String uniqueId, String name, String description, boolean display, BigInteger defaultValue) {
        super(uniqueId, name, description, display);
        this.defaultValue = defaultValue;
        this.minValue = BigInteger.ZERO;
        this.maxValue = BigInteger.valueOf(Long.MAX_VALUE);
    }

    public BigIntegerAttributeDefinition(String uniqueId, String name, String description, boolean display, BigInteger defaultValue, BigInteger minValue, BigInteger maxValue) throws IllegalValueException {
        super(uniqueId, name, description, display);
        if (minValue.compareTo(maxValue) > 0) {
            throw new IllegalArgumentException("minValue must be less than or equal to maxValue");
        }
        if (defaultValue.compareTo(minValue) < 0 || defaultValue.compareTo(maxValue) > 0) {
            throw new IllegalValueException("The set valid range does not include the default value");
        }
        this.defaultValue = defaultValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    public BigIntegerAttribute create() throws IllegalValueException {
        return new BigIntegerAttribute(this, this.defaultValue);
    }

    @Override
    public BigIntegerAttribute create(String value) throws IllegalValueException {
        return new BigIntegerAttribute(this, value);
    }

    public BigIntegerAttribute create(BigInteger value) throws IllegalValueException {
        return new BigIntegerAttribute(this, value);
    }

    public BigIntegerAttribute create(Integer value) throws IllegalValueException {
        return new BigIntegerAttribute(this, value);
    }

    public BigInteger getMaxValue() {
        return this.maxValue;
    }

    public BigInteger getMinValue() {
        return this.minValue;
    }
}

