/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.data;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.launch.data.ISynchronizationRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadRule
implements ISynchronizationRule {
    private int overwritePolicy = 0;
    private boolean asReadOnly = false;
    private boolean asExecutable = false;
    private boolean preserveTimeStamp = false;
    private boolean downloadBack = false;
    private boolean defaultRemoteDirectory = false;
    private String remoteDirectory = null;
    private List<String> localFileList = new ArrayList<String>();

    public UploadRule() {
    }

    public UploadRule(String data) {
        String s;
        String[] list = data.split("\n");
        if (list.length < 1) {
            this.throwError("The string is not a valid rule for " + this.getClass().getName());
        }
        if (!(s = list[0]).equalsIgnoreCase("upload")) {
            this.throwError("The string is not a valid rule for " + this.getClass().getName());
        }
        int i = 1;
        while (i < list.length) {
            String s2 = list[i];
            int p = s2.indexOf(32);
            if (p == -1) {
                this.logError("Invalid rule entry: " + s2);
            } else {
                String key = s2.substring(0, p);
                String value = s2.substring(p + 1);
                this.parseEntry(key, value);
            }
            ++i;
        }
    }

    public UploadRule(UploadRule rule) {
        this.overwritePolicy = rule.overwritePolicy;
        this.asReadOnly = rule.asReadOnly;
        this.asExecutable = rule.asExecutable;
        this.preserveTimeStamp = rule.preserveTimeStamp;
        this.downloadBack = rule.downloadBack;
        this.defaultRemoteDirectory = rule.defaultRemoteDirectory;
        this.remoteDirectory = rule.remoteDirectory != null ? new String(rule.remoteDirectory) : null;
        this.localFileList = new ArrayList<String>(rule.localFileList);
    }

    private void throwError(String string) {
        throw new RuntimeException(string);
    }

    private void parseEntry(String key, String value) {
        if (key.equalsIgnoreCase("remote-path")) {
            this.remoteDirectory = value;
        } else if (key.equalsIgnoreCase("overwrite-policy")) {
            if (value.equalsIgnoreCase("always")) {
                this.overwritePolicy = 2;
            } else if (value.equalsIgnoreCase("ask")) {
                this.overwritePolicy = 4;
            } else if (value.equalsIgnoreCase("newer")) {
                this.overwritePolicy = 3;
            } else if (value.equalsIgnoreCase("skip")) {
                this.overwritePolicy = 1;
            } else {
                this.logError("Unknown overwrite policy: " + value);
            }
        } else if (key.equalsIgnoreCase("flags")) {
            String[] flags = value.split(" ");
            int i = 0;
            while (i < flags.length) {
                String flag = flags[i];
                if (flag.equalsIgnoreCase("default-remote-directory")) {
                    this.defaultRemoteDirectory = true;
                } else if (flag.equalsIgnoreCase("timestamp")) {
                    this.preserveTimeStamp = true;
                } else if (flag.equalsIgnoreCase("download-back")) {
                    this.downloadBack = true;
                } else {
                    this.logError("Unknown flag: " + flag);
                }
                ++i;
            }
        } else if (key.equalsIgnoreCase("local-path")) {
            this.localFileList.add(value);
        } else if (key.equalsIgnoreCase("permissions")) {
            String[] flags = value.split(" ");
            int i = 0;
            while (i < flags.length) {
                String flag = flags[i];
                if (flag.equalsIgnoreCase("executable")) {
                    this.asExecutable = true;
                } else if (flag.equalsIgnoreCase("readonly")) {
                    this.asReadOnly = true;
                } else {
                    this.logError("Unknown permission: " + flag);
                }
                ++i;
            }
        } else {
            this.logError("Unknown key: " + key);
        }
    }

    private void logError(String string) {
    }

    public String toString() {
        String s;
        ArrayList<String> l = new ArrayList<String>();
        if (this.remoteDirectory != null) {
            l.add("remote-path " + this.remoteDirectory.trim());
        }
        if (this.overwritePolicy == 2) {
            l.add("overwrite-policy always");
        } else if (this.overwritePolicy == 4) {
            l.add("overwrite-policy ask");
        } else if (this.overwritePolicy == 3) {
            l.add("overwrite-policy newer");
        } else if (this.overwritePolicy == 1) {
            l.add("overwrite-policy skip");
        }
        if (this.asExecutable || this.asReadOnly) {
            s = "permissions";
            if (this.asExecutable) {
                s = String.valueOf(s) + " executable";
            }
            if (this.asReadOnly) {
                s = String.valueOf(s) + " readonly";
            }
            l.add(s);
        }
        if (this.preserveTimeStamp || this.defaultRemoteDirectory || this.downloadBack) {
            s = "flags";
            if (this.defaultRemoteDirectory) {
                s = String.valueOf(s) + " default-remote-directory";
            }
            if (this.preserveTimeStamp) {
                s = String.valueOf(s) + " timestamp";
            }
            if (this.downloadBack) {
                s = String.valueOf(s) + " download-back";
            }
            l.add(s);
        }
        for (String localpath : this.localFileList) {
            if (localpath == null || localpath.trim().length() == 0) continue;
            l.add("local-path " + localpath.trim());
        }
        String result = new String("upload");
        for (String element : l) {
            result = String.valueOf(result) + "\n" + element;
        }
        return result;
    }

    public boolean isAsExecutable() {
        return this.asExecutable;
    }

    public void setAsExecutable(boolean asExecutable) {
        this.asExecutable = asExecutable;
    }

    public boolean isAsReadOnly() {
        return this.asReadOnly;
    }

    public void setAsReadOnly(boolean asReadOnly) {
        this.asReadOnly = asReadOnly;
    }

    public boolean isDefaultRemoteDirectory() {
        return this.defaultRemoteDirectory;
    }

    public void setDefaultRemoteDirectory(boolean defaultRemoteDirectory) {
        this.defaultRemoteDirectory = defaultRemoteDirectory;
    }

    public int getOverwritePolicy() {
        return this.overwritePolicy;
    }

    public void setOverwritePolicy(int overwritePolicy) {
        this.overwritePolicy = overwritePolicy;
    }

    public boolean isPreserveTimeStamp() {
        return this.preserveTimeStamp;
    }

    public void setPreserveTimeStamp(boolean preserveTimeStamp) {
        this.preserveTimeStamp = preserveTimeStamp;
    }

    public String getRemoteDirectory() {
        if (this.remoteDirectory != null) {
            return this.remoteDirectory.trim();
        }
        return null;
    }

    public void setRemoteDirectory(String remoteDirectory) {
        this.remoteDirectory = remoteDirectory != null ? remoteDirectory.trim() : null;
    }

    public void setDownloadBack(boolean downloadBack) {
        this.downloadBack = downloadBack;
    }

    public boolean isDownloadBack() {
        return this.downloadBack;
    }

    public int getRemoteFileCount() {
        return this.localFileList.size();
    }

    public String[] getLocalFilesAsStringArray() {
        String[] result = new String[this.localFileList.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = this.localFileList.get(i);
            ++i;
        }
        return result;
    }

    public IPath[] getLocalFilesAsPathArray() {
        IPath[] result = new IPath[this.localFileList.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = new Path(this.localFileList.get(i));
            ++i;
        }
        return result;
    }

    public File[] getLocalFilesAsFileArray() {
        File[] result = new File[this.localFileList.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = new File(this.localFileList.get(i));
            ++i;
        }
        return result;
    }

    public Iterator<?> localIteratorAsString() {
        return new LocalFileIteratorAsString();
    }

    public Iterator<?> localIteratorAsPath() {
        return new LocalFileIteratorAsPath();
    }

    public Iterator<?> localIteratorAsFile() {
        return new LocalFileIteratorAsFile();
    }

    public void addLocalFile(String string) {
        if (string != null) {
            this.localFileList.add(string);
        }
    }

    public void addLocalFile(IPath path) {
        if (path != null) {
            this.localFileList.add(path.toOSString());
        }
    }

    public void addLocalFile(File file) {
        if (file != null) {
            this.localFileList.add(file.getPath());
        }
    }

    public static void main(String[] args) {
        UploadRule r = new UploadRule();
        System.out.println(r);
        r.setAsExecutable(true);
        System.out.println(r);
        r.setAsReadOnly(true);
        System.out.println(r);
        r.setRemoteDirectory("/tmp/a");
        System.out.println(r);
        r.setOverwritePolicy(4);
        System.out.println(r);
        String s = "upload\nremote-directory /tmp/a\npermissions executable readonly\nflags default-remote-directory";
        r = new UploadRule(s);
        System.out.println(r);
    }

    public void removeLocalFile(String entry) {
        Iterator<String> iter = this.localFileList.iterator();
        while (iter.hasNext()) {
            String element = iter.next();
            if (!element.equals(entry)) continue;
            iter.remove();
        }
    }

    public void removeLocalFile(IPath entry) {
        this.removeLocalFile(entry.toOSString());
    }

    public void removeLocalFile(File entry) {
        this.removeLocalFile(entry.getPath());
    }

    public void setLocalFiles(String[] items) {
        this.clearLocalFiles();
        int i = 0;
        while (i < items.length) {
            String string = items[i];
            if (string != null) {
                this.addLocalFile(string);
            }
            ++i;
        }
    }

    public void setLocalFiles(IPath[] items) {
        this.clearLocalFiles();
        int i = 0;
        while (i < items.length) {
            IPath path = items[i];
            if (path != null) {
                this.addLocalFile(path);
            }
            ++i;
        }
    }

    public void setLocalFiles(File[] items) {
        this.clearLocalFiles();
        int i = 0;
        while (i < items.length) {
            File file = items[i];
            if (file != null) {
                this.addLocalFile(file);
            }
            ++i;
        }
    }

    public void clearLocalFiles() {
        this.localFileList.clear();
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public boolean isDownloadRule() {
        return false;
    }

    @Override
    public boolean isUploadRule() {
        return true;
    }

    @Override
    public String toLabel() {
        String result = "UPLOAD " + Integer.toString(this.localFileList.size()) + " item(s) \nto " + this.remoteDirectory;
        return result;
    }

    @Override
    public void validate() throws CoreException {
        if (!this.defaultRemoteDirectory) {
            // empty if block
        }
    }

    public class LocalFileIteratorAsFile
    extends LocalFileIteratorAsString {
        public Object next() {
            return new File((String)this.iteratorref.next());
        }
    }

    public class LocalFileIteratorAsPath
    extends LocalFileIteratorAsString {
        public Object next() {
            return new Path((String)this.iteratorref.next());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LocalFileIteratorAsString
    implements Iterator<Object> {
        Iterator<String> iteratorref;

        public LocalFileIteratorAsString() {
            this.iteratorref = UploadRule.this.localFileList.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iteratorref.hasNext();
        }

        @Override
        public Object next() {
            return this.iteratorref.next();
        }

        @Override
        public void remove() {
            this.iteratorref.remove();
        }
    }
}

