/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.mpi.analysis.view;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.pldt.common.Artifact;
import org.eclipse.ptp.pldt.common.ScanReturn;
import org.eclipse.ptp.pldt.common.util.SourceInfo;
import org.eclipse.ptp.pldt.common.util.ViewActivater;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.BarrierTable;
import org.eclipse.ptp.pldt.mpi.analysis.view.ArtifactWithParent;
import org.eclipse.ptp.pldt.mpi.analysis.view.MPIArtifactMarkingVisitor;

public class MatchingSet {
    protected BarrierTable btable_ = null;

    public MatchingSet(BarrierTable table) {
        this.btable_ = table;
    }

    public void run() {
        IWorkspaceRoot wsResource = ResourcesPlugin.getWorkspace().getRoot();
        try {
            int depth = 2;
            wsResource.deleteMarkers("org.eclipse.ptp.pldt.mpi.analysis.mpiBarrierMatchingSetMarker", false, depth);
        }
        catch (CoreException e) {
            System.out.println("RM: exception deleting markers.");
            e.printStackTrace();
        }
        MPIArtifactMarkingVisitor visitor = new MPIArtifactMarkingVisitor("org.eclipse.ptp.pldt.mpi.analysis.mpiBarrierMatchingSetMarker");
        int count = 0;
        Enumeration<List<BarrierTable.BarrierInfo>> e = this.btable_.getTable().elements();
        while (e.hasMoreElements()) {
            ArrayList barrierList = (ArrayList)e.nextElement();
            for (BarrierTable.BarrierInfo barrier : barrierList) {
                int parentID = ++count;
                String name = "Barrier " + (barrier.getID() - 4) + " (" + barrier.getMatchingSet().size() + ")";
                ScanReturn sr = new ScanReturn();
                SourceInfo sourceInfo = barrier.getSourceInfo();
                String filename = barrier.getFileName();
                int line = sourceInfo.getStartingLine();
                String fn = barrier.getEnclosingFunc();
                ArtifactWithParent a = new ArtifactWithParent(filename, line, 1, fn, "Artifact Call", sourceInfo, 0, parentID, name, barrier.getID() - 4);
                sr.addArtifact((Artifact)a);
                visitor.visitFile(barrier.getResource(), sr.getArtifactList());
                for (BarrierTable.BarrierInfo matchedBar : barrier.getMatchingSet()) {
                    int myID = ++count;
                    name = "Barrier " + (matchedBar.getID() - 4);
                    sr = new ScanReturn();
                    sourceInfo = matchedBar.getSourceInfo();
                    filename = matchedBar.getFileName();
                    line = sourceInfo.getStartingLine();
                    fn = matchedBar.getEnclosingFunc();
                    a = new ArtifactWithParent(filename, line, 1, fn, "Artifact Call", sourceInfo, parentID, myID, name, matchedBar.getID() - 4);
                    sr.addArtifact((Artifact)a);
                    visitor.visitFile(matchedBar.getResource(), sr.getArtifactList());
                }
            }
        }
        ViewActivater.activateView((String)"org.eclipse.ptp.pldt.mpi.analysis.view.MPIBarrierMatchingSetTableView");
    }
}

