/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.internal.ssh;

import java.io.ByteArrayOutputStream;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionTools;
import org.eclipse.ptp.remotetools.core.IRemoteScript;
import org.eclipse.ptp.remotetools.core.IRemoteScriptExecution;
import org.eclipse.ptp.remotetools.core.RemoteProcess;
import org.eclipse.ptp.remotetools.exception.CancelException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.exception.RemoteExecutionException;
import org.eclipse.ptp.remotetools.internal.common.RemoteScript;
import org.eclipse.ptp.remotetools.internal.ssh.ExecutionManager;
import org.eclipse.ptp.remotetools.internal.ssh.Messages;
import org.eclipse.ptp.remotetools.internal.ssh.SSHRemoteProcess;
import org.eclipse.ptp.remotetools.internal.ssh.ScriptExecution;

public class ExecutionTools
implements IRemoteExecutionTools {
    ExecutionManager manager;

    protected ExecutionTools(ExecutionManager manager) {
        this.manager = manager;
    }

    public IRemoteScript createScript() {
        return new RemoteScript();
    }

    public IRemoteScriptExecution executeScript(IRemoteScript remoteScript) throws RemoteConnectionException {
        if (!(remoteScript instanceof RemoteScript)) {
            throw new IllegalArgumentException();
        }
        ScriptExecution actualExecution = new ScriptExecution(this.manager, (RemoteScript)remoteScript);
        actualExecution.startExecution();
        return actualExecution;
    }

    public int executeWithExitValue(String command) throws RemoteExecutionException, RemoteConnectionException, CancelException {
        IRemoteScript script = this.createScript();
        script.setScript(command);
        IRemoteScriptExecution execution = this.executeScript(script);
        execution.waitForEndOfExecution();
        int returncode = execution.getReturnCode();
        execution.close();
        return returncode;
    }

    public String executeWithOutput(String command) throws RemoteExecutionException, RemoteConnectionException, CancelException {
        IRemoteScript script = this.createScript();
        script.setScript(command);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        script.setProcessOutputStream(baos);
        IRemoteScriptExecution execution = this.executeScript(script);
        execution.waitForEndOfExecution();
        execution.close();
        return baos.toString();
    }

    public void executeBashCommand(String command) throws RemoteExecutionException, CancelException, RemoteConnectionException {
        IRemoteScript script = this.createScript();
        script.setScript(command);
        ByteArrayOutputStream baos1 = new ByteArrayOutputStream();
        script.setProcessOutputStream(baos1);
        ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
        script.setProcessErrorStream(baos2);
        IRemoteScriptExecution execution = this.executeScript(script);
        execution.waitForEndOfExecution();
        int returncode = execution.getReturnCode();
        execution.close();
        if (returncode != 0) {
            throw new RemoteExecutionException(Messages.ExecutionTools_ExecuteBashCommand_FailedRunBashCommand, returncode, baos1.toString(), baos2.toString());
        }
    }

    public RemoteProcess executeProcess(IRemoteScript remoteScript) throws RemoteExecutionException, CancelException, RemoteConnectionException {
        remoteScript.setFetchProcessErrorStream(true);
        remoteScript.setFetchProcessInputStream(true);
        remoteScript.setFetchProcessOutputStream(true);
        IRemoteScriptExecution execution = this.executeScript(remoteScript);
        SSHRemoteProcess process = new SSHRemoteProcess(execution);
        return process;
    }
}

