/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.ui.utils;

import org.eclipse.ptp.rm.ui.utils.DebugUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;

public abstract class WidgetListener
implements SelectionListener,
ModifyListener {
    private boolean listenerEnabled = true;

    public synchronized void enable() {
        this.listenerEnabled = true;
    }

    public synchronized void disable() {
        this.listenerEnabled = false;
    }

    public synchronized boolean isEnabled() {
        return this.listenerEnabled;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (this.isEnabled()) {
            DebugUtil.trace(DebugUtil.DATASOURCE_TRACING, "Widget listener: widgetDefaultSelected on {0}", WidgetListener.calculareSource((TypedEvent)e));
            this.doWidgetDefaultSelected(e);
        } else {
            DebugUtil.trace(DebugUtil.DATASOURCE_TRACING, "Widget listener: ignored widgetDefaultSelected on {0}", WidgetListener.calculareSource((TypedEvent)e));
        }
    }

    protected void doWidgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.isEnabled()) {
            DebugUtil.trace(DebugUtil.DATASOURCE_TRACING, "Widget listener: widgetSelected on {0}", WidgetListener.calculareSource((TypedEvent)e));
            this.doWidgetSelected(e);
        } else {
            DebugUtil.trace(DebugUtil.DATASOURCE_TRACING, "Widget listener: ignored widgetSelected on {0}", WidgetListener.calculareSource((TypedEvent)e));
        }
    }

    protected void doWidgetSelected(SelectionEvent e) {
    }

    public void modifyText(ModifyEvent e) {
        if (this.isEnabled()) {
            DebugUtil.trace(DebugUtil.DATASOURCE_TRACING, "Widget listener: modifyText on {0}", WidgetListener.calculareSource((TypedEvent)e));
            this.doModifyText(e);
        } else {
            DebugUtil.trace(DebugUtil.DATASOURCE_TRACING, "Widget listener: ignored modifyText on {0}", WidgetListener.calculareSource((TypedEvent)e));
        }
    }

    protected void doModifyText(ModifyEvent e) {
    }

    private static String calculareSource(TypedEvent e) {
        Object source = e.getSource();
        return source.getClass().getName();
    }
}

