/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.utils.core.linux;

import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentParser {
    List<String> tokens;

    public ArgumentParser(String commandline) {
        this.tokens = ArgumentParser.parseCommandline(commandline);
    }

    public ArgumentParser(String[] tokenArray) {
        this(Arrays.asList(tokenArray));
    }

    public ArgumentParser(List tokenList) {
        this.tokens = new ArrayList<String>(tokenList);
    }

    public ArgumentParser(String command, String[] parameterArray) {
        this(command, Arrays.asList(parameterArray));
    }

    public ArgumentParser(String command, List<String> parameterList) {
        this.tokens = new ArrayList<String>();
        this.tokens.add(command);
        this.tokens.addAll(parameterList);
    }

    private static List<String> parseCommandline(String commandline) {
        ArrayList<String> result = new ArrayList<String>();
        StringCharacterIterator iterator = new StringCharacterIterator(commandline);
        iterator.first();
        while (iterator.current() != '\uffff') {
            if (!Character.isWhitespace(iterator.current())) {
                StringBuffer buffer = new StringBuffer();
                block17: while (iterator.current() != '\uffff') {
                    char tokenChar = iterator.current();
                    if (Character.isWhitespace(tokenChar)) break;
                    block0 : switch (tokenChar) {
                        case '\"': {
                            iterator.next();
                            while (iterator.current() != '\uffff' && iterator.current() != '\"') {
                                char innerChar = iterator.current();
                                block5 : switch (innerChar) {
                                    case '\\': {
                                        char nextChar = iterator.next();
                                        switch (nextChar) {
                                            case '\uffff': {
                                                break block0;
                                            }
                                            case '\"': {
                                                buffer.append(nextChar);
                                                iterator.next();
                                                break block5;
                                            }
                                        }
                                        buffer.append(innerChar);
                                        buffer.append(nextChar);
                                        iterator.next();
                                        break;
                                    }
                                    default: {
                                        buffer.append(innerChar);
                                        iterator.next();
                                    }
                                }
                            }
                            break;
                        }
                        case '\'': {
                            iterator.next();
                            while (iterator.current() != '\uffff' && iterator.current() != '\'') {
                                buffer.append(iterator.current());
                                iterator.next();
                            }
                            break;
                        }
                        case '\\': {
                            char nextChar = iterator.next();
                            switch (nextChar) {
                                case '\uffff': {
                                    break block17;
                                }
                                case '\n': {
                                    break;
                                }
                                default: {
                                    buffer.append(nextChar);
                                    break;
                                }
                            }
                            break;
                        }
                        default: {
                            buffer.append(tokenChar);
                        }
                    }
                    iterator.next();
                }
                result.add(buffer.toString());
            }
            iterator.next();
        }
        return result;
    }

    public String getCommandLine(boolean fullEscape) {
        StringBuffer buffer = new StringBuffer();
        Iterator<String> iterator = this.tokens.iterator();
        boolean first = true;
        while (iterator.hasNext()) {
            String token = iterator.next();
            if (!first) {
                buffer.append(' ');
            } else {
                first = false;
            }
            buffer.append(this.escapeToken(token, fullEscape));
        }
        return buffer.toString();
    }

    private StringBuffer escapeToken(String token, boolean fullEscape) {
        StringBuffer buffer = new StringBuffer();
        StringCharacterIterator iter = new StringCharacterIterator(token);
        char c = iter.first();
        while (c != '\uffff') {
            if (Character.isWhitespace(c)) {
                buffer.append('\\');
                buffer.append(c);
            } else {
                switch (c) {
                    case '\n': 
                    case '!': 
                    case '\"': 
                    case '#': 
                    case '$': 
                    case '%': 
                    case '&': 
                    case '\'': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case ':': 
                    case ';': 
                    case '<': 
                    case '>': 
                    case '?': 
                    case '@': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '^': 
                    case '`': 
                    case '{': 
                    case '|': 
                    case '}': 
                    case '~': {
                        if (fullEscape) {
                            buffer.append('\\');
                        }
                        buffer.append(c);
                        break;
                    }
                    case ' ': {
                        buffer.append('\\');
                        buffer.append(c);
                        break;
                    }
                    default: {
                        buffer.append(c);
                    }
                }
            }
            c = iter.next();
        }
        return buffer;
    }

    public String[] getTokenArray() {
        return this.tokens.toArray(new String[this.tokens.size()]);
    }

    public List<String> getTokenList() {
        return new ArrayList<String>(this.tokens);
    }

    public String getCommand() {
        if (this.tokens.size() == 0) {
            return null;
        }
        return this.tokens.get(0);
    }

    public String getEscapedCommand(boolean fullEscalpe) {
        if (this.tokens.size() == 0) {
            return null;
        }
        return this.escapeToken(this.tokens.get(0), fullEscalpe).toString();
    }

    public String[] getParameterArray() {
        if (this.tokens.size() == 0) {
            return null;
        }
        return this.tokens.subList(1, this.tokens.size()).toArray(new String[this.tokens.size() - 1]);
    }

    public List getParameterList() {
        if (this.tokens.size() == 0) {
            return null;
        }
        return new ArrayList(this.tokens.subList(1, this.tokens.size()));
    }

    public int getSize() {
        return this.tokens.size();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<");
        Iterator<String> iterator = this.tokens.iterator();
        boolean first = true;
        while (iterator.hasNext()) {
            String token = iterator.next();
            if (!first) {
                buffer.append('\n');
            } else {
                first = false;
            }
            buffer.append(token);
        }
        buffer.append(">");
        return buffer.toString();
    }

    public static void main(String[] args) {
        ArgumentParser parser = new ArgumentParser("foobar", new String[]{"arg1", "arg2", "arg\\3", "arg\"4", "arg'5", "more arguments"});
        System.out.println(parser.getCommandLine(false));
        System.out.println(parser.getCommandLine(true));
        parser = new ArgumentParser(" foo");
        System.out.println(parser);
        parser = new ArgumentParser("foo ");
        System.out.println(parser);
        parser = new ArgumentParser("foo");
        System.out.println(parser);
        parser = new ArgumentParser("foo a");
        System.out.println(parser);
        parser = new ArgumentParser("foo  a");
        System.out.println(parser);
        parser = new ArgumentParser("foo a ");
        System.out.println(parser);
        System.out.println();
        parser = new ArgumentParser(" foo a");
        System.out.println(parser);
        parser = new ArgumentParser(" foo a ");
        System.out.println(parser);
        parser = new ArgumentParser(" foo   a ");
        System.out.println(parser);
        parser = new ArgumentParser("foo\ta");
        System.out.println(parser);
        parser = new ArgumentParser("foo a\t");
        System.out.println(parser);
        parser = new ArgumentParser("foo\ta\t");
        System.out.println(parser);
        System.out.println();
        parser = new ArgumentParser("foo a b");
        System.out.println(parser);
        parser = new ArgumentParser("foo a b ");
        System.out.println(parser);
        parser = new ArgumentParser("foo a b c ");
        System.out.println(parser);
        System.out.println();
        parser = new ArgumentParser("foo\\ a b");
        System.out.println(parser);
        parser = new ArgumentParser("foo \\ab");
        System.out.println(parser);
        parser = new ArgumentParser("foo a\\ b\\ c ");
        System.out.println(parser);
        parser = new ArgumentParser("\\foo a b c ");
        System.out.println(parser);
        parser = new ArgumentParser("foo a b c\\");
        System.out.println(parser);
        parser = new ArgumentParser("foo a \\b c");
        System.out.println(parser);
        System.out.println();
        parser = new ArgumentParser("foo a\\'c b");
        System.out.println(parser);
        parser = new ArgumentParser("foo a\\\"c b");
        System.out.println(parser);
        parser = new ArgumentParser("foo a \\'c b");
        System.out.println(parser);
        parser = new ArgumentParser("foo a \\\"c b");
        System.out.println(parser);
        parser = new ArgumentParser("foo a\\' c b");
        System.out.println(parser);
        parser = new ArgumentParser("foo a\\\" c b");
        System.out.println(parser);
        parser = new ArgumentParser("foo a \\' c b");
        System.out.println(parser);
        parser = new ArgumentParser("foo a \\\" c b");
        System.out.println(parser);
        parser = new ArgumentParser("foo a c b\\'");
        System.out.println(parser);
        parser = new ArgumentParser("foo a c b\\\"");
        System.out.println(parser);
        parser = new ArgumentParser("foo a c b \\'");
        System.out.println(parser);
        parser = new ArgumentParser("foo a c b \\\"");
        System.out.println(parser);
        parser = new ArgumentParser("\\'foo a c b");
        System.out.println(parser);
        parser = new ArgumentParser("\\\"foo a c b");
        System.out.println(parser);
        parser = new ArgumentParser("\\' foo a c b");
        System.out.println(parser);
        parser = new ArgumentParser("\\\" foo a c b");
        System.out.println(parser);
        System.out.println();
        parser = new ArgumentParser("'foo a' b c d");
        System.out.println(parser);
        parser = new ArgumentParser("foo a b 'c d'");
        System.out.println(parser);
        parser = new ArgumentParser("foo a 'b c' d");
        System.out.println(parser);
        parser = new ArgumentParser("foo a 'b\\e' d");
        System.out.println(parser);
        parser = new ArgumentParser("foo a \"b\\e\" d");
        System.out.println(parser);
        parser = new ArgumentParser("foo a 'b c d");
        System.out.println(parser);
        parser = new ArgumentParser("foo a \"b c d");
        System.out.println(parser);
        parser = new ArgumentParser("foo a \"b c\" d");
        System.out.println(parser);
        parser = new ArgumentParser("foo a \"b c\"d");
        System.out.println(parser);
        parser = new ArgumentParser("foo a 'b c' d");
        System.out.println(parser);
        parser = new ArgumentParser("foo a 'b c'd");
        System.out.println(parser);
        parser = new ArgumentParser("foo a 'b \" c' d");
        System.out.println(parser);
        parser = new ArgumentParser("foo a \"b ' c\" d");
        System.out.println(parser);
        parser = new ArgumentParser("foo a 'b \\\" c' d");
        System.out.println(parser);
        parser = new ArgumentParser("foo a \"b ' c\" d");
        System.out.println(parser);
        System.out.println();
        parser = new ArgumentParser(new String[0]);
        System.out.println(parser.getCommandLine(true));
        parser = new ArgumentParser(new String[]{"a"});
        System.out.println(parser.getCommandLine(true));
        parser = new ArgumentParser(new String[]{"av"});
        System.out.println(parser.getCommandLine(true));
        parser = new ArgumentParser(new String[]{"a d"});
        System.out.println(parser.getCommandLine(true));
        parser = new ArgumentParser(new String[]{"a", "a"});
        System.out.println(parser.getCommandLine(true));
        parser = new ArgumentParser(new String[]{"av", "a"});
        System.out.println(parser.getCommandLine(true));
        parser = new ArgumentParser(new String[]{"a d", "a"});
        System.out.println(parser.getCommandLine(true));
        parser = new ArgumentParser(new String[]{"a", "b b"});
        System.out.println(parser.getCommandLine(true));
        parser = new ArgumentParser(new String[]{"av", "b b"});
        System.out.println(parser.getCommandLine(true));
        parser = new ArgumentParser(new String[]{"a d", "b b"});
        System.out.println(parser.getCommandLine(true));
    }
}

