/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.core.rtsystem;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ptp.core.attributes.ArrayAttribute;
import org.eclipse.ptp.core.attributes.AttributeDefinitionManager;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.BooleanAttribute;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.core.attributes.IntegerAttribute;
import org.eclipse.ptp.core.attributes.StringAttribute;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.attributes.ElementAttributeManager;
import org.eclipse.ptp.core.elements.attributes.ElementAttributes;
import org.eclipse.ptp.core.elements.attributes.JobAttributes;
import org.eclipse.ptp.core.elements.attributes.MachineAttributes;
import org.eclipse.ptp.core.elements.attributes.NodeAttributes;
import org.eclipse.ptp.core.elements.attributes.ProcessAttributes;
import org.eclipse.ptp.core.elements.attributes.QueueAttributes;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteProcessBuilder;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.ptp.rm.core.ToolsRMPlugin;
import org.eclipse.ptp.rm.core.messages.Messages;
import org.eclipse.ptp.rm.core.rmsystem.AbstractEffectiveToolRMConfiguration;
import org.eclipse.ptp.rm.core.rmsystem.AbstractToolRMConfiguration;
import org.eclipse.ptp.rm.core.rtsystem.IToolRuntimeSystemJob;
import org.eclipse.ptp.rm.core.utils.DebugUtil;
import org.eclipse.ptp.rtsystem.AbstractRuntimeSystem;
import org.eclipse.ptp.rtsystem.events.IRuntimeEventFactory;
import org.eclipse.ptp.rtsystem.events.IRuntimeJobChangeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeMachineChangeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeNodeChangeEvent;
import org.eclipse.ptp.rtsystem.events.IRuntimeProcessChangeEvent;
import org.eclipse.ptp.rtsystem.events.RuntimeEventFactory;
import org.eclipse.ptp.utils.core.RangeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractToolRuntimeSystem
extends AbstractRuntimeSystem {
    private String rmID;
    private Integer nextID;
    private Integer jobNumber;
    protected AbstractToolRMConfiguration rmConfiguration;
    protected AttributeDefinitionManager attrMgr;
    protected IRemoteServices remoteServices = null;
    private boolean eventsEnabled = false;
    protected IRemoteConnection connection = null;
    private Thread jobQueueThread = null;
    private Job periodicMonitorJob;
    private Job continousMonitorJob;
    Map<String, Job> jobs = Collections.synchronizedMap(new HashMap());
    LinkedBlockingQueue<Job> pendingJobQueue = new LinkedBlockingQueue();
    private IRuntimeEventFactory eventFactory = new RuntimeEventFactory();

    public AbstractToolRuntimeSystem(Integer id, AbstractToolRMConfiguration config, AttributeDefinitionManager manager) {
        this.rmID = id.toString();
        this.nextID = id + 1;
        this.jobNumber = 0;
        this.rmConfiguration = config;
        this.attrMgr = manager;
    }

    public void startup(IProgressMonitor monitor) throws CoreException {
        DebugUtil.trace(DebugUtil.RTS_TRACING, "RTS {0}: startup", this.rmConfiguration.getName());
        this.remoteServices = PTPRemoteCorePlugin.getDefault().getRemoteServices(this.rmConfiguration.getRemoteServicesId());
        if (this.remoteServices == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.rm.core", Messages.AbstractToolRuntimeSystem_Exception_NoRemoteServices));
        }
        IRemoteConnectionManager connectionManager = this.remoteServices.getConnectionManager();
        Assert.isNotNull((Object)connectionManager);
        this.connection = connectionManager.getConnection(this.rmConfiguration.getConnectionName());
        if (this.connection == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.rm.core", Messages.AbstractToolRuntimeSystem_Exception_NoConnection));
        }
        if (!this.connection.isOpen()) {
            try {
                this.connection.open(monitor);
            }
            catch (RemoteConnectionException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.rm.core", e.getMessage()));
            }
        }
        if (monitor.isCanceled()) {
            this.connection.close(monitor);
            this.connection = null;
            return;
        }
        try {
            this.doStartup(monitor);
        }
        catch (CoreException e) {
            this.connection.close(monitor);
            this.connection = null;
            throw e;
        }
        Job discoverJob = this.createDiscoverJob();
        if (discoverJob != null) {
            discoverJob.schedule();
        }
        if (!monitor.isCanceled()) {
            this.fireRuntimeRunningStateEvent(this.eventFactory.newRuntimeRunningStateEvent());
            if (this.jobQueueThread == null) {
                this.jobQueueThread = new Thread((Runnable)new JobRunner(), Messages.AbstractToolRuntimeSystem_JobQueueManagerThreadTitle);
                this.jobQueueThread.start();
            }
        } else {
            this.connection.close(monitor);
            this.connection = null;
        }
    }

    protected abstract void doStartup(IProgressMonitor var1) throws CoreException;

    public void shutdown(IProgressMonitor monitor) throws CoreException {
        DebugUtil.trace(DebugUtil.RTS_TRACING, "RTS {0}: shutdown", this.rmConfiguration.getName());
        this.doShutdown(monitor);
        this.stopEvents();
        this.jobQueueThread.interrupt();
        for (Job job : this.pendingJobQueue) {
            job.cancel();
        }
        Iterator<Job> iterator = this.jobs.values().iterator();
        while (iterator.hasNext()) {
            Job job = iterator.next();
            job.cancel();
            iterator.remove();
        }
        if (this.connection != null) {
            this.connection.close(monitor);
        }
        this.connection = null;
        this.jobQueueThread = null;
        this.fireRuntimeShutdownStateEvent(this.eventFactory.newRuntimeShutdownStateEvent());
    }

    protected abstract void doShutdown(IProgressMonitor var1) throws CoreException;

    public void startEvents() throws CoreException {
        DebugUtil.trace(DebugUtil.RTS_TRACING, "RTS {0}: start events", this.rmConfiguration.getName());
        if (this.periodicMonitorJob == null) {
            this.periodicMonitorJob = this.createPeriodicMonitorJob();
        }
        if (this.continousMonitorJob == null) {
            this.continousMonitorJob = this.createContinuousMonitorJob();
        }
        if (this.periodicMonitorJob != null) {
            this.periodicMonitorJob.schedule();
        }
        if (this.continousMonitorJob != null) {
            this.continousMonitorJob.schedule();
        }
        this.doStartEvents();
    }

    protected abstract void doStartEvents() throws CoreException;

    public void stopEvents() throws CoreException {
        DebugUtil.trace(DebugUtil.RTS_TRACING, "RTS {0}: stop events", this.rmConfiguration.getName());
        if (this.periodicMonitorJob != null) {
            this.periodicMonitorJob.cancel();
        }
        if (this.continousMonitorJob != null) {
            this.continousMonitorJob.cancel();
        }
        this.doStopEvents();
    }

    protected abstract void doStopEvents() throws CoreException;

    protected abstract Job createDiscoverJob() throws CoreException;

    protected abstract Job createPeriodicMonitorJob() throws CoreException;

    protected abstract Job createContinuousMonitorJob() throws CoreException;

    public void submitJob(String subId, AttributeManager attrMgr) throws CoreException {
        if (this.remoteServices == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.rm.core", Messages.AbstractToolRuntimeSystem_Exception_ResourceManagerNotInitialized));
        }
        attrMgr.addAttribute((IAttribute)JobAttributes.getSubIdAttributeDefinition().create(subId));
        String queueID = ((StringAttribute)attrMgr.getAttribute((IAttributeDefinition)JobAttributes.getQueueIdAttributeDefinition())).getValue();
        String jobID = this.createJob(queueID, attrMgr);
        attrMgr.addAttribute((IAttribute)JobAttributes.getJobIdAttributeDefinition().create(jobID));
        DebugUtil.trace(DebugUtil.JOB_TRACING, "RTS {0}: job submission #{0}, job id #{1}, queue id @{2}", this.rmConfiguration.getName(), subId, jobID, queueID);
        Job job = this.createRuntimeSystemJob(jobID, queueID, attrMgr);
        this.jobs.put(jobID, job);
        try {
            this.pendingJobQueue.put(job);
        }
        catch (InterruptedException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.rm.core", e.getMessage()));
        }
    }

    public abstract Job createRuntimeSystemJob(String var1, String var2, AttributeManager var3) throws CoreException;

    public void terminateJob(IPJob ipJob) throws CoreException {
        DebugUtil.trace(DebugUtil.JOB_TRACING, "RTS {0}: terminate job #{1}", this.rmConfiguration.getName(), ipJob.getID());
        Job job = this.jobs.get(ipJob.getID());
        this.pendingJobQueue.remove(job);
        job.cancel();
    }

    public String createJob(String parentID, AttributeManager attrMgr) {
        ElementAttributeManager mgr = new ElementAttributeManager();
        AttributeManager jobAttrMgr = new AttributeManager();
        String jobID = this.generateID().toString();
        jobAttrMgr.addAttribute((IAttribute)JobAttributes.getJobIdAttributeDefinition().create(jobID));
        jobAttrMgr.addAttribute((IAttribute)JobAttributes.getQueueIdAttributeDefinition().create(parentID));
        jobAttrMgr.addAttribute((IAttribute)JobAttributes.getStateAttributeDefinition().create((Enum)JobAttributes.State.PENDING));
        jobAttrMgr.addAttribute((IAttribute)JobAttributes.getUserIdAttributeDefinition().create(System.getenv("USER")));
        jobAttrMgr.addAttribute((IAttribute)ElementAttributes.getNameAttributeDefinition().create(this.generateJobName()));
        String subId = ((StringAttribute)attrMgr.getAttribute((IAttributeDefinition)JobAttributes.getSubIdAttributeDefinition())).getValue();
        String execName = ((StringAttribute)attrMgr.getAttribute((IAttributeDefinition)JobAttributes.getExecutableNameAttributeDefinition())).getValue();
        String execPath = ((StringAttribute)attrMgr.getAttribute((IAttributeDefinition)JobAttributes.getExecutablePathAttributeDefinition())).getValue();
        String workDir = ((StringAttribute)attrMgr.getAttribute((IAttributeDefinition)JobAttributes.getWorkingDirectoryAttributeDefinition())).getValue();
        Integer numProcs = ((IntegerAttribute)attrMgr.getAttribute((IAttributeDefinition)JobAttributes.getNumberOfProcessesAttributeDefinition())).getValue();
        List progArgs = ((ArrayAttribute)attrMgr.getAttribute((IAttributeDefinition)JobAttributes.getProgramArgumentsAttributeDefinition())).getValue();
        BooleanAttribute debugAttr = (BooleanAttribute)attrMgr.getAttribute((IAttributeDefinition)JobAttributes.getDebugFlagAttributeDefinition());
        jobAttrMgr.addAttribute((IAttribute)JobAttributes.getSubIdAttributeDefinition().create(subId));
        jobAttrMgr.addAttribute((IAttribute)JobAttributes.getExecutableNameAttributeDefinition().create(execName));
        jobAttrMgr.addAttribute((IAttribute)JobAttributes.getExecutablePathAttributeDefinition().create(execPath));
        jobAttrMgr.addAttribute((IAttribute)JobAttributes.getWorkingDirectoryAttributeDefinition().create(workDir));
        try {
            jobAttrMgr.addAttribute((IAttribute)JobAttributes.getNumberOfProcessesAttributeDefinition().create(numProcs));
        }
        catch (IllegalValueException e) {
            ToolsRMPlugin.log(e);
        }
        jobAttrMgr.addAttribute((IAttribute)JobAttributes.getProgramArgumentsAttributeDefinition().create((Comparable[])progArgs.toArray(new String[0])));
        if (debugAttr != null) {
            jobAttrMgr.addAttribute((IAttribute)JobAttributes.getDebugFlagAttributeDefinition().create(debugAttr.getValue()));
        }
        mgr.setAttributeManager(new RangeSet(jobID), jobAttrMgr);
        this.fireRuntimeNewJobEvent(this.eventFactory.newRuntimeNewJobEvent(parentID, mgr));
        DebugUtil.trace(DebugUtil.RTS_TRACING, "RTS {0}: new job #{1}", this.rmConfiguration.getName(), jobID);
        return jobID;
    }

    public String createMachine(String name) {
        String id = this.generateID().toString();
        ElementAttributeManager mgr = new ElementAttributeManager();
        AttributeManager attrMgr = new AttributeManager();
        attrMgr.addAttribute((IAttribute)MachineAttributes.getStateAttributeDefinition().create((Enum)MachineAttributes.State.UP));
        attrMgr.addAttribute((IAttribute)ElementAttributes.getNameAttributeDefinition().create(name));
        mgr.setAttributeManager(new RangeSet(id), attrMgr);
        this.fireRuntimeNewMachineEvent(this.eventFactory.newRuntimeNewMachineEvent(this.rmID, mgr));
        DebugUtil.trace(DebugUtil.RTS_TRACING, "RTS {0}: new machine #{1}", this.rmConfiguration.getName(), id);
        return id;
    }

    public String createNode(String parentID, String name, int number) {
        AttributeManager attrMgr;
        ElementAttributeManager mgr;
        String id;
        block2: {
            id = this.generateID();
            mgr = new ElementAttributeManager();
            attrMgr = new AttributeManager();
            attrMgr.addAttribute((IAttribute)NodeAttributes.getStateAttributeDefinition().create((Enum)NodeAttributes.State.UP));
            try {
                attrMgr.addAttribute((IAttribute)NodeAttributes.getNumberAttributeDefinition().create(Integer.valueOf(number)));
            }
            catch (IllegalValueException e) {
                ToolsRMPlugin.log(e);
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        attrMgr.addAttribute((IAttribute)ElementAttributes.getNameAttributeDefinition().create(name));
        mgr.setAttributeManager(new RangeSet(id), attrMgr);
        this.fireRuntimeNewNodeEvent(this.eventFactory.newRuntimeNewNodeEvent(parentID, mgr));
        DebugUtil.trace(DebugUtil.RTS_TRACING, "RTS {0}: new node #{1}", this.rmConfiguration.getName(), id);
        return id;
    }

    public String createQueue(String name) {
        String id = this.generateID();
        ElementAttributeManager mgr = new ElementAttributeManager();
        AttributeManager attrMgr = new AttributeManager();
        attrMgr.addAttribute((IAttribute)QueueAttributes.getStateAttributeDefinition().create((Enum)QueueAttributes.State.NORMAL));
        attrMgr.addAttribute((IAttribute)ElementAttributes.getNameAttributeDefinition().create(name));
        mgr.setAttributeManager(new RangeSet(id), attrMgr);
        this.fireRuntimeNewQueueEvent(this.eventFactory.newRuntimeNewQueueEvent(this.rmID, mgr));
        DebugUtil.trace(DebugUtil.RTS_TRACING, "RTS {0}: new queue #{1}", this.rmConfiguration.getName(), id);
        return id;
    }

    public String createProcess(String parentID, String name, int index) {
        String id = this.generateID();
        ElementAttributeManager mgr = new ElementAttributeManager();
        AttributeManager attrMgr = new AttributeManager();
        attrMgr.addAttribute((IAttribute)ProcessAttributes.getStateAttributeDefinition().create((Enum)ProcessAttributes.State.STARTING));
        try {
            attrMgr.addAttribute((IAttribute)ProcessAttributes.getIndexAttributeDefinition().create(Integer.valueOf(index)));
        }
        catch (IllegalValueException illegalValueException) {
            Assert.isTrue((boolean)false);
        }
        attrMgr.addAttribute((IAttribute)ProcessAttributes.getNodeIdAttributeDefinition().create(parentID));
        attrMgr.addAttribute((IAttribute)ElementAttributes.getNameAttributeDefinition().create(name));
        mgr.setAttributeManager(new RangeSet(id), attrMgr);
        this.fireRuntimeNewProcessEvent(this.eventFactory.newRuntimeNewProcessEvent(parentID, mgr));
        DebugUtil.trace(DebugUtil.RTS_TRACING, "RTS {0}: new process #{1}", this.rmConfiguration.getName(), id);
        return id;
    }

    public void changeProcess(String processID, AttributeManager changedAttrMgr) {
        AttributeManager attrMgr = new AttributeManager();
        attrMgr.addAttributes(changedAttrMgr.getAttributes());
        ElementAttributeManager elementAttrs = new ElementAttributeManager();
        elementAttrs.setAttributeManager(new RangeSet(processID), attrMgr);
        IRuntimeProcessChangeEvent event = this.eventFactory.newRuntimeProcessChangeEvent(elementAttrs);
        this.fireRuntimeProcessChangeEvent(event);
        IAttribute[] iAttributeArray = changedAttrMgr.getAttributes();
        int n = iAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAttribute attr = iAttributeArray[n2];
            DebugUtil.trace(DebugUtil.RTS_TRACING, "RTS {0}, process #{1}: {2}={3}", this.rmConfiguration.getName(), processID, ((IAttributeDefinition)((Object)attr.getDefinition())).getId(), attr.getValueAsString());
            ++n2;
        }
    }

    public void changeJob(String jobID, AttributeManager changedAttrMgr) {
        AttributeManager attrMgr = new AttributeManager();
        attrMgr.addAttributes(changedAttrMgr.getAttributes());
        ElementAttributeManager elementAttrs = new ElementAttributeManager();
        elementAttrs.setAttributeManager(new RangeSet(jobID), attrMgr);
        IRuntimeJobChangeEvent event = this.eventFactory.newRuntimeJobChangeEvent(elementAttrs);
        this.fireRuntimeJobChangeEvent(event);
        IAttribute[] iAttributeArray = changedAttrMgr.getAttributes();
        int n = iAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAttribute attr = iAttributeArray[n2];
            DebugUtil.trace(DebugUtil.RTS_TRACING, "RTS {0}, job #{1}: {2}={3}", this.rmConfiguration.getName(), jobID, ((IAttributeDefinition)((Object)attr.getDefinition())).getId(), attr.getValueAsString());
            ++n2;
        }
    }

    public void changeNode(String nodeID, AttributeManager changedAttrMgr) {
        AttributeManager attrMgr = new AttributeManager();
        attrMgr.addAttributes(changedAttrMgr.getAttributes());
        ElementAttributeManager elementAttrs = new ElementAttributeManager();
        elementAttrs.setAttributeManager(new RangeSet(nodeID), attrMgr);
        IRuntimeNodeChangeEvent event = this.eventFactory.newRuntimeNodeChangeEvent(elementAttrs);
        this.fireRuntimeNodeChangeEvent(event);
        IAttribute[] iAttributeArray = changedAttrMgr.getAttributes();
        int n = iAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAttribute attr = iAttributeArray[n2];
            DebugUtil.trace(DebugUtil.RTS_TRACING, "RTS {0}, node #{1}: {2}={3}", this.rmConfiguration.getName(), nodeID, ((IAttributeDefinition)((Object)attr.getDefinition())).getId(), attr.getValueAsString());
            ++n2;
        }
    }

    public void changeMachine(String machineID, AttributeManager changedAttrMgr) {
        AttributeManager attrMgr = new AttributeManager();
        attrMgr.addAttributes(changedAttrMgr.getAttributes());
        ElementAttributeManager elementAttrs = new ElementAttributeManager();
        elementAttrs.setAttributeManager(new RangeSet(machineID), attrMgr);
        IRuntimeMachineChangeEvent event = this.eventFactory.newRuntimeMachineChangeEvent(elementAttrs);
        this.fireRuntimeMachineChangeEvent(event);
        IAttribute[] iAttributeArray = changedAttrMgr.getAttributes();
        int n = iAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAttribute attr = iAttributeArray[n2];
            DebugUtil.trace(DebugUtil.RTS_TRACING, "RTS {0}, machine #{1}: {2}={3}", this.rmConfiguration.getName(), machineID, ((IAttributeDefinition)((Object)attr.getDefinition())).getId(), attr.getValueAsString());
            ++n2;
        }
    }

    protected String generateID() {
        String id = this.nextID.toString();
        this.nextID = this.nextID + 1;
        return id;
    }

    protected String generateJobName() {
        Integer n = this.jobNumber;
        this.jobNumber = n + 1;
        return "job" + n;
    }

    public IRemoteProcessBuilder createProcessBuilder(List<String> command) {
        return this.remoteServices.getProcessBuilder(this.connection, command);
    }

    public IRemoteProcessBuilder createProcessBuilder(List<String> command, String workdir) throws IOException {
        IRemoteFileManager fileManager;
        IFileStore directory = null;
        if (!this.getRemoteServices().getId().equals("org.eclipse.ptp.remote.RSERemoteServices") && (fileManager = this.remoteServices.getFileManager(this.connection)) != null) {
            directory = fileManager.getResource((IPath)new Path(workdir), (IProgressMonitor)new NullProgressMonitor());
        }
        IRemoteProcessBuilder processBuilder = this.remoteServices.getProcessBuilder(this.connection, command);
        processBuilder.directory(directory);
        return processBuilder;
    }

    public String getRmID() {
        return this.rmID;
    }

    public AbstractToolRMConfiguration getRmConfiguration() {
        return this.rmConfiguration;
    }

    public IRemoteConnection getConnection() {
        return this.connection;
    }

    public IRemoteServices getRemoteServices() {
        return this.remoteServices;
    }

    public abstract AbstractEffectiveToolRMConfiguration retrieveEffectiveToolRmConfiguration();

    class JobRunner
    implements Runnable {
        JobRunner() {
        }

        public void run() {
            DebugUtil.trace(DebugUtil.JOB_TRACING, "RTS {0}: started job thread", AbstractToolRuntimeSystem.this.rmConfiguration.getName());
            try {
                while (AbstractToolRuntimeSystem.this.connection != null) {
                    Job job = AbstractToolRuntimeSystem.this.pendingJobQueue.take();
                    if (job instanceof IToolRuntimeSystemJob) {
                        DebugUtil.trace(DebugUtil.JOB_TRACING, "RTS {0}: schedule job #{1}", AbstractToolRuntimeSystem.this.rmConfiguration.getName(), ((IToolRuntimeSystemJob)job).getJobID());
                    } else {
                        DebugUtil.trace(DebugUtil.JOB_TRACING, "RTS {0}: schedule job #{1}", AbstractToolRuntimeSystem.this.rmConfiguration.getName(), job.getName());
                    }
                    job.schedule();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                DebugUtil.error(DebugUtil.JOB_TRACING, "RTS {0}: {1}", AbstractToolRuntimeSystem.this.rmConfiguration.getName(), e);
                ToolsRMPlugin.log(e);
            }
            DebugUtil.trace(DebugUtil.JOB_TRACING, "RTS {0}: terminated job thread", AbstractToolRuntimeSystem.this.rmConfiguration.getName());
        }
    }
}

