/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.internal.core.pdom.indexer.IndexerPreferences;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.ptp.internal.rdt.core.RemoteIndexerInfoProvider;
import org.eclipse.ptp.internal.rdt.core.RemoteScannerInfo;
import org.eclipse.ptp.rdt.core.RDTLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteIndexerInfoProviderFactory {
    private static final int[] LINKAGE_IDS = new int[]{2, 1};

    public static RemoteIndexerInfoProvider getProvider(String scopeName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(scopeName);
        return RemoteIndexerInfoProviderFactory.getProvider(project);
    }

    public static RemoteIndexerInfoProvider getProvider(IProject project) {
        if (project == null) {
            return new RemoteIndexerInfoProvider();
        }
        final ArrayList<ICElement> elements = new ArrayList<ICElement>();
        IResourceVisitor resourceVisitor = new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (!(resource instanceof IFile)) {
                    return true;
                }
                ITranslationUnit tu = CoreModelUtil.findTranslationUnit((IFile)((IFile)resource));
                if (tu != null) {
                    elements.add(tu);
                }
                return true;
            }
        };
        try {
            project.accept(resourceVisitor);
        }
        catch (CoreException e) {
            RDTLog.logError(e);
        }
        return RemoteIndexerInfoProviderFactory.getProvider(elements);
    }

    public static RemoteIndexerInfoProvider getProvider(List<ICElement> elements) {
        Object localScannerInfo;
        if (elements.isEmpty()) {
            return new RemoteIndexerInfoProvider();
        }
        HashMap<String, RemoteScannerInfo> scannerInfoMap = new HashMap<String, RemoteScannerInfo>();
        HashMap<Integer, RemoteScannerInfo> linkageMap = new HashMap<Integer, RemoteScannerInfo>();
        HashMap<String, String> languageMap = new HashMap<String, String>();
        HashMap<String, Boolean> isHeaderMap = new HashMap<String, Boolean>();
        IProject project = elements.get(0).getCProject().getProject();
        IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(project);
        RemoteScannerInfoCache cache = new RemoteScannerInfoCache();
        for (ICElement element : elements) {
            if (!(element instanceof ITranslationUnit)) continue;
            ITranslationUnit tu = (ITranslationUnit)element;
            localScannerInfo = provider.getScannerInformation(tu.getResource());
            RemoteScannerInfo remoteScannerInfo = cache.get((IScannerInfo)localScannerInfo);
            String path = element.getLocationURI().getPath();
            scannerInfoMap.put(path, remoteScannerInfo);
            try {
                ILanguage language = tu.getLanguage();
                languageMap.put(path, language.getId());
            }
            catch (CoreException e) {
                RDTLog.logError(e);
            }
            isHeaderMap.put(path, tu.isHeaderUnit());
        }
        localScannerInfo = LINKAGE_IDS;
        int tu = LINKAGE_IDS.length;
        int n = 0;
        while (n < tu) {
            int id = localScannerInfo[n];
            IScannerInfo defaultScannerInfo = RemoteIndexerInfoProviderFactory.getDefaultScannerInfo(project, id);
            RemoteScannerInfo remoteScannerInfo = cache.get(defaultScannerInfo);
            linkageMap.put(id, remoteScannerInfo);
            ++n;
        }
        Properties props = IndexerPreferences.getProperties((IProject)project);
        Map<String, Boolean> preferences = RemoteIndexerInfoProviderFactory.computeIndexerPreferences(props);
        String filePref = (String)props.get("filesToParseUpFront");
        List<String> filesToParseUpFront = Arrays.asList(filePref.split(","));
        for (String filename : filesToParseUpFront) {
            IContentType ct = CCorePlugin.getContentType((IProject)project, (String)filename);
            if (ct == null) continue;
            ILanguage language = LanguageManager.getInstance().getLanguage(ct);
            languageMap.put(filename, language.getId());
        }
        return new RemoteIndexerInfoProvider(scannerInfoMap, linkageMap, languageMap, isHeaderMap, preferences, filesToParseUpFront);
    }

    private static Map<String, Boolean> computeIndexerPreferences(Properties props) {
        HashMap<String, Boolean> prefs = new HashMap<String, Boolean>(props.size());
        prefs.put("indexAllFiles", Boolean.valueOf(props.getProperty("indexAllFiles")));
        prefs.put("skipReferences", Boolean.valueOf(props.getProperty("skipReferences")));
        prefs.put("skipTypeReferences", Boolean.valueOf(props.getProperty("skipTypeReferences")));
        prefs.put("updatePolicy", Boolean.valueOf(props.getProperty("skipMacroReferences")));
        return prefs;
    }

    private static IScannerInfo getDefaultScannerInfo(IProject project, int linkageID) {
        IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(project);
        if (provider == null) {
            return null;
        }
        String filename = linkageID == 2 ? "__cdt__.c" : "__cdt__.cpp";
        IFile file = project.getFile(filename);
        IScannerInfo scanInfo = provider.getScannerInformation((IResource)file);
        if (scanInfo == null || scanInfo.getDefinedSymbols().isEmpty()) {
            scanInfo = provider.getScannerInformation((IResource)project);
            if (linkageID == 2) {
                Map definedSymbols = scanInfo.getDefinedSymbols();
                definedSymbols.remove("__cplusplus__");
                definedSymbols.remove("__cplusplus");
            }
        }
        return scanInfo;
    }

    public static RemoteScannerInfo getScannerInfo(IResource resource) {
        IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider(resource.getProject());
        IScannerInfo scannerInfo = provider.getScannerInformation(resource);
        return new RemoteScannerInfo(scannerInfo);
    }

    private static class RemoteScannerInfoCache {
        Map<ScannerInfoKey, RemoteScannerInfo> cache = new HashMap<ScannerInfoKey, RemoteScannerInfo>();

        private RemoteScannerInfoCache() {
        }

        RemoteScannerInfo get(IScannerInfo localScannerInfo) {
            ScannerInfoKey key = new ScannerInfoKey(localScannerInfo);
            RemoteScannerInfo remoteScannerInfo = this.cache.get(key);
            if (remoteScannerInfo == null) {
                remoteScannerInfo = new RemoteScannerInfo(localScannerInfo);
                this.cache.put(key, remoteScannerInfo);
            }
            return remoteScannerInfo;
        }
    }

    private static class ScannerInfoKey {
        private IScannerInfo scannerInfo;
        private int hashCode = 0;

        ScannerInfoKey(IScannerInfo scannerInfo) {
            this.scannerInfo = scannerInfo;
        }

        public boolean equals(Object obj) {
            ScannerInfoKey other = (ScannerInfoKey)obj;
            return this.scannerInfo.getDefinedSymbols().equals(other.scannerInfo.getDefinedSymbols()) && Arrays.equals(this.scannerInfo.getIncludePaths(), other.scannerInfo.getIncludePaths());
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = this.scannerInfo.getDefinedSymbols().hashCode() + Arrays.hashCode(this.scannerInfo.getIncludePaths());
            }
            return this.hashCode;
        }
    }
}

