/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.ptp.debug.core.model.IPGlobalVariable;
import org.eclipse.ptp.debug.core.model.IPGlobalVariableDescriptor;
import org.eclipse.ptp.debug.core.model.IPValue;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIResumedEvent;
import org.eclipse.ptp.debug.core.pdi.model.IPDIArgumentDescriptor;
import org.eclipse.ptp.debug.core.pdi.model.IPDIGlobalVariableDescriptor;
import org.eclipse.ptp.debug.core.pdi.model.IPDIVariable;
import org.eclipse.ptp.debug.core.pdi.model.IPDIVariableDescriptor;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIF;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeArray;
import org.eclipse.ptp.debug.internal.core.model.AbstractPValue;
import org.eclipse.ptp.debug.internal.core.model.CoreModelMessages;
import org.eclipse.ptp.debug.internal.core.model.PDebugElement;
import org.eclipse.ptp.debug.internal.core.model.PValueFactory;
import org.eclipse.ptp.debug.internal.core.model.PVariable;

public class PGlobalVariable
extends PVariable
implements IPGlobalVariable {
    private IPGlobalVariableDescriptor fDescriptor;

    protected PGlobalVariable(PDebugElement parent, IPGlobalVariableDescriptor descriptor, IPDIVariableDescriptor pdiVariableObject) {
        super(parent, pdiVariableObject);
        this.fDescriptor = descriptor;
    }

    protected PGlobalVariable(PDebugElement parent, IPGlobalVariableDescriptor descriptor, IPDIVariableDescriptor pdiVariableObject, String message) {
        super(parent, pdiVariableObject, message);
        this.fDescriptor = descriptor;
    }

    public boolean canEnableDisable() {
        return true;
    }

    public void handleDebugEvents(IPDIEvent[] events) {
        int i = 0;
        while (i < events.length) {
            IPDIEvent event = events[i];
            if (event.contains(this.getTasks()) && event instanceof IPDIResumedEvent) {
                this.setChanged(false);
            }
            ++i;
        }
        super.handleDebugEvents(events);
    }

    public IPGlobalVariableDescriptor getDescriptor() {
        return this.fDescriptor;
    }

    public void dispose() {
        this.internalDispose(true);
        this.setDisposed(true);
    }

    protected void createOriginal(IPDIVariableDescriptor vo) {
        if (vo != null) {
            this.setName(vo.getName());
            this.setOriginal(new InternalVariable(this, vo));
        }
    }

    public IAIF getAIF() throws DebugException {
        return this.getValue().getAIF();
    }

    private class InternalVariable
    implements PVariable.IInternalVariable {
        private PVariable fVariable;
        private IPDIVariableDescriptor fPDIVariableObject;
        private IPDIVariable fPDIVariable;
        private String fQualifiedName;
        private IPValue fValue = PValueFactory.NULL_VALUE;
        private boolean fChanged = false;

        InternalVariable(PVariable var, IPDIVariableDescriptor varObject) {
            this.setVariable(var);
            this.setPDIVariableObject(varObject);
            this.setPDIVariable(varObject instanceof IPDIVariable ? (IPDIVariable)varObject : null);
        }

        public PVariable.IInternalVariable createShadow(int start, int length) throws DebugException {
            InternalVariable iv = null;
            try {
                iv = new InternalVariable(this.getVariable(), this.getPDIVariableObject().getVariableDescriptorAsArray(start, length));
            }
            catch (PDIException e) {
                PGlobalVariable.requestFailed(e.getMessage(), null);
            }
            return iv;
        }

        public PVariable.IInternalVariable createShadow(String type) throws DebugException {
            InternalVariable iv = null;
            try {
                iv = new InternalVariable(this.getVariable(), this.getPDIVariableObject().getVariableDescriptorAsType(type));
            }
            catch (PDIException e) {
                PGlobalVariable.requestFailed(e.getMessage(), null);
            }
            return iv;
        }

        private synchronized IPDIVariable getPDIVariable() throws DebugException {
            if (this.fPDIVariable == null) {
                try {
                    this.fPDIVariable = PGlobalVariable.this.getPDITarget().createGlobalVariable((IPDIGlobalVariableDescriptor)this.getPDIVariableObject());
                }
                catch (PDIException e) {
                    PGlobalVariable.requestFailed(e.getMessage(), null);
                }
            }
            return this.fPDIVariable;
        }

        private void setPDIVariable(IPDIVariable variable) {
            this.fPDIVariable = variable;
        }

        private IPDIVariableDescriptor getPDIVariableObject() {
            if (this.fPDIVariable != null) {
                return this.fPDIVariable;
            }
            return this.fPDIVariableObject;
        }

        private void setPDIVariableObject(IPDIVariableDescriptor variableObject) {
            this.fPDIVariableObject = variableObject;
        }

        public String getQualifiedName() throws DebugException {
            if (this.fQualifiedName == null) {
                try {
                    this.fQualifiedName = this.fPDIVariableObject != null ? this.fPDIVariableObject.getQualifiedName() : null;
                }
                catch (PDIException e) {
                    PGlobalVariable.requestFailed(e.getMessage(), null);
                }
            }
            return this.fQualifiedName;
        }

        private synchronized void invalidate(boolean destroy) {
            try {
                if (destroy && this.fPDIVariable != null) {
                    this.fPDIVariable.dispose();
                }
            }
            catch (PDIException e) {
                PGlobalVariable.this.logError(e.getMessage());
            }
            this.invalidateValue();
            this.setPDIVariable(null);
        }

        public void dispose(boolean destroy) {
            this.invalidate(destroy);
        }

        public boolean isSameVariable(IPDIVariable pdiVar) {
            return this.fPDIVariable != null ? this.fPDIVariable.equals(pdiVar) : false;
        }

        public int sizeof() {
            if (this.getPDIVariableObject() != null) {
                try {
                    return this.getPDIVariableObject().sizeof();
                }
                catch (PDIException pDIException) {}
            }
            return 0;
        }

        public boolean isArgument() {
            return this.getPDIVariableObject() instanceof IPDIArgumentDescriptor;
        }

        public void setValue(String expression) throws DebugException {
            IPDIVariable pdiVariable = null;
            try {
                pdiVariable = this.getPDIVariable();
                if (pdiVariable != null) {
                    pdiVariable.setValue(expression);
                } else {
                    PGlobalVariable.requestFailed(CoreModelMessages.getString("PModificationVariable.0"), null);
                }
            }
            catch (PDIException e) {
                PGlobalVariable.targetRequestFailed(e.getMessage(), null);
            }
        }

        public synchronized IPValue getValue() throws DebugException {
            IPDIVariable var;
            if (this.fValue.equals(PValueFactory.NULL_VALUE) && (var = this.getPDIVariable()) != null) {
                try {
                    IAIF aif = var.getAIF();
                    if (aif != null && aif.getType() instanceof IAIFTypeArray) {
                        int[] dims = ((IAIFTypeArray)aif.getType()).getDimensionDetails();
                        if (dims.length > 0 && dims[0] > 0) {
                            this.fValue = PValueFactory.createIndexedValue(this.getVariable(), var, 0, dims[0]);
                        }
                    } else {
                        this.fValue = PValueFactory.createValue(this.getVariable(), var);
                    }
                }
                catch (PDIException e) {
                    PGlobalVariable.requestFailed(e.getMessage(), e);
                }
            }
            return this.fValue;
        }

        public void invalidateValue() {
            if (this.fValue instanceof AbstractPValue) {
                ((AbstractPValue)this.fValue).dispose();
                this.fValue = PValueFactory.NULL_VALUE;
                if (this.fPDIVariable != null) {
                    this.fPDIVariable.resetValue();
                }
            }
        }

        public boolean isChanged() {
            return this.fChanged;
        }

        public synchronized void setChanged(boolean changed) {
            if (changed) {
                this.invalidateValue();
            }
            if (this.fValue instanceof AbstractPValue) {
                ((AbstractPValue)this.fValue).setChanged(changed);
            }
            this.fChanged = changed;
        }

        public synchronized void preserve() {
            this.setChanged(false);
            if (this.fValue instanceof AbstractPValue) {
                ((AbstractPValue)this.fValue).preserve();
            }
        }

        PVariable getVariable() {
            return this.fVariable;
        }

        private void setVariable(PVariable variable) {
            this.fVariable = variable;
        }

        public void resetValue() {
            if (this.fValue instanceof AbstractPValue) {
                ((AbstractPValue)this.fValue).reset();
            }
        }

        public boolean isEditable() throws DebugException {
            IPDIVariable var = this.getPDIVariable();
            if (var != null) {
                try {
                    return var.isEditable();
                }
                catch (PDIException pDIException) {}
            }
            return false;
        }

        public boolean equals(Object obj) {
            if (obj instanceof InternalVariable) {
                return this.getPDIVariableObject().equals(((InternalVariable)obj).getPDIVariableObject());
            }
            return false;
        }

        public boolean isSameDescriptor(IPDIVariableDescriptor desc) {
            return this.getPDIVariableObject().equals(desc);
        }
    }
}

