/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.proxy.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ptp.proxy.command.IProxyCommand;

public abstract class AbstractProxyCommand
implements IProxyCommand {
    private static List<IProxyCommand> pendingCommands = new ArrayList<IProxyCommand>();
    private int commandID;
    private int transactionID;
    private ArrayList<String> args;

    protected AbstractProxyCommand(int commandID) {
        this.commandID = commandID;
        this.transactionID = this.newTransactionID(this);
        this.args = new ArrayList();
    }

    protected AbstractProxyCommand(int commandID, int transID, String[] args) {
        this.commandID = commandID;
        this.transactionID = transID;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            this.args.add(arg);
            ++n2;
        }
    }

    public void addArgument(String arg) {
        if (arg == null) {
            this.args.add("");
        } else {
            this.args.add(arg);
        }
    }

    public void completed() {
        pendingCommands.add(this.transactionID, null);
    }

    public String[] getArguments() {
        return this.args.toArray(new String[this.args.size()]);
    }

    public int getCommandID() {
        return this.commandID;
    }

    public int getTransactionID() {
        return this.transactionID;
    }

    public String toString() {
        String str = String.valueOf(this.getClass().getSimpleName()) + " tid=" + this.getTransactionID();
        for (String arg : this.args) {
            str = arg == null ? String.valueOf(str) + " <null>" : (arg.equals("") ? String.valueOf(str) + " \"\"" : String.valueOf(str) + " " + arg);
        }
        return str;
    }

    private int newTransactionID(IProxyCommand cmd) {
        int transID = 0;
        while (transID < pendingCommands.size()) {
            if (pendingCommands.get(transID) == null) break;
            ++transID;
        }
        pendingCommands.add(transID, cmd);
        return transID;
    }

    protected void addArgument(boolean arg) {
        this.addArgument(arg ? "1" : "0");
    }

    protected void addArgument(Character arg) {
        this.args.add(arg == null ? "" : arg.toString());
    }

    protected void addArgument(int arg) {
        this.args.add(Integer.toString(arg));
    }

    protected void addArgument(long arg) {
        this.args.add(Long.toString(arg));
    }

    protected void addArguments(String[] args) {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            this.addArgument(arg);
            ++n2;
        }
    }
}

