/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.make.internal.core.scannerconfig.xl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoConsoleParser;
import org.eclipse.cdt.make.core.scannerconfig.ScannerInfoTypes;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.TraceUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ptp.cell.make.core.debug.Debug;

public class XLCSpecsConsoleParser
implements IScannerInfoConsoleParser {
    final Pattern linePattern = Pattern.compile("exec:\\s(?!export)(?:.*)\\((.*)\\)");
    final Pattern symbolPattern = Pattern.compile("-D(.*)");
    final Pattern includePattern = Pattern.compile("-(?:qgcc_c_stdinc|qc_stdinc|qgcc_cpp_stdinc|qcpp_stdinc)=(.*)");
    private IProject fProject = null;
    private IScannerInfoCollector fCollector = null;
    private List symbols = new ArrayList();
    private List includes = new ArrayList();

    public void startup(IProject project, IPath workingDirectory, IScannerInfoCollector collector, IMarkerGenerator markerGenerator) {
        Debug.read();
        Debug.POLICY.pass(Debug.DEBUG_XL_PROVIDER);
        this.fProject = project;
        this.fCollector = collector;
    }

    public boolean processLine(String line) {
        Debug.read();
        Debug.POLICY.enter(Debug.DEBUG_XL_PROVIDER, new Object[]{line});
        boolean rc = false;
        Matcher lineMatcher = this.linePattern.matcher(line);
        if (lineMatcher.matches()) {
            String[] args = lineMatcher.group(1).split(",");
            Debug.POLICY.trace(Debug.DEBUG_XL_PROVIDER, "Matches with {0} arguments", new Object[]{args.length});
            int i = 0;
            while (i < args.length) {
                Matcher symbolMatcher = this.symbolPattern.matcher(args[i]);
                if (symbolMatcher.matches() && !this.symbols.contains(symbolMatcher.group(1))) {
                    this.symbols.add(symbolMatcher.group(1));
                    Debug.POLICY.trace(Debug.DEBUG_XL_PROVIDER, "Added symbol {0}", new Object[]{symbolMatcher.group(1)});
                } else {
                    Matcher includeMatcher = this.includePattern.matcher(args[i]);
                    if (includeMatcher.matches()) {
                        String[] includePaths = includeMatcher.group(1).split(":");
                        int j = 0;
                        while (j < includePaths.length) {
                            if (!this.includes.contains(includePaths[j])) {
                                this.includes.add(includePaths[j]);
                                Debug.POLICY.trace(Debug.DEBUG_XL_PROVIDER, "Added include {0}", new Object[]{includePaths[j]});
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        Debug.POLICY.exit(Debug.DEBUG_XL_PROVIDER);
        return rc;
    }

    public void shutdown() {
        Debug.read();
        Debug.POLICY.pass(Debug.DEBUG_XL_PROVIDER);
        HashMap<ScannerInfoTypes, List> scannerInfo = new HashMap<ScannerInfoTypes, List>();
        scannerInfo.put(ScannerInfoTypes.INCLUDE_PATHS, this.includes);
        scannerInfo.put(ScannerInfoTypes.SYMBOL_DEFINITIONS, this.symbols);
        this.fCollector.contributeToScannerConfig((Object)this.fProject, scannerInfo);
        TraceUtil.outputTrace((String)"Scanner info from 'specs' file", (String)"Include paths", (List)this.includes, new ArrayList(), (String)"Defined symbols", (List)this.symbols);
    }
}

