/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.debug.launch.ui.tabs;

import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ptp.cell.debug.CellDebugPlugin;
import org.eclipse.ptp.cell.debug.launch.CellDebugRemoteDebugger;
import org.eclipse.ptp.cell.debug.launch.ICellDebugLaunchConstants;
import org.eclipse.ptp.cell.debug.launch.ui.tabs.Messages;
import org.eclipse.ptp.cell.debug.ui.DebugUiPlugin;
import org.eclipse.ptp.remotetools.environment.EnvironmentPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CellTargetEnvironmentTab
extends AbstractLaunchConfigurationTab {
    private Combo configs;
    private Combo dbgConfigs;
    private Text dbgBin;
    private Text dbgPort;
    private Text wdir;
    private Button remoteLaunch;
    private boolean canFinish = false;
    private String errorMsg1 = Messages.CellTargetEnvironmentTab_errorMsg1;
    private String errorMsg2 = Messages.CellTargetEnvironmentTab_errorMsg2;
    private String errorMsg3 = Messages.CellTargetEnvironmentTab_errorMsg3;
    private String errorMsg4 = Messages.CellTargetEnvironmentTab_errorMsg4;
    private String errorMsg5 = Messages.CellTargetEnvironmentTab_errorMsg5;
    private int selection = -1;
    private int dbgSelection = -1;
    private String dbgId;

    private void verify() {
        this.canFinish = true;
        this.selection = this.configs.getSelectionIndex();
        if (this.selection <= -1) {
            this.canFinish = false;
            this.setErrorMessage(this.errorMsg1);
        }
        if (this.remoteLaunch.getSelection()) {
            this.wdir.setEnabled(true);
            this.dbgConfigs.setEnabled(true);
            this.dbgBin.setEnabled(true);
            this.dbgPort.setEnabled(true);
            int oldSelection = this.dbgSelection;
            this.dbgSelection = this.dbgConfigs.getSelectionIndex();
            if (this.dbgSelection > -1) {
                if (oldSelection != this.dbgSelection) {
                    String current = this.dbgConfigs.getItem(this.dbgSelection);
                    CellDebugRemoteDebugger dbg = CellDebugPlugin.getDefault().getRemoteDbgConfigByName(current);
                    this.dbgId = dbg.getDebuggerId();
                    this.dbgBin.setText(dbg.getDebugConfig().getDbgBinaryName());
                    this.dbgPort.setText(dbg.getDebugConfig().getDbgPort());
                } else {
                    String value = this.dbgBin.getText();
                    if (value != null && !value.equals("")) {
                        value = null;
                        value = this.dbgPort.getText();
                        if (value == null) {
                            this.canFinish = false;
                            this.setErrorMessage(this.errorMsg4);
                        } else if (value.equals("")) {
                            this.canFinish = false;
                            this.setErrorMessage(this.errorMsg4);
                        } else {
                            try {
                                Integer.valueOf(value);
                            }
                            catch (NumberFormatException numberFormatException) {
                                this.canFinish = false;
                                this.setErrorMessage(this.errorMsg5);
                            }
                        }
                    } else {
                        this.canFinish = false;
                        this.setErrorMessage(this.errorMsg3);
                    }
                }
            } else {
                this.canFinish = false;
                this.setErrorMessage(this.errorMsg2);
            }
        } else {
            this.wdir.setEnabled(false);
            this.dbgConfigs.setEnabled(false);
            this.dbgBin.setEnabled(false);
            this.dbgPort.setEnabled(false);
        }
    }

    public void createControl(Composite parent) {
        GridLayout topLayout = new GridLayout();
        Composite topControl = new Composite(parent, 0);
        topControl.setLayout((Layout)topLayout);
        this.setControl((Control)topControl);
        this.createTargetEnvGroup(topControl);
        this.createBooleanGroup(topControl);
        this.createDbgSelectGroup(topControl);
        this.createRemoteToolsGroup(topControl);
        CheckModifyListener check = new CheckModifyListener();
        this.configs.addSelectionListener((SelectionListener)check);
        this.dbgConfigs.addSelectionListener((SelectionListener)check);
        this.remoteLaunch.addSelectionListener((SelectionListener)check);
        ModifyListener ml = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CellTargetEnvironmentTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.wdir.addModifyListener(ml);
        this.dbgBin.addModifyListener(ml);
        this.dbgPort.addModifyListener(ml);
    }

    private void createBooleanGroup(Composite parent) {
        GridLayout groupLayout = new GridLayout();
        groupLayout.verticalSpacing = 3;
        groupLayout.horizontalSpacing = 3;
        groupLayout.numColumns = 3;
        groupLayout.makeColumnsEqualWidth = false;
        Group group = new Group(parent, 0);
        group.setText(Messages.CellTargetEnvironmentTab_TargetEnvironmentEnablementGroupName);
        group.setLayout((Layout)groupLayout);
        group.setLayoutData((Object)new GridData(768));
        this.remoteLaunch = this.createCheckButton((Composite)group, Messages.CellTargetEnvironmentTab_LaunchGDBServerButtonName);
    }

    private void createDbgSelectGroup(Composite parent) {
        GridLayout groupLayout = new GridLayout();
        groupLayout.verticalSpacing = 3;
        groupLayout.horizontalSpacing = 3;
        groupLayout.numColumns = 1;
        groupLayout.makeColumnsEqualWidth = false;
        Group group = new Group(parent, 0);
        group.setText(Messages.CellTargetEnvironmentTab_GDBServerConfigurationGroupName);
        group.setLayout((Layout)groupLayout);
        group.setLayoutData((Object)new GridData(768));
        this.dbgConfigs = CellTargetEnvironmentTab.createShortDropDownRow((Composite)group, Messages.CellTargetEnvironmentTab_GDBServerSelectionDropDownName);
        GridLayout textLayout = new GridLayout();
        textLayout.verticalSpacing = 3;
        textLayout.horizontalSpacing = 3;
        textLayout.numColumns = 1;
        textLayout.makeColumnsEqualWidth = false;
        Composite comp = new Composite((Composite)group, 0);
        comp.setLayout((Layout)textLayout);
        comp.setLayoutData((Object)new GridData(768));
        this.dbgBin = CellTargetEnvironmentTab.createTextRow(comp, Messages.CellTargetEnvironmentTab_GDBServerBinaryTextRowName, null);
        this.dbgPort = CellTargetEnvironmentTab.createTextRow(comp, Messages.CellTargetEnvironmentTab_GDBServerPortTextRowName, null);
    }

    private void createTargetEnvGroup(Composite parent) {
        GridLayout groupLayout = new GridLayout();
        groupLayout.verticalSpacing = 3;
        groupLayout.horizontalSpacing = 3;
        groupLayout.numColumns = 1;
        groupLayout.makeColumnsEqualWidth = false;
        Group group = new Group(parent, 0);
        group.setText(Messages.CellTargetEnvironmentTab_TargetEnvironmentConfigurationSelectionGroupName);
        group.setLayout((Layout)groupLayout);
        group.setLayoutData((Object)new GridData(768));
        this.configs = CellTargetEnvironmentTab.createShortDropDownRow((Composite)group, Messages.CellTargetEnvironmentTab_TargetDropDownName);
    }

    public static Combo createShortDropDownRow(Composite parent, String labelString) {
        GridLayout rowLayout = new GridLayout();
        rowLayout.verticalSpacing = 1;
        rowLayout.marginWidth = 0;
        rowLayout.marginHeight = 0;
        rowLayout.numColumns = 2;
        Composite row = new Composite(parent, 0);
        row.setLayout((Layout)rowLayout);
        row.setLayoutData((Object)new GridData(768));
        Label label = new Label(row, 0);
        label.setText(String.valueOf(labelString) + ":");
        Combo combo = new Combo(row, 12);
        combo.setLayoutData((Object)new GridData(768));
        return combo;
    }

    public static Text createTextRow(Composite parent, String labelString, String valueString) {
        GridLayout rowLayout = new GridLayout();
        rowLayout.verticalSpacing = 1;
        rowLayout.marginWidth = 0;
        rowLayout.marginHeight = 0;
        rowLayout.numColumns = 2;
        Composite row = new Composite(parent, 0);
        row.setLayout((Layout)rowLayout);
        row.setLayoutData((Object)new GridData(768));
        Label label = new Label(row, 0);
        label.setText(String.valueOf(labelString) + ":");
        Text text = new Text(row, 2052);
        if (valueString == null) {
            valueString = "";
        }
        text.setText(valueString);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    private void createRemoteToolsGroup(Composite parent) {
        GridLayout groupLayout = new GridLayout();
        groupLayout.verticalSpacing = 3;
        groupLayout.horizontalSpacing = 3;
        groupLayout.numColumns = 1;
        groupLayout.makeColumnsEqualWidth = false;
        Group group = new Group(parent, 0);
        group.setText(Messages.CellTargetEnvironmentTab_TargetEnvironmentDeploySettingsGroupName);
        group.setLayout((Layout)groupLayout);
        group.setLayoutData((Object)new GridData(768));
        this.wdir = CellTargetEnvironmentTab.createTextRow((Composite)group, Messages.CellTargetEnvironmentTab_RemoteWorkingDirTextRowName, null);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.initTargetEnv(configuration);
        this.initRemoteLaunchConfig(configuration);
        this.initDbgConfig(configuration);
        this.verify();
    }

    private void initTargetEnv(ILaunchConfiguration configuration) {
        String current;
        this.configs.removeAll();
        try {
            current = configuration.getAttribute(ICellDebugLaunchConstants.TARGET_ENV_SELECTED, "");
        }
        catch (CoreException coreException) {
            current = "";
        }
        int selected = -1;
        String[] targets = EnvironmentPlugin.getDefault().getTargetsManager().getAllConfigNames();
        int i = 0;
        while (i < targets.length) {
            this.configs.add(targets[i]);
            if (current.equals(targets[i])) {
                selected = i;
            }
            ++i;
        }
        if (selected > -1) {
            this.configs.select(selected);
            this.selection = selected;
        }
    }

    private void initRemoteLaunchConfig(ILaunchConfiguration configuration) {
        int remote = 1;
        try {
            remote = configuration.getAttribute(ICellDebugLaunchConstants.TARGET_REMOTELAUNCH, 1);
        }
        catch (CoreException coreException) {
            remote = 1;
        }
        if (remote > 0) {
            this.remoteLaunch.setSelection(true);
        } else {
            this.remoteLaunch.setSelection(false);
        }
        String current = "";
        try {
            current = configuration.getAttribute(ICellDebugLaunchConstants.TARGET_WDIR, "");
        }
        catch (CoreException coreException) {
            current = "";
        }
        this.wdir.setText(current);
    }

    private void initDbgConfig(ILaunchConfiguration configuration) {
        String current;
        this.dbgConfigs.removeAll();
        try {
            current = configuration.getAttribute(ICellDebugLaunchConstants.TARGET_REMOTELAUNCH_SELECTED_CFG, "");
        }
        catch (CoreException coreException) {
            current = "";
        }
        int selected = -1;
        CellDebugPlugin plugin = CellDebugPlugin.getDefault();
        String[] targets = plugin.getRemoteDbgNames();
        int i = 0;
        while (i < targets.length) {
            this.dbgConfigs.add(targets[i]);
            if (current.equals(targets[i])) {
                selected = i;
            }
            ++i;
        }
        if (selected > -1) {
            this.dbgConfigs.select(selected);
            this.dbgSelection = selected;
            try {
                this.dbgBin.setText(configuration.getAttribute(ICellDebugLaunchConstants.TARGET_REMOTELAUNCH_SELECTED_BINARY, CellDebugPlugin.getDefault().getRemoteDbgConfigByName(current).getDebugConfig().getDbgBinaryName()));
            }
            catch (CoreException coreException) {}
            try {
                this.dbgPort.setText(Integer.toString(configuration.getAttribute(ICellDebugLaunchConstants.TARGET_REMOTELAUNCH_SELECTED_PORT, Integer.valueOf(CellDebugPlugin.getDefault().getRemoteDbgConfigByName(current).getDebugConfig().getDbgPort()).intValue())));
            }
            catch (CoreException coreException) {}
            this.dbgId = CellDebugPlugin.getDefault().getRemoteDbgConfigByName(current).getDebuggerId();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.selection > -1) {
            configuration.setAttribute(ICellDebugLaunchConstants.TARGET_ENV_SELECTED, this.configs.getItem(this.selection));
        }
        configuration.setAttribute(ICellDebugLaunchConstants.TARGET_WDIR, this.wdir.getText());
        configuration.setAttribute(ICellDebugLaunchConstants.TARGET_REMOTELAUNCH, this.remoteLaunch.getSelection() ? 1 : 0);
        configuration.setAttribute(ICellDebugLaunchConstants.TARGET_REMOTELAUNCH_SELECTED_BINARY, this.dbgBin.getText());
        try {
            configuration.setAttribute(ICellDebugLaunchConstants.TARGET_REMOTELAUNCH_SELECTED_PORT, Integer.valueOf(this.dbgPort.getText()).intValue());
        }
        catch (NumberFormatException numberFormatException) {
            configuration.setAttribute(ICellDebugLaunchConstants.TARGET_REMOTELAUNCH_SELECTED_PORT, 0);
        }
        configuration.setAttribute(ICellDebugLaunchConstants.TARGET_REMOTELAUNCH_SELECTED_DBGID, this.dbgId);
        if (this.dbgSelection > -1) {
            configuration.setAttribute(ICellDebugLaunchConstants.TARGET_REMOTELAUNCH_SELECTED_CFG, this.dbgConfigs.getItem(this.dbgSelection));
        }
    }

    public String getName() {
        return Messages.CellTargetEnvironmentTab_TabName;
    }

    public Image getImage() {
        URL url = DebugUiPlugin.getDefault().getBundle().getEntry("/icons/iprocess.gif");
        ImageDescriptor imageMon = ImageDescriptor.createFromURL((URL)url);
        return imageMon.createImage();
    }

    public boolean canSave() {
        return super.canSave();
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        this.verify();
        return super.isValid(launchConfig) && this.canFinish;
    }

    class CheckModifyListener
    implements SelectionListener {
        CheckModifyListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            CellTargetEnvironmentTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetSelected(SelectionEvent e) {
            CellTargetEnvironmentTab.this.updateLaunchConfigurationDialog();
        }
    }
}

