/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.callhierarchy;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.callhierarchy.CHMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.ptp.internal.rdt.ui.callhierarchy.CHHistoryAction;
import org.eclipse.ptp.internal.rdt.ui.callhierarchy.CHHistoryListAction;
import org.eclipse.ptp.internal.rdt.ui.callhierarchy.RemoteCHViewPart;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class CHHistoryDropDownAction
extends Action
implements IMenuCreator {
    public static final int RESULTS_IN_DROP_DOWN = 10;
    private RemoteCHViewPart fHierarchyView;
    private Menu fMenu;

    public CHHistoryDropDownAction(RemoteCHViewPart view) {
        this.fHierarchyView = view;
        this.fMenu = null;
        this.setToolTipText(CHMessages.CHHistoryDropDownAction_ShowHistoryList_tooltip);
        CPluginImages.setImageDescriptors((IAction)this, (String)"lcl16/", (String)"history_list.gif");
        this.setMenuCreator(this);
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        ICElement[] elements = this.fHierarchyView.getHistoryEntries();
        this.addEntries(this.fMenu, elements);
        new MenuItem(this.fMenu, 2);
        this.addActionToMenu(this.fMenu, new CHHistoryListAction(this.fHierarchyView));
        this.addActionToMenu(this.fMenu, new ClearHistoryAction(this.fHierarchyView));
        return this.fMenu;
    }

    private boolean addEntries(Menu menu, ICElement[] elements) {
        boolean checked = false;
        int min = Math.min(elements.length, 10);
        int i = 0;
        while (i < min) {
            CHHistoryAction action = new CHHistoryAction(this.fHierarchyView, elements[i]);
            action.setChecked(elements[i].equals(this.fHierarchyView.getInput()));
            checked = checked || action.isChecked();
            this.addActionToMenu(menu, action);
            ++i;
        }
        return checked;
    }

    protected void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    public void run() {
        new CHHistoryListAction(this.fHierarchyView).run();
    }

    public static class ClearHistoryAction
    extends Action {
        private RemoteCHViewPart fView;

        public ClearHistoryAction(RemoteCHViewPart view) {
            super(CHMessages.CHHistoryDropDownAction_ClearHistory_label);
            this.fView = view;
        }

        public void run() {
            this.fView.setHistoryEntries(new ICElement[0]);
            this.fView.setInput(null);
        }
    }
}

