/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.editor;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.text.CReconcilingStrategy;
import org.eclipse.cdt.internal.ui.text.ICReconcilingListener;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ptp.internal.rdt.core.model.RemoteReconcileWorkingCopyOperation;
import org.eclipse.ui.texteditor.ITextEditor;

public class RemoteCReconcilingStrategy
extends CReconcilingStrategy {
    private ITextEditor fEditor;
    private IWorkingCopyManager fManager;
    private IProgressMonitor fProgressMonitor;

    public RemoteCReconcilingStrategy(ITextEditor editor) {
        super(editor);
        this.fEditor = editor;
        this.fManager = CUIPlugin.getDefault().getWorkingCopyManager();
    }

    public void initialReconcile() {
        this.reconcile(true);
    }

    public void reconcile(IRegion region) {
        this.reconcile(false);
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconcile(boolean initialReconcile) {
        boolean computeAST = this.fEditor instanceof ICReconcilingListener;
        IWorkingCopy workingCopy = this.fManager.getWorkingCopy(this.fEditor.getEditorInput());
        if (workingCopy == null) {
            return;
        }
        try {
            IWorkingCopy iWorkingCopy = workingCopy;
            synchronized (iWorkingCopy) {
                RemoteReconcileWorkingCopyOperation op = new RemoteReconcileWorkingCopyOperation((ICElement)workingCopy, computeAST, true);
                op.runOperation(this.fProgressMonitor);
            }
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (CModelException e) {
            Status status = new Status(4, "org.eclipse.cdt.ui", 0, "Error in CDT UI during reconcile", (Throwable)e);
            CUIPlugin.log((IStatus)status);
        }
    }
}

