/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.pdt.xml.core;

import java.io.File;
import java.io.IOException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ptp.cell.pdt.xml.core.ConfigurationFileGenerationException;
import org.eclipse.ptp.cell.pdt.xml.core.eventgroup.EventGroup;
import org.eclipse.ptp.cell.pdt.xml.core.eventgroup.EventGroupForest;
import org.eclipse.ptp.cell.pdt.xml.core.eventgroup.EventSubgroup;
import org.eclipse.ptp.cell.pdt.xml.debug.Debug;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractPdtXmlGenerator {
    protected IPath xmlFilePath;
    protected EventGroupForest eventGroupForest;
    protected boolean isCellArchitecture;

    public abstract Document generatePdtXmlDocument();

    public AbstractPdtXmlGenerator(IPath xmlFilePath, EventGroupForest eventGroupForest) {
        this.xmlFilePath = xmlFilePath;
        this.eventGroupForest = eventGroupForest;
    }

    public void generatePdtXmlFile() throws ConfigurationFileGenerationException {
        Debug.read();
        Debug.POLICY.enter(Debug.DEBUG_XML_GENERATOR);
        Document doc = this.generatePdtXmlDocument();
        try {
            File xmlFile = this.xmlFilePath.toFile();
            if (!xmlFile.exists()) {
                xmlFile.createNewFile();
            }
            TransformerFactory tranFactory = TransformerFactory.newInstance();
            Transformer aTransformer = tranFactory.newTransformer();
            DOMSource src = new DOMSource(doc);
            StreamResult dest = new StreamResult(xmlFile.getPath());
            aTransformer.transform(src, dest);
        }
        catch (TransformerException e) {
            Debug.POLICY.error(Debug.DEBUG_XML_GENERATOR, (Throwable)e);
            throw new ConfigurationFileGenerationException(e);
        }
        catch (IOException e) {
            Debug.POLICY.error(Debug.DEBUG_XML_GENERATOR, (Throwable)e);
            throw new ConfigurationFileGenerationException(e);
        }
        Debug.POLICY.exit(Debug.DEBUG_XML_GENERATOR);
    }

    protected Element createSubgroupElement(Document xml, EventSubgroup subgroup) throws DOMException {
        Element subgroupElement = xml.createElement("sub_group");
        subgroupElement.setAttribute("name", subgroup.getName());
        subgroupElement.setAttribute("active", String.valueOf(subgroup.getActive()));
        return subgroupElement;
    }

    protected Element createGroupElement(Document xml, EventGroup group) throws DOMException {
        Element groupElement = xml.createElement("group");
        groupElement.setAttribute("name", group.getName());
        groupElement.setAttribute("active", String.valueOf(group.getActive()));
        return groupElement;
    }

    protected Element createConfigurationElement(Document xml, Element pdtConfigElement, String configName, String hostName, boolean isProfileActive) throws DOMException {
        Element configElement = xml.createElement("configuration");
        pdtConfigElement.appendChild(configElement);
        configElement.setAttribute("name", configName);
        Element hostElement = xml.createElement("host");
        configElement.appendChild(hostElement);
        hostElement.setAttribute("name", hostName);
        Element groupsControlElement = xml.createElement("groupsControl");
        configElement.appendChild(groupsControlElement);
        Element generalGroupElement = xml.createElement("group");
        groupsControlElement.appendChild(generalGroupElement);
        generalGroupElement.setAttribute("name", "GENERAL");
        generalGroupElement.setAttribute("active", "true");
        Element profileElement = xml.createElement("profile");
        generalGroupElement.appendChild(profileElement);
        profileElement.setAttribute("active", String.valueOf(isProfileActive));
        return groupsControlElement;
    }

    protected void createGroupsElement(Document xml, Element pdtConfigElement) throws DOMException {
        Element groupsElement = xml.createElement("groups");
        pdtConfigElement.appendChild(groupsElement);
        for (EventGroup group : this.eventGroupForest.getGroupsUnion()) {
            Element groupElement = xml.createElement("group");
            groupsElement.appendChild(groupElement);
            groupElement.setAttribute("name", group.getName());
            groupElement.setAttribute("description", "");
            groupElement.setAttribute("id", group.getId());
            Element viewElement = xml.createElement("view");
            groupElement.appendChild(viewElement);
            viewElement.setAttribute("yStart", String.valueOf(group.getYStart()));
            viewElement.setAttribute("yEnd", String.valueOf(group.getYEnd()));
            viewElement.setAttribute("color", "0x" + Integer.toHexString(group.getColor()));
            Element includeElement = xml.createElement("include");
            groupElement.appendChild(includeElement);
            includeElement.setAttribute("href", group.getAssociatedPath().toOSString());
        }
    }

    protected Element createPdtConfigElement(Document xml) throws DOMException {
        Element pdtConfigElement = xml.createElement("pdt_configuration");
        xml.appendChild(pdtConfigElement);
        pdtConfigElement.setAttribute("application_name", "");
        pdtConfigElement.setAttribute("output_dir", ".");
        pdtConfigElement.setAttribute("version", "3.0");
        return pdtConfigElement;
    }
}

