/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.openmp.analysis;

import java.util.Set;
import java.util.Stack;
import org.eclipse.cdt.core.dom.CDOM;
import org.eclipse.cdt.core.dom.IASTServiceProvider;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ptp.pldt.common.util.Utility;
import org.eclipse.ptp.pldt.openmp.analysis.OpenMPAnalysisException;
import org.eclipse.ptp.pldt.openmp.analysis.OpenMPErrorManager;
import org.eclipse.ptp.pldt.openmp.analysis.PAST.PASTElif;
import org.eclipse.ptp.pldt.openmp.analysis.PAST.PASTElse;
import org.eclipse.ptp.pldt.openmp.analysis.PAST.PASTEndif;
import org.eclipse.ptp.pldt.openmp.analysis.PAST.PASTFactory;
import org.eclipse.ptp.pldt.openmp.analysis.PAST.PASTIf;
import org.eclipse.ptp.pldt.openmp.analysis.PAST.PASTIfdef;
import org.eclipse.ptp.pldt.openmp.analysis.PAST.PASTIfndef;
import org.eclipse.ptp.pldt.openmp.analysis.PAST.PASTNode;
import org.eclipse.ptp.pldt.openmp.analysis.PAST.PASTOMPFactory;
import org.eclipse.ptp.pldt.openmp.analysis.PAST.PASTOMPPragma;
import org.eclipse.ptp.pldt.openmp.analysis.PAST.PASTPragma;
import org.eclipse.ptp.pldt.openmp.analysis.dictionary.Dictionary;
import org.eclipse.ptp.pldt.openmp.analysis.dictionary.DictionaryFactory;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.factory.FileConcurrencyAnalysis;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.factory.FileStatementMap;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.factory.FunctionConcurrencyAnalysis;

public class OpenMPAnalysisManager {
    protected IASTTranslationUnit astTransUnit_ = null;
    protected IFile iFile_ = null;
    protected PASTNode[] past_ = null;
    protected PASTOMPPragma[] ompPragmas_ = null;
    protected FileConcurrencyAnalysis fileAnalysis_ = null;
    protected FunctionConcurrencyAnalysis[] analyses_ = null;
    protected FileStatementMap fileMap_ = null;
    private static final boolean traceOn = false;
    protected Dictionary dictionary_ = null;
    protected OpenMPErrorManager errorManager_ = new OpenMPErrorManager();
    protected static OpenMPAnalysisManager currentManager_ = null;

    public OpenMPAnalysisManager(IFile iFile) throws OpenMPAnalysisException {
        try {
            this.astTransUnit_ = CDOM.getInstance().getASTService().getTranslationUnit(iFile, CDOM.getInstance().getCodeReaderFactory(0));
        }
        catch (IASTServiceProvider.UnsupportedDialectException e) {
            throw new OpenMPAnalysisException(e.toString());
        }
        this.iFile_ = iFile;
        this.init();
        currentManager_ = this;
    }

    public OpenMPAnalysisManager(IASTTranslationUnit astTransUnit, IFile iFile) {
        this.astTransUnit_ = astTransUnit;
        this.iFile_ = iFile;
        this.init();
        currentManager_ = this;
    }

    public static OpenMPAnalysisManager getCurrentManager() {
        return currentManager_;
    }

    private void init() {
        this.buildPreprocessorAST();
        this.buildDictionary();
        this.buildOMPPragmas();
        this.buildOMPConcurrencyAnalysis();
        this.buildFileMap();
    }

    private void buildPreprocessorAST() {
        IASTPreprocessorStatement[] plist = this.astTransUnit_.getAllPreprocessorStatements();
        this.past_ = new PASTNode[plist.length];
        int i = 0;
        while (i < plist.length) {
            this.past_[i] = PASTFactory.PASTFactoryMake(plist[i]);
            ++i;
        }
        this.computeCompiled();
    }

    private void buildDictionary() {
        this.dictionary_ = DictionaryFactory.buildDictionary(this.astTransUnit_);
    }

    private void buildOMPPragmas() {
        int pCount = 0;
        IDocument pragmaDoc = null;
        String filename = "";
        int i = 0;
        while (i < this.past_.length) {
            if (this.past_[i] instanceof PASTPragma) {
                PASTPragma pragma = (PASTPragma)this.past_[i];
                String newFileName = ((PASTPragma)this.past_[i]).getContainingFilename();
                if (!filename.equals(newFileName)) {
                    filename = newFileName;
                    pragmaDoc = Utility.getDocument((String)filename);
                }
                if (pragmaDoc != null) {
                    try {
                        String content = pragmaDoc.get(pragma.getLocalOffset(), pragma.getLength());
                        pragma.setContent(content);
                    }
                    catch (Exception exception) {}
                }
                this.past_[i] = PASTOMPFactory.makePASTOMP((PASTPragma)this.past_[i], this.astTransUnit_, this.dictionary_);
                if (this.past_[i] instanceof PASTOMPPragma) {
                    ++pCount;
                }
            }
            ++i;
        }
        int index = 0;
        this.ompPragmas_ = new PASTOMPPragma[pCount];
        int i2 = 0;
        while (i2 < this.past_.length) {
            if (this.past_[i2] instanceof PASTOMPPragma) {
                this.ompPragmas_[index++] = (PASTOMPPragma)this.past_[i2];
            }
            ++i2;
        }
    }

    private void buildOMPConcurrencyAnalysis() {
        this.fileAnalysis_ = new FileConcurrencyAnalysis(this.astTransUnit_, this.iFile_, this.getOMPPragmas());
    }

    protected void buildFileMap() {
        this.fileMap_ = new FileStatementMap(this.astTransUnit_);
        this.fileMap_.buildMap();
    }

    public PASTNode[] getPAST() {
        return this.past_;
    }

    public PASTOMPPragma[] getOMPPragmas() {
        return this.ompPragmas_;
    }

    public IASTTranslationUnit getTU() {
        return this.astTransUnit_;
    }

    public FileStatementMap getFileMap() {
        return this.fileMap_;
    }

    public FunctionConcurrencyAnalysis[] getAnalyses() {
        return this.analyses_;
    }

    public Set getNodesConcurrentTo(IASTNode node) {
        return this.fileAnalysis_.getNodesConcurrentTo(node);
    }

    protected void printPASTResults() {
        int i = 0;
        while (i < this.past_.length) {
            System.out.print(String.valueOf(this.past_[i].getType()) + " " + (this.past_[i].isCompiled() ? "compiled" : "not compiled"));
            System.out.print(" at (" + this.past_[i].getFilename() + "," + this.past_[i].getStartingLine() + "," + this.past_[i].getStartLocation() + "," + this.past_[i].getEndLocation() + ") ");
            if (this.past_[i] instanceof PASTOMPPragma) {
                int t = ((PASTOMPPragma)this.past_[i]).getOMPType();
                System.out.println(" OMPPragma type=" + t);
            } else {
                System.out.println("");
            }
            ++i;
        }
    }

    private void computeCompiled() {
        int currentLevel;
        Stack<CompiledContext> context = new Stack<CompiledContext>();
        boolean currentEvaluation = true;
        int lastNonIgnoredIf = currentLevel = 0;
        context.push(new CompiledContext(currentLevel, currentEvaluation));
        int ifcount = 0;
        int endifcount = 0;
        int i = 0;
        i = 0;
        while (i < this.past_.length) {
            CompiledContext cc;
            PASTNode node = this.past_[i];
            if (node == null) {
                // empty if block
            }
            if (currentEvaluation) {
                if (this.isIf(node)) {
                    currentEvaluation = this.ifDecision(node);
                    ++lastNonIgnoredIf;
                    context.push(new CompiledContext(++currentLevel, currentEvaluation));
                    ++ifcount;
                } else if (this.isElse(node)) {
                    currentEvaluation = false;
                    if (context.empty()) break;
                    ((CompiledContext)context.peek()).setEvaluation(currentEvaluation);
                } else if (this.isElseif(node)) {
                    cc = (CompiledContext)context.peek();
                    cc.setWasTrue(true);
                    currentEvaluation = false;
                    cc.setEvaluation(false);
                } else if (this.isEnd(node)) {
                    if (context.empty()) break;
                    context.pop();
                    --currentLevel;
                    --lastNonIgnoredIf;
                    if (context.empty()) break;
                    currentEvaluation = ((CompiledContext)context.peek()).getEvaluation();
                    ++endifcount;
                }
                node.setCompiled(true);
            } else if (currentLevel == lastNonIgnoredIf) {
                if (this.isIf(node)) {
                    ++currentLevel;
                    node.setCompiled(false);
                    ++ifcount;
                } else if (this.isElse(node)) {
                    cc = (CompiledContext)context.peek();
                    currentEvaluation = !cc.wasTrue();
                    if (context.empty()) break;
                    ((CompiledContext)context.peek()).setEvaluation(currentEvaluation);
                    node.setCompiled(true);
                } else if (this.isElseif(node)) {
                    cc = (CompiledContext)context.peek();
                    if (cc.wasTrue()) {
                        currentEvaluation = false;
                    } else {
                        currentEvaluation = this.ifDecision(node);
                        if (currentEvaluation) {
                            cc.setWasTrue(true);
                        }
                    }
                    cc.setEvaluation(currentEvaluation);
                } else if (this.isEnd(node)) {
                    context.pop();
                    --currentLevel;
                    --lastNonIgnoredIf;
                    if (context.empty()) break;
                    currentEvaluation = ((CompiledContext)context.peek()).getEvaluation();
                    node.setCompiled(currentEvaluation);
                    ++endifcount;
                } else {
                    node.setCompiled(false);
                }
            } else {
                if (this.isIf(node)) {
                    ++currentLevel;
                    ++ifcount;
                } else if (this.isEnd(node)) {
                    --currentLevel;
                    ++endifcount;
                }
                node.setCompiled(false);
            }
            ++i;
        }
    }

    private boolean isIf(PASTNode node) {
        return node instanceof PASTIf || node instanceof PASTIfdef || node instanceof PASTIfndef;
    }

    private boolean ifDecision(PASTNode node) {
        if (node instanceof PASTIf) {
            return ((PASTIf)node).taken();
        }
        if (node instanceof PASTIfdef) {
            return ((PASTIfdef)node).taken();
        }
        if (node instanceof PASTIfndef) {
            return ((PASTIfndef)node).taken();
        }
        return false;
    }

    private boolean isElse(PASTNode node) {
        return node instanceof PASTElse;
    }

    private boolean isElseif(PASTNode node) {
        return node instanceof PASTElif;
    }

    private boolean isEnd(PASTNode node) {
        return node instanceof PASTEndif;
    }

    private static class CompiledContext {
        private boolean evaluation_ = false;
        private int nestedLevel_ = 0;
        private boolean wasTrue_ = false;

        public CompiledContext(int nestedLevel, boolean evaluation) {
            this.evaluation_ = evaluation;
            this.nestedLevel_ = nestedLevel;
        }

        public boolean getEvaluation() {
            return this.evaluation_;
        }

        public void setEvaluation(boolean evaluation) {
            this.evaluation_ = evaluation;
        }

        public int getNestedLevel() {
            return this.nestedLevel_;
        }

        public boolean wasTrue() {
            return this.wasTrue_;
        }

        public void setWasTrue(boolean tf) {
            this.wasTrue_ = tf;
        }
    }
}

