/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.sourcelookup.ISourceLookupResult;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.resources.FileStorage;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.IPDebugEventListener;
import org.eclipse.ptp.debug.core.IPSession;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.event.IPDebugEvent;
import org.eclipse.ptp.debug.core.event.IPDebugInfo;
import org.eclipse.ptp.debug.core.event.IPDebugSuspendInfo;
import org.eclipse.ptp.debug.core.model.IPDebugTarget;
import org.eclipse.ptp.debug.core.model.IPStackFrame;
import org.eclipse.ptp.debug.core.model.IPThread;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.request.IPDIEventRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIListStackFramesRequest;
import org.eclipse.ptp.debug.core.sourcelookup.PSourceLookupDirector;
import org.eclipse.ptp.debug.internal.ui.AnnotationGroup;
import org.eclipse.ptp.debug.internal.ui.PDebugUIUtils;
import org.eclipse.ptp.debug.internal.ui.PInstructionPointerAnnotation2;
import org.eclipse.ptp.debug.internal.ui.UIDebugManager;
import org.eclipse.ptp.debug.ui.IPTPDebugUIConstants;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;
import org.eclipse.ptp.proxy.debug.client.ProxyDebugLocator;
import org.eclipse.ptp.proxy.debug.client.ProxyDebugStackFrame;
import org.eclipse.ptp.ui.listeners.IJobChangedListener;
import org.eclipse.ptp.ui.model.IElementSet;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class PAnnotationManager
implements IJobChangedListener,
IPDebugEventListener {
    private static PAnnotationManager instance = null;
    private final Object LOCK = new Object();
    protected Map<String, AnnotationGroup> annotationMap = Collections.synchronizedMap(new HashMap());
    protected UIDebugManager uiDebugManager = null;

    public PAnnotationManager(UIDebugManager uiDebugManager) {
        this.uiDebugManager = uiDebugManager;
        if (instance == null) {
            uiDebugManager.addJobChangedListener(this);
            PTPDebugCorePlugin.getDefault().addDebugEventListener((IPDebugEventListener)this);
            instance = this;
        }
    }

    public static PAnnotationManager getDefault() {
        if (instance == null) {
            instance = new PAnnotationManager(PTPDebugUIPlugin.getUIDebugManager());
        }
        return instance;
    }

    public void shutdown() {
        this.clearAllAnnotations();
        PTPDebugCorePlugin.getDefault().removeDebugEventListener((IPDebugEventListener)this);
        this.uiDebugManager.removeJobChangedListener(this);
        this.annotationMap = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearAllAnnotations() {
        Object object = this.LOCK;
        synchronized (object) {
            Iterator<AnnotationGroup> i = this.annotationMap.values().iterator();
            while (i.hasNext()) {
                i.next().removeAnnotations();
            }
            this.annotationMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAnnotationGroup(String job_id) {
        Object object = this.LOCK;
        synchronized (object) {
            AnnotationGroup annotationGroup = this.annotationMap.remove(job_id);
            if (annotationGroup != null) {
                annotationGroup.removeAnnotations();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putAnnotationGroup(String job_id, AnnotationGroup annotationGroup) {
        Object object = this.LOCK;
        synchronized (object) {
            this.annotationMap.put(job_id, annotationGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AnnotationGroup getAnnotationGroup(String job_id) {
        Object object = this.LOCK;
        synchronized (object) {
            return this.annotationMap.get(job_id);
        }
    }

    protected IEditorPart openEditor(final IWorkbenchPage page, final IEditorInput input, final String id) {
        final IEditorPart[] editor = new IEditorPart[1];
        Runnable r = new Runnable(){

            public void run() {
                try {
                    editor[0] = page.openEditor(input, id, false);
                }
                catch (PartInitException e) {
                    PTPDebugUIPlugin.errorDialog(PTPDebugUIPlugin.getActiveWorkbenchShell(), "Error", "Cannot open editor", e);
                }
            }
        };
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)r);
        return editor[0];
    }

    protected IEditorPart getEditorPart(final IFile file) {
        final IEditorPart[] editor = new IEditorPart[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                IEditorInput editorInput;
                IWorkbenchPage page = PTPDebugUIPlugin.getActiveWorkbenchWindow().getActivePage();
                IEditorPart editorPart = page.getActiveEditor();
                if (editorPart != null && (editorInput = editorPart.getEditorInput()) instanceof IFileEditorInput && ((IFileEditorInput)editorInput).getFile().equals((Object)file)) {
                    page.bringToTop((IWorkbenchPart)editorPart);
                    editor[0] = editorPart;
                    return;
                }
                if (editor[0] == null) {
                    IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                    int n = iEditorReferenceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IEditorInput editorInput2;
                        IEditorReference refs = iEditorReferenceArray[n2];
                        IEditorPart refEditor = refs.getEditor(false);
                        if (refEditor != null && (editorInput2 = refEditor.getEditorInput()) instanceof IFileEditorInput && ((IFileEditorInput)editorInput2).getFile().equals((Object)file)) {
                            page.bringToTop((IWorkbenchPart)refEditor);
                            editor[0] = refEditor;
                            return;
                        }
                        ++n2;
                    }
                }
                try {
                    editor[0] = page.openEditor(PDebugUIUtils.getEditorInput(file), PDebugUIUtils.getEditorId(file), false);
                }
                catch (PartInitException partInitException) {}
            }
        });
        return editor[0];
    }

    protected void displaySource(final ISourceLookupResult result) {
        UIJob uiJob = new UIJob("Display source editor..."){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IWorkbenchPage page = PTPDebugUIPlugin.getActiveWorkbenchWindow().getActivePage();
                if (!monitor.isCanceled() && result != null && page != null) {
                    DebugUITools.displaySource((ISourceLookupResult)result, (IWorkbenchPage)page);
                }
                return Status.OK_STATUS;
            }
        };
        uiJob.schedule();
    }

    protected IFile findFile(String filename) {
        return this.findFile((IPath)new Path(filename));
    }

    protected IFile findFile(IPath location) {
        IPath normalized = FileBuffers.normalizeLocation((IPath)location);
        if (normalized.segmentCount() >= 2) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(normalized);
        }
        return null;
    }

    protected ITextEditor getTextEditor(IEditorPart editorPart) {
        if (editorPart instanceof ITextEditor) {
            return (ITextEditor)editorPart;
        }
        return (ITextEditor)editorPart.getAdapter(ITextEditor.class);
    }

    protected IFile getFile(IEditorInput editorInput) {
        if (editorInput instanceof IFileEditorInput) {
            return ((IFileEditorInput)editorInput).getFile();
        }
        if (editorInput instanceof IStorageEditorInput) {
            try {
                return this.findFile(((IStorageEditorInput)editorInput).getStorage().getFullPath());
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        if (editorInput instanceof IStorage) {
            return this.findFile(((IStorage)editorInput).getName());
        }
        return null;
    }

    protected Position createPosition(int lineNumber, IDocument doc) {
        int length;
        int charStart;
        block4: {
            if (doc == null) {
                return null;
            }
            try {
                IRegion region = doc.getLineInformation(lineNumber - 1);
                charStart = region.getOffset();
                length = region.getLength();
                if (charStart >= 0) break block4;
                return null;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        return new Position(charStart, length);
    }

    protected BitList getTasks(IDebugTarget debugTarget) {
        if (debugTarget instanceof IPDebugTarget) {
            return ((IPDebugTarget)debugTarget).getTasks();
        }
        return null;
    }

    protected BitList getTasks(IThread thread) {
        return this.getTasks(thread.getDebugTarget());
    }

    protected boolean isRegisterType(String type) {
        return type.equals(IPTPDebugUIConstants.REG_ANN_INSTR_POINTER_CURRENT) || type.equals(IPTPDebugUIConstants.REG_ANN_INSTR_POINTER_SECONDARY);
    }

    protected void focusAnnotation(IEditorPart editorPart, IStackFrame stackFrame) throws CoreException {
        IRegion region;
        ITextEditor textEditor = this.getTextEditor(editorPart);
        int charStart = stackFrame.getCharStart();
        if (charStart > 0) {
            textEditor.selectAndReveal(charStart, 0);
            return;
        }
        int lineNumber = stackFrame.getLineNumber();
        if ((region = this.getLineInformation(textEditor, --lineNumber)) != null) {
            textEditor.selectAndReveal(region.getOffset(), 0);
        }
    }

    protected IRegion getLineInformation(ITextEditor editor, int lineNumber) {
        IDocumentProvider provider = editor.getDocumentProvider();
        IEditorInput input = editor.getEditorInput();
        try {
            provider.connect((Object)input);
        }
        catch (CoreException coreException) {
            return null;
        }
        try {
            IDocument document = provider.getDocument((Object)input);
            if (document != null) {
                IRegion iRegion = document.getLineInformation(lineNumber);
                return iRegion;
            }
        }
        catch (BadLocationException badLocationException) {
        }
        finally {
            provider.disconnect((Object)input);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnnotation(IEditorPart editorPart, IPStackFrame stackFrame) throws CoreException {
        IPStackFrame selectedFrame = stackFrame;
        BitList tasks = this.getTasks(stackFrame.getDebugTarget());
        if (tasks == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        ITextEditor textEditor = this.getTextEditor(editorPart);
        if (textEditor == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        IFile file = this.getFile(textEditor.getEditorInput());
        if (file == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (selectedFrame.getLineNumber() == 0) {
            IStackFrame[] frames;
            IStackFrame[] iStackFrameArray = frames = selectedFrame.getThread().getStackFrames();
            int n = frames.length;
            int n2 = 0;
            while (n2 < n) {
                IStackFrame frame = iStackFrameArray[n2];
                if (frame.getLineNumber() > 0) {
                    selectedFrame = (IPStackFrame)frame;
                    break;
                }
                ++n2;
            }
        }
        if (selectedFrame.getLineNumber() > 0) {
            String job_id = this.uiDebugManager.getCurrentJobId();
            Object object = this.LOCK;
            synchronized (object) {
                AnnotationGroup annotationGroup = this.getAnnotationGroup(job_id);
                if (annotationGroup == null) {
                    annotationGroup = new AnnotationGroup();
                    this.putAnnotationGroup(job_id, annotationGroup);
                }
                this.removeAnnotation(annotationGroup, tasks);
                this.addAnnotation(annotationGroup, textEditor, file, selectedFrame.getLineNumber(), tasks, selectedFrame.getLevel() > 1 ? IPTPDebugUIConstants.REG_ANN_INSTR_POINTER_SECONDARY : IPTPDebugUIConstants.REG_ANN_INSTR_POINTER_CURRENT);
            }
        }
    }

    private PSourceLookupDirector getSourceLocator(String job_id) {
        ISourceLocator locator;
        IPSession session = this.uiDebugManager.getDebugSession(job_id);
        if (session != null && (locator = session.getLaunch().getSourceLocator()) instanceof PSourceLookupDirector) {
            return (PSourceLookupDirector)locator;
        }
        return null;
    }

    private IPath getFilePath(String job_id, String filename) {
        PSourceLookupDirector locator = this.getSourceLocator(job_id);
        if (locator != null) {
            Object object = locator.getSourceElement((Object)filename);
            if (object instanceof IFile) {
                return ((IFile)object).getFullPath();
            }
            if (object instanceof LocalFileStorage) {
                return ((LocalFileStorage)object).getFullPath();
            }
            if (object instanceof FileStorage) {
                return ((FileStorage)object).getFullPath();
            }
        }
        return new Path(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addUnregisterAnnotation(String job_id, int level, String filename, int lineNumber, BitList tasks) throws CoreException {
        if (tasks.isEmpty()) {
            return;
        }
        IFile file = this.findFile(this.getFilePath(job_id, filename));
        if (file == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        IEditorPart editorPart = this.getEditorPart(file);
        if (editorPart == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        ITextEditor textEditor = this.getTextEditor(editorPart);
        if (textEditor == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        Object object = this.LOCK;
        synchronized (object) {
            AnnotationGroup annotationGroup = this.getAnnotationGroup(job_id);
            if (annotationGroup == null) {
                annotationGroup = new AnnotationGroup();
                this.putAnnotationGroup(job_id, annotationGroup);
            }
            this.addAnnotation(annotationGroup, textEditor, file, lineNumber, tasks, level > 1 ? IPTPDebugUIConstants.SET_ANN_INSTR_POINTER_CURRENT : (this.containsCurrentSet(tasks) ? IPTPDebugUIConstants.CURSET_ANN_INSTR_POINTER_CURRENT : IPTPDebugUIConstants.SET_ANN_INSTR_POINTER_CURRENT));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAnnotation(String job_id, int level, String filename, int lineNumber, BitList rTasks, BitList uTasks) throws CoreException {
        IFile file = this.findFile(this.getFilePath(job_id, filename));
        if (file == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        IEditorPart editorPart = this.getEditorPart(file);
        if (editorPart == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        ITextEditor textEditor = this.getTextEditor(editorPart);
        if (textEditor == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        Object object = this.LOCK;
        synchronized (object) {
            AnnotationGroup annotationGroup = this.getAnnotationGroup(job_id);
            if (annotationGroup == null) {
                annotationGroup = new AnnotationGroup();
                this.putAnnotationGroup(job_id, annotationGroup);
            }
            this.addAnnotation(annotationGroup, textEditor, file, lineNumber, rTasks, level > 1 ? IPTPDebugUIConstants.REG_ANN_INSTR_POINTER_SECONDARY : IPTPDebugUIConstants.REG_ANN_INSTR_POINTER_CURRENT);
            this.addAnnotation(annotationGroup, textEditor, file, lineNumber, uTasks, level > 1 ? IPTPDebugUIConstants.SET_ANN_INSTR_POINTER_CURRENT : (this.containsCurrentSet(uTasks) ? IPTPDebugUIConstants.CURSET_ANN_INSTR_POINTER_CURRENT : IPTPDebugUIConstants.SET_ANN_INSTR_POINTER_CURRENT));
        }
    }

    protected boolean containsCurrentSet(BitList aTasks) {
        String set_id = this.uiDebugManager.getCurrentSetId();
        if (set_id.equals("Root")) {
            return true;
        }
        try {
            BitList tasks = this.uiDebugManager.getTasks(set_id);
            return tasks != null && tasks.intersects(aTasks);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAnnotation(AnnotationGroup annotationGroup, final ITextEditor textEditor, IFile file, int lineNumber, BitList tasks, String type) throws CoreException {
        if (!tasks.isEmpty()) {
            IDocumentProvider docProvider = textEditor.getDocumentProvider();
            IAnnotationModel annotationModel = docProvider.getAnnotationModel((Object)textEditor.getEditorInput());
            if (annotationModel == null) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            final Position position = this.createPosition(lineNumber, docProvider.getDocument((Object)textEditor.getEditorInput()));
            if (position == null) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            Object object = this.LOCK;
            synchronized (object) {
                PInstructionPointerAnnotation2 annotation = this.findAnnotation(annotationGroup, position, type);
                if (annotation == null) {
                    annotation = new PInstructionPointerAnnotation2((IResource)file, type, position, annotationModel);
                    annotationGroup.addAnnotation(annotation);
                }
                annotation.addTasks(tasks);
                annotation.setMessage(this.isRegisterType(type));
            }
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    textEditor.selectAndReveal(position.getOffset(), 0);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PInstructionPointerAnnotation2 findAnnotation(AnnotationGroup annotationGroup, Position position, String type) {
        Object object = this.LOCK;
        synchronized (object) {
            PInstructionPointerAnnotation2[] pInstructionPointerAnnotation2Array = annotationGroup.getAnnotations();
            int n = pInstructionPointerAnnotation2Array.length;
            int n2 = 0;
            while (n2 < n) {
                PInstructionPointerAnnotation2 annotation = pInstructionPointerAnnotation2Array[n2];
                if (annotation.getPosition().equals((Object)position) && annotation.getType().equals(type)) {
                    return annotation;
                }
                ++n2;
            }
            return null;
        }
    }

    protected void removeAnnotation(IEditorPart editorPart, IPThread thread) throws CoreException {
        this.removeAnnotation(this.uiDebugManager.getCurrentJobId(), this.getTasks((IThread)thread));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAnnotation(String job_id, BitList tasks) throws CoreException {
        if (tasks == null || tasks.isEmpty()) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        Object object = this.LOCK;
        synchronized (object) {
            AnnotationGroup annotationGroup = this.getAnnotationGroup(job_id);
            if (annotationGroup != null) {
                this.removeAnnotation(annotationGroup, tasks);
                if (annotationGroup.isEmpty()) {
                    this.removeAnnotationGroup(job_id);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAnnotation(AnnotationGroup annotationGroup, BitList tasks) throws CoreException {
        Object object = this.LOCK;
        synchronized (object) {
            ArrayList<PInstructionPointerAnnotation2> removedList = new ArrayList<PInstructionPointerAnnotation2>(0);
            PInstructionPointerAnnotation2[] pInstructionPointerAnnotation2Array = annotationGroup.getAnnotations();
            int n = pInstructionPointerAnnotation2Array.length;
            int n2 = 0;
            while (n2 < n) {
                PInstructionPointerAnnotation2 annotation = pInstructionPointerAnnotation2Array[n2];
                annotation.removeTasks(tasks);
                if (annotation.isEmpty()) {
                    annotation.removeAnnotation();
                    removedList.add(annotation);
                } else {
                    annotation.setMessage(this.isRegisterType(annotation.getType()));
                }
                ++n2;
            }
            annotationGroup.removeAnnotations(removedList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PInstructionPointerAnnotation2[] findAnnotations(AnnotationGroup annotationGroup, String type) {
        Object object = this.LOCK;
        synchronized (object) {
            ArrayList<PInstructionPointerAnnotation2> foundAnnotations = new ArrayList<PInstructionPointerAnnotation2>();
            PInstructionPointerAnnotation2[] pInstructionPointerAnnotation2Array = annotationGroup.getAnnotations();
            int n = pInstructionPointerAnnotation2Array.length;
            int n2 = 0;
            while (n2 < n) {
                PInstructionPointerAnnotation2 annotation = pInstructionPointerAnnotation2Array[n2];
                if (annotation.getType().equals(type)) {
                    foundAnnotations.add(annotation);
                }
                ++n2;
            }
            return foundAnnotations.toArray(new PInstructionPointerAnnotation2[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PInstructionPointerAnnotation2[] findAnnotations(AnnotationGroup annotationGroup, BitList tasks) {
        Object object = this.LOCK;
        synchronized (object) {
            ArrayList<PInstructionPointerAnnotation2> foundAnnotations = new ArrayList<PInstructionPointerAnnotation2>();
            if (tasks.isEmpty()) {
                return new PInstructionPointerAnnotation2[0];
            }
            PInstructionPointerAnnotation2[] pInstructionPointerAnnotation2Array = annotationGroup.getAnnotations();
            int n = pInstructionPointerAnnotation2Array.length;
            int n2 = 0;
            while (n2 < n) {
                PInstructionPointerAnnotation2 annotation = pInstructionPointerAnnotation2Array[n2];
                if (!annotation.isMarkDeleted() && annotation.contains(tasks) && !foundAnnotations.contains(annotation)) {
                    foundAnnotations.add(annotation);
                }
                ++n2;
            }
            return foundAnnotations.toArray(new PInstructionPointerAnnotation2[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PInstructionPointerAnnotation2 findOtherTypeAnnotation(AnnotationGroup annotationGroup, Position position, boolean isRegister) {
        Object object = this.LOCK;
        synchronized (object) {
            PInstructionPointerAnnotation2[] pInstructionPointerAnnotation2Array = annotationGroup.getAnnotations();
            int n = pInstructionPointerAnnotation2Array.length;
            int n2 = 0;
            while (n2 < n) {
                PInstructionPointerAnnotation2 annotation = pInstructionPointerAnnotation2Array[n2];
                if (annotation.getPosition().equals((Object)position)) {
                    String annotationType = annotation.getType();
                    if (isRegister) {
                        if (annotationType.equals(IPTPDebugUIConstants.CURSET_ANN_INSTR_POINTER_CURRENT) || annotationType.equals(IPTPDebugUIConstants.SET_ANN_INSTR_POINTER_CURRENT)) {
                            return annotation;
                        }
                    } else if (annotationType.equals(IPTPDebugUIConstants.REG_ANN_INSTR_POINTER_CURRENT) || annotationType.equals(IPTPDebugUIConstants.REG_ANN_INSTR_POINTER_SECONDARY)) {
                        return annotation;
                    }
                }
                ++n2;
            }
            return null;
        }
    }

    protected void changeAnnotationType(PInstructionPointerAnnotation2 annotation, String type) {
        if (!annotation.getType().equals(type)) {
            annotation.setType(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void register(String job_id, BitList tasks) {
        Object object = this.LOCK;
        synchronized (object) {
            AnnotationGroup annotationGroup = this.getAnnotationGroup(job_id);
            if (annotationGroup != null) {
                PInstructionPointerAnnotation2[] pInstructionPointerAnnotation2Array = this.findAnnotations(annotationGroup, tasks);
                int n = pInstructionPointerAnnotation2Array.length;
                int n2 = 0;
                while (n2 < n) {
                    PInstructionPointerAnnotation2 annotation = pInstructionPointerAnnotation2Array[n2];
                    BitList cpTasks = tasks.copy();
                    cpTasks.and(annotation.getTasks());
                    if (!cpTasks.isEmpty()) {
                        this.updateExistedAnnotation(annotationGroup, annotation, cpTasks, false);
                    }
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregister(String job_id, BitList tasks) {
        Object object = this.LOCK;
        synchronized (object) {
            AnnotationGroup annotationGroup = this.getAnnotationGroup(job_id);
            if (annotationGroup != null) {
                PInstructionPointerAnnotation2[] pInstructionPointerAnnotation2Array = this.findAnnotations(annotationGroup, tasks);
                int n = pInstructionPointerAnnotation2Array.length;
                int n2 = 0;
                while (n2 < n) {
                    PInstructionPointerAnnotation2 annotation = pInstructionPointerAnnotation2Array[n2];
                    BitList cpTasks = tasks.copy();
                    cpTasks.and(annotation.getTasks());
                    if (!cpTasks.isEmpty()) {
                        this.updateExistedAnnotation(annotationGroup, annotation, cpTasks, true);
                    }
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateExistedAnnotation(AnnotationGroup annotationGroup, PInstructionPointerAnnotation2 annotation, BitList tasks, boolean isRegister) {
        Object object = this.LOCK;
        synchronized (object) {
            IResource file = annotation.getMakerResource();
            Position position = annotation.getPosition();
            annotation.removeTasks(tasks);
            if (annotation.isEmpty()) {
                annotation.removeAnnotation();
                annotationGroup.removeAnnotation(annotation);
            } else {
                annotation.setMessage(isRegister);
            }
            PInstructionPointerAnnotation2 oAnnotation = this.findOtherTypeAnnotation(annotationGroup, position, isRegister);
            if (oAnnotation != null) {
                oAnnotation.addTasks(tasks);
                oAnnotation.setMessage(!isRegister);
            } else {
                String type = IPTPDebugUIConstants.CURSET_ANN_INSTR_POINTER_CURRENT;
                oAnnotation = new PInstructionPointerAnnotation2(file, type, position, annotation.getAnnotationModel());
                annotationGroup.addAnnotation(oAnnotation);
                oAnnotation.addTasks(tasks);
                oAnnotation.setMessage(!isRegister);
            }
        }
    }

    public void updateAnnotation(final IElementSet currentSet, IElementSet preSet) {
        WorkbenchJob uiJob = new WorkbenchJob("Updating annotation..."){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IStatus runInUIThread(IProgressMonitor monitor) {
                AnnotationGroup annotationGroup = PAnnotationManager.this.getAnnotationGroup(PAnnotationManager.this.uiDebugManager.getCurrentJobId());
                if (annotationGroup != null) {
                    try {
                        BitList tasks = PAnnotationManager.this.uiDebugManager.getTasks(currentSet.getID());
                        Object object = PAnnotationManager.this.LOCK;
                        synchronized (object) {
                            PInstructionPointerAnnotation2[] pInstructionPointerAnnotation2Array = annotationGroup.getAnnotations();
                            int n = pInstructionPointerAnnotation2Array.length;
                            int n2 = 0;
                            while (n2 < n) {
                                PInstructionPointerAnnotation2 annotation = pInstructionPointerAnnotation2Array[n2];
                                if (!PAnnotationManager.this.isRegisterType(annotation.getType())) {
                                    if (currentSet.isRootSet()) {
                                        PAnnotationManager.this.changeAnnotationType(annotation, IPTPDebugUIConstants.CURSET_ANN_INSTR_POINTER_CURRENT);
                                    } else {
                                        PAnnotationManager.this.changeAnnotationType(annotation, annotation.contains(tasks) ? IPTPDebugUIConstants.CURSET_ANN_INSTR_POINTER_CURRENT : IPTPDebugUIConstants.SET_ANN_INSTR_POINTER_CURRENT);
                                    }
                                }
                                ++n2;
                            }
                        }
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        uiJob.setSystem(true);
        uiJob.setPriority(10);
        uiJob.schedule();
    }

    public void jobChangedEvent(final int type, final String cur_job_id, final String pre_job_id) {
        WorkbenchJob uiJob = new WorkbenchJob("Updating annotation..."){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                PAnnotationManager.this.doJobChangedEvent(type, cur_job_id, pre_job_id, monitor);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        uiJob.setSystem(true);
        uiJob.setPriority(10);
        uiJob.schedule();
    }

    private void doJobChangedEvent(int type, String cur_job_id, String pre_job_id, IProgressMonitor monitor) {
        AnnotationGroup curAnnotationGroup;
        AnnotationGroup preAnnotationGroup;
        if ((type == 1 || pre_job_id != null && !pre_job_id.equals("")) && (preAnnotationGroup = this.getAnnotationGroup(pre_job_id)) != null) {
            preAnnotationGroup.throwAllAnnotations();
        }
        if (cur_job_id != null && (curAnnotationGroup = this.getAnnotationGroup(cur_job_id)) != null) {
            curAnnotationGroup.retrieveAllAnnontations();
        }
    }

    public void handleDebugEvent(final IPDebugEvent event) {
        WorkbenchJob uiJob = new WorkbenchJob("Updating annotation..."){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                PAnnotationManager.this.doHandleDebugEvent(event, monitor);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        uiJob.setSystem(true);
        uiJob.setPriority(10);
        uiJob.schedule();
    }

    private void doHandleDebugEvent(IPDebugEvent event, IProgressMonitor monitor) {
        IPDebugInfo info = event.getInfo();
        IPJob job = info.getJob();
        block1 : switch (event.getKind()) {
            case 4: {
                switch (event.getDetail()) {
                    case 2048: {
                        this.register(job.getID(), info.getAllTasks());
                        break block1;
                    }
                }
                break;
            }
            case 8: {
                switch (event.getDetail()) {
                    case 1024: {
                        this.removeAnnotationGroup(job.getID());
                        break block1;
                    }
                    case 2048: {
                        this.unregister(job.getID(), info.getAllTasks());
                        break block1;
                    }
                    case 16: {
                        break block1;
                    }
                }
                this.removeAnnotationAction(job, info.getAllTasks());
                break;
            }
            case 1: {
                this.removeAnnotationAction(job, info.getAllTasks());
                break;
            }
            case 2: {
                IPDebugSuspendInfo susInfo = (IPDebugSuspendInfo)info;
                try {
                    this.addAnnotation(job, susInfo);
                }
                catch (CoreException e) {
                    PTPDebugUIPlugin.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            PTPDebugUIPlugin.errorDialog("Error", e);
                        }
                    });
                }
                break;
            }
            case 16: {
                break;
            }
        }
    }

    private void addAnnotation(IPJob job, IPDebugSuspendInfo info) throws CoreException {
        int line = info.getLineNumber();
        if (line == 0) {
            this.addAnnotationWithSourceFound(job, info.getAllUnregisteredTasks(), info.getLevel() + 1, info.getDepth());
        } else {
            this.addAnnotation(job.getID(), info.getLevel(), info.getFilename(), line, info.getAllRegisteredTasks(), info.getAllUnregisteredTasks());
        }
    }

    private void addAnnotationWithSourceFound(IPJob job, BitList tasks, int low, int high) throws CoreException {
        if (tasks.isEmpty()) {
            return;
        }
        IPSession session = this.uiDebugManager.getDebugSession(job);
        if (session != null) {
            if (!session.isReady()) {
                return;
            }
            IPDIListStackFramesRequest request = session.getPDISession().getRequestFactory().getListStackFramesRequest(session.getPDISession(), tasks, low, high);
            try {
                session.getPDISession().getEventRequestManager().addEventRequest((IPDIEventRequest)request);
                Map map = request.getResultMap(tasks);
                block2: for (BitList sTasks : map.keySet()) {
                    ProxyDebugStackFrame[] frames;
                    Object value = map.get(sTasks);
                    if (!(value instanceof ProxyDebugStackFrame[])) continue;
                    ProxyDebugStackFrame[] proxyDebugStackFrameArray = frames = (ProxyDebugStackFrame[])value;
                    int n = frames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ProxyDebugStackFrame frame = proxyDebugStackFrameArray[n2];
                        ProxyDebugLocator locator = frame.getLocator();
                        if (locator.getLineNumber() > 0) {
                            this.addUnregisterAnnotation(job.getID(), frame.getLevel(), locator.getFile(), locator.getLineNumber(), sTasks);
                            continue block2;
                        }
                        ++n2;
                    }
                }
            }
            catch (PDIException pDIException) {}
        }
    }

    private void removeAnnotationAction(IPJob job, BitList tasks) {
        try {
            this.removeAnnotation(job.getID(), tasks);
        }
        catch (CoreException e) {
            PTPDebugUIPlugin.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    PTPDebugUIPlugin.errorDialog("Error", e);
                }
            });
        }
    }
}

