/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import java.util.List;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDirective;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.parser.CodeReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncludeFileContent {
    private final InclusionKind fKind;
    private final CodeReader fCodeReader;
    private final List<IIndexMacro> fMacroDefinitions;
    private final List<ICPPUsingDirective> fUsingDirectives;
    private final String fFileLocation;
    private List<IIndexFile> fFiles;

    public IncludeFileContent(String fileLocation, InclusionKind kind) throws IllegalArgumentException {
        if (fileLocation == null || kind != InclusionKind.SKIP_FILE) {
            throw new IllegalArgumentException();
        }
        this.fKind = kind;
        this.fFileLocation = fileLocation;
        this.fMacroDefinitions = null;
        this.fUsingDirectives = null;
        this.fCodeReader = null;
    }

    public IncludeFileContent(CodeReader codeReader) throws IllegalArgumentException {
        if (codeReader == null) {
            throw new IllegalArgumentException();
        }
        this.fKind = InclusionKind.USE_CODE_READER;
        this.fFileLocation = codeReader.getPath();
        this.fCodeReader = codeReader;
        this.fMacroDefinitions = null;
        this.fUsingDirectives = null;
        if (this.fFileLocation == null) {
            throw new IllegalArgumentException();
        }
    }

    public IncludeFileContent(String fileLocation, List<IIndexMacro> macroDefinitions, List<ICPPUsingDirective> usingDirectives, List<IIndexFile> files) {
        this.fKind = InclusionKind.FOUND_IN_INDEX;
        this.fFileLocation = fileLocation;
        this.fCodeReader = null;
        this.fUsingDirectives = usingDirectives;
        this.fMacroDefinitions = macroDefinitions;
        this.fFiles = files;
    }

    public InclusionKind getKind() {
        return this.fKind;
    }

    public String getFileLocation() {
        return this.fFileLocation;
    }

    public CodeReader getCodeReader() {
        return this.fCodeReader;
    }

    public List<IIndexMacro> getMacroDefinitions() {
        return this.fMacroDefinitions;
    }

    public List<ICPPUsingDirective> getUsingDirectives() {
        return this.fUsingDirectives;
    }

    public List<IIndexFile> getFilesIncluded() {
        return this.fFiles;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InclusionKind {
        SKIP_FILE,
        FOUND_IN_INDEX,
        USE_CODE_READER;

    }
}

